/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.runtime.threadpool;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.runtime.threadpool.BLangThreadFactory;

public class ThreadPoolFactory {
    private static final int DEFAULT_THREAD_POOL_SIZE = 100;
    private static final String WORKER_THREAD_POOL_SIZE_PROP = "worker.thread.pool.size";
    private static ThreadPoolFactory instance = new ThreadPoolFactory();
    private ExecutorService workerExecutor;

    private ThreadPoolFactory() {
        int poolSize = 100;
        String workerThreadPoolSizeProp = ConfigRegistry.getInstance().getConfiguration(WORKER_THREAD_POOL_SIZE_PROP);
        if (workerThreadPoolSizeProp != null) {
            try {
                poolSize = Integer.parseInt(workerThreadPoolSizeProp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.workerExecutor = Executors.newFixedThreadPool(poolSize, new BLangThreadFactory(new ThreadGroup("worker"), "worker-thread-pool"));
    }

    public static ThreadPoolFactory getInstance() {
        return instance;
    }

    public ExecutorService getWorkerExecutor() {
        return this.workerExecutor;
    }
}

