/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util;

import java.sql.Array;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.DataIterator;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBooleanArray;
import org.ballerinalang.model.values.BFloatArray;
import org.ballerinalang.model.values.BIntArray;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BXMLItem;
import org.ballerinalang.util.TableResourceManager;
import org.ballerinalang.util.exceptions.BallerinaException;

public class TableIterator
implements DataIterator {
    protected ResultSet rs;
    protected TableResourceManager resourceManager;
    protected BStructType type;
    protected List<ColumnDefinition> columnDefs;

    public TableIterator(TableResourceManager rm, ResultSet rs, BStructType type, List<ColumnDefinition> columnDefs) {
        this.resourceManager = rm;
        this.rs = rs;
        this.type = type;
        this.columnDefs = columnDefs;
    }

    public TableIterator(TableResourceManager rm, ResultSet rs, BStructType type) {
        this.resourceManager = rm;
        this.rs = rs;
        this.type = type;
        this.generateColumnDefinitions();
    }

    @Override
    public boolean next() {
        if (this.rs == null) {
            return false;
        }
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public void close(boolean isInTransaction) {
        try {
            if (this.rs != null && !this.rs.isClosed()) {
                this.rs.close();
            }
            this.resourceManager.releaseResources();
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public String getString(int columnIndex) {
        try {
            return this.rs.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public long getInt(int columnIndex) {
        try {
            return this.rs.getLong(columnIndex);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public double getFloat(int columnIndex) {
        try {
            return this.rs.getDouble(columnIndex);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        try {
            return this.rs.getBoolean(columnIndex);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public String getBlob(int columnIndex) {
        try {
            Blob bValue = this.rs.getBlob(columnIndex);
            byte[] bdata = bValue.getBytes(1L, (int)bValue.length());
            return new String(bdata);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public Object[] getStruct(int columnIndex) {
        Object[] objArray = null;
        try {
            Struct data = (Struct)this.rs.getObject(columnIndex);
            if (data != null) {
                objArray = data.getAttributes();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
        return objArray;
    }

    @Override
    public Object[] getArray(int columnIndex) {
        try {
            return this.generateArrayDataResult(this.rs.getArray(columnIndex));
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    private Object[] generateArrayDataResult(Array array) throws SQLException {
        Object[] objArray = null;
        if (!this.rs.wasNull()) {
            objArray = (Object[])array.getArray();
        }
        return objArray;
    }

    @Override
    public BStruct generateNext() {
        BStruct bStruct = new BStruct(this.type);
        int longRegIndex = -1;
        int doubleRegIndex = -1;
        int stringRegIndex = -1;
        int booleanRegIndex = -1;
        int refRegIndex = -1;
        int blobRegIndex = -1;
        int index = 0;
        try {
            BStructType.StructField[] structFields;
            block12: for (BStructType.StructField sf : structFields = this.type.getStructFields()) {
                BType type = sf.getFieldType();
                ++index;
                switch (type.getTag()) {
                    case 1: {
                        long iValue = this.rs.getInt(index);
                        bStruct.setIntField(++longRegIndex, iValue);
                        continue block12;
                    }
                    case 3: {
                        String sValue = this.rs.getString(index);
                        bStruct.setStringField(++stringRegIndex, sValue);
                        continue block12;
                    }
                    case 2: {
                        double dalue = this.rs.getDouble(index);
                        bStruct.setFloatField(++doubleRegIndex, dalue);
                        continue block12;
                    }
                    case 4: {
                        boolean boolValue = this.rs.getBoolean(index);
                        bStruct.setBooleanField(++booleanRegIndex, boolValue ? 1 : 0);
                        continue block12;
                    }
                    case 9: {
                        String jsonValue = this.rs.getString(index);
                        bStruct.setRefField(++refRegIndex, new BJSON(jsonValue));
                        continue block12;
                    }
                    case 8: {
                        String xmlValue = this.rs.getString(index);
                        bStruct.setRefField(++refRegIndex, new BXMLItem(xmlValue));
                        continue block12;
                    }
                    case 5: {
                        Blob blobValue = this.rs.getBlob(index);
                        bStruct.setBlobField(++blobRegIndex, blobValue.getBytes(1L, (int)blobValue.length()));
                        continue block12;
                    }
                    case 16: {
                        Array arrayValue = this.rs.getArray(index);
                        bStruct.setRefField(++refRegIndex, this.getDataArray(arrayValue));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in generating next row of data :" + e.getMessage());
        }
        return bStruct;
    }

    @Override
    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefs;
    }

    @Override
    public BStructType getStructType() {
        return this.type;
    }

    protected BNewArray getDataArray(Array array) throws SQLException {
        Object[] dataArray = this.generateArrayDataResult(array);
        if (dataArray == null || dataArray.length == 0) {
            return null;
        }
        Object obj = dataArray[0];
        int length = dataArray.length;
        if (obj instanceof String) {
            BStringArray stringDataArray = new BStringArray();
            for (int i = 0; i < length; ++i) {
                stringDataArray.add(i, (String)dataArray[i]);
            }
            return stringDataArray;
        }
        if (obj instanceof Boolean) {
            BBooleanArray boolDataArray = new BBooleanArray();
            for (int i = 0; i < length; ++i) {
                boolDataArray.add(i, (Boolean)dataArray[i] != false ? 1 : 0);
            }
            return boolDataArray;
        }
        if (obj instanceof Integer) {
            BIntArray intDataArray = new BIntArray();
            for (int i = 0; i < length; ++i) {
                intDataArray.add(i, ((Integer)dataArray[i]).intValue());
            }
            return intDataArray;
        }
        if (obj instanceof Long) {
            BIntArray longDataArray = new BIntArray();
            for (int i = 0; i < length; ++i) {
                longDataArray.add(i, (Long)dataArray[i]);
            }
            return longDataArray;
        }
        if (obj instanceof Float) {
            BFloatArray floatDataArray = new BFloatArray();
            for (int i = 0; i < length; ++i) {
                floatDataArray.add(i, ((Float)dataArray[i]).floatValue());
            }
            return floatDataArray;
        }
        if (obj instanceof Double) {
            BFloatArray doubleDataArray = new BFloatArray();
            for (int i = 0; i < dataArray.length; ++i) {
                doubleDataArray.add(i, (Double)dataArray[i]);
            }
            return doubleDataArray;
        }
        return null;
    }

    private void generateColumnDefinitions() {
        BStructType.StructField[] structFields = this.type.getStructFields();
        this.columnDefs = new ArrayList<ColumnDefinition>(structFields.length);
        for (BStructType.StructField sf : structFields) {
            BType type = sf.getFieldType();
            TypeKind typeKind = TypeKind.ANY;
            switch (type.getTag()) {
                case 1: {
                    typeKind = TypeKind.INT;
                    break;
                }
                case 3: {
                    typeKind = TypeKind.STRING;
                    break;
                }
                case 2: {
                    typeKind = TypeKind.FLOAT;
                    break;
                }
                case 4: {
                    typeKind = TypeKind.BOOLEAN;
                    break;
                }
                case 9: {
                    typeKind = TypeKind.JSON;
                    break;
                }
                case 8: {
                    typeKind = TypeKind.XML;
                    break;
                }
                case 5: {
                    typeKind = TypeKind.BLOB;
                    break;
                }
                case 16: {
                    typeKind = TypeKind.ARRAY;
                }
            }
            ColumnDefinition def = new ColumnDefinition(sf.fieldName, typeKind);
            this.columnDefs.add(def);
        }
    }
}

