/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util;

import java.io.ByteArrayInputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.values.BBlobArray;
import org.ballerinalang.model.values.BBooleanArray;
import org.ballerinalang.model.values.BFloatArray;
import org.ballerinalang.model.values.BIntArray;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

public class TableUtils {
    private static final String TABLE_OPERATION_ERROR = "TableOperationError";
    private static final String TABLE_PACKAGE_PATH = "ballerina.builtin";
    private static final String EXCEPTION_OCCURRED = "Exception occurred";

    public static String generateInsertDataStatment(String tableName, BStruct constrainedType) {
        StringBuilder sbSql = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        sbSql.append("INSERT INTO ").append(tableName).append(" (");
        BStructType.StructField[] structFields = constrainedType.getType().getStructFields();
        String sep = "";
        for (BStructType.StructField sf : structFields) {
            String name = sf.getFieldName();
            sbSql.append(sep).append(name).append(" ");
            sbValues.append(sep).append("?");
            sep = ",";
        }
        sbSql.append(") values (").append((CharSequence)sbValues).append(")");
        return sbSql.toString();
    }

    public static String generateDeleteDataStatment(String tableName, BStruct constrainedType) {
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("DELETE FROM ").append(tableName).append(" WHERE ");
        BStructType.StructField[] structFields = constrainedType.getType().getStructFields();
        String sep = "";
        for (BStructType.StructField sf : structFields) {
            String name = sf.getFieldName();
            sbSql.append(sep).append(name).append(" = ? ");
            sep = " AND ";
        }
        return sbSql.toString();
    }

    public static void prepareAndExecuteStatement(PreparedStatement stmt, BStruct constrainedType) {
        try {
            BStructType.StructField[] structFields = constrainedType.getType().getStructFields();
            int intFieldIndex = 0;
            int floatFieldIndex = 0;
            int stringFieldIndex = 0;
            int booleanFieldIndex = 0;
            int refFieldIndex = 0;
            int blobFieldIndex = 0;
            int index = 1;
            for (BStructType.StructField sf : structFields) {
                int type = sf.getFieldType().getTag();
                switch (type) {
                    case 1: {
                        stmt.setLong(index, constrainedType.getIntField(intFieldIndex));
                        ++intFieldIndex;
                        break;
                    }
                    case 3: {
                        stmt.setString(index, constrainedType.getStringField(stringFieldIndex));
                        ++stringFieldIndex;
                        break;
                    }
                    case 2: {
                        stmt.setDouble(index, constrainedType.getFloatField(floatFieldIndex));
                        ++floatFieldIndex;
                        break;
                    }
                    case 4: {
                        stmt.setBoolean(index, constrainedType.getBooleanField(booleanFieldIndex) == 1);
                        ++booleanFieldIndex;
                        break;
                    }
                    case 8: 
                    case 9: {
                        stmt.setString(index, constrainedType.getRefField(refFieldIndex).toString());
                        ++refFieldIndex;
                        break;
                    }
                    case 5: {
                        byte[] blobData = constrainedType.getBlobField(blobFieldIndex);
                        stmt.setBlob(index, new ByteArrayInputStream(blobData), blobData.length);
                        ++blobFieldIndex;
                        break;
                    }
                    case 16: {
                        Object[] arrayData = TableUtils.getArrayData(constrainedType.getRefField(refFieldIndex));
                        stmt.setObject(index, arrayData);
                        ++refFieldIndex;
                    }
                }
                ++index;
            }
            stmt.execute();
        }
        catch (SQLException e) {
            throw new BallerinaException("execute update failed: " + e.getMessage(), e);
        }
    }

    static Object[] getArrayData(BValue value) {
        Object[] arrayData;
        if (value == null) {
            return new Object[]{null};
        }
        int typeTag = ((BArrayType)value.getType()).getElementType().getTag();
        switch (typeTag) {
            case 1: {
                int arrayLength = (int)((BIntArray)value).size();
                arrayData = new Long[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BIntArray)value).get(i);
                }
                break;
            }
            case 2: {
                int arrayLength = (int)((BFloatArray)value).size();
                arrayData = new Double[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BFloatArray)value).get(i);
                }
                break;
            }
            case 3: {
                int arrayLength = (int)((BStringArray)value).size();
                arrayData = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BStringArray)value).get(i);
                }
                break;
            }
            case 4: {
                int arrayLength = (int)((BBooleanArray)value).size();
                arrayData = new Boolean[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BBooleanArray)value).get(i) > 0;
                }
                break;
            }
            case 5: {
                int arrayLength = (int)((BBlobArray)value).size();
                arrayData = new Blob[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BBlobArray)value).get(i);
                }
                break;
            }
            default: {
                throw new BallerinaException("unsupported data type for array parameter");
            }
        }
        return arrayData;
    }

    public static BStruct createTableOperationError(Context context, Throwable throwable) {
        PackageInfo tableLibPackage = context.getProgramFile().getPackageInfo(TABLE_PACKAGE_PATH);
        StructInfo errorStructInfo = tableLibPackage.getStructInfo(TABLE_OPERATION_ERROR);
        BStruct tableOperationError = new BStruct(errorStructInfo.getType());
        if (throwable.getMessage() == null) {
            tableOperationError.setStringField(0, EXCEPTION_OCCURRED);
        } else {
            tableOperationError.setStringField(0, throwable.getMessage());
        }
        return tableOperationError;
    }
}

