/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.util.ArrayList;
import java.util.Comparator;
import org.ballerinalang.bre.bvm.CPU;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.ErrorTableAttributeInfo;

public class ErrorTableEntry {
    protected int ipFrom;
    protected int ipTo;
    protected int ipTarget;
    protected int priority;
    protected int errorStructCPIndex = -100;
    private StructInfo error;
    private PackageInfo packageInfo;

    public ErrorTableEntry(int ipFrom, int ipTo, int ipTarget, int priority, int errorStructCPIndex) {
        this.ipFrom = ipFrom;
        this.ipTo = ipTo;
        this.ipTarget = ipTarget;
        this.priority = priority;
        this.errorStructCPIndex = errorStructCPIndex;
    }

    public int getIpFrom() {
        return this.ipFrom;
    }

    public int getIpTo() {
        return this.ipTo;
    }

    public int getIpTarget() {
        return this.ipTarget;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getErrorStructCPIndex() {
        return this.errorStructCPIndex;
    }

    public void setPackageInfo(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public StructInfo getError() {
        return this.error;
    }

    public void setError(StructInfo error) {
        this.error = error;
    }

    public boolean matchRange(int currentIP) {
        return currentIP >= this.ipFrom && currentIP <= this.ipTo;
    }

    public String toString() {
        return "\t\t" + this.ipFrom + "\t\t" + this.ipTo + "\t" + this.ipTarget + "\t\t" + (this.error != null ? this.error.getName() : "any");
    }

    public static ErrorTableEntry getMatch(PackageInfo packageInfo, int currentIP, BStruct error) {
        ErrorTableAttributeInfo errorTable = (ErrorTableAttributeInfo)packageInfo.getAttributeInfo(AttributeInfo.Kind.ERROR_TABLE);
        ArrayList errorTableEntries = errorTable != null ? errorTable.getErrorTableEntriesList() : new ArrayList();
        ArrayList rangeMatched = new ArrayList();
        errorTableEntries.stream().filter(errorTableEntry -> errorTableEntry.matchRange(currentIP)).forEach(errorTableEntry -> {
            MatchedEntry entry = new MatchedEntry();
            entry.errorTableEntry = errorTableEntry;
            entry.ipSize = errorTableEntry.ipTo - errorTableEntry.ipFrom;
            if (errorTableEntry.getErrorStructCPIndex() == -1) {
                entry.status = 2;
                rangeMatched.add(entry);
            } else if (errorTableEntry.getError().getType().equals(error.getType())) {
                entry.status = 0;
                rangeMatched.add(entry);
            } else if (CPU.checkStructEquivalency(error.getType(), errorTableEntry.getError().getType())) {
                entry.status = 1;
                rangeMatched.add(entry);
            }
        });
        if (rangeMatched.size() == 0) {
            return null;
        }
        if (rangeMatched.size() == 1) {
            return ((MatchedEntry)rangeMatched.get((int)0)).errorTableEntry;
        }
        MatchedEntry[] matchedEntries = (MatchedEntry[])rangeMatched.stream().sorted(Comparator.comparingInt(o -> o.ipSize)).toArray(MatchedEntry[]::new);
        int currentSize = 0;
        ErrorTableEntry errorTableEntry2 = null;
        for (int i = 0; i < matchedEntries.length; ++i) {
            MatchedEntry entry = matchedEntries[i];
            if (currentSize < entry.ipSize) {
                if (errorTableEntry2 == null) {
                    currentSize = entry.ipSize;
                } else {
                    return errorTableEntry2;
                }
            }
            if (entry.status == 0) {
                return entry.errorTableEntry;
            }
            if (errorTableEntry2 == null) {
                errorTableEntry2 = entry.errorTableEntry;
                continue;
            }
            if (errorTableEntry2.priority <= entry.errorTableEntry.priority) continue;
            errorTableEntry2 = entry.errorTableEntry;
        }
        return errorTableEntry2;
    }

    private static class MatchedEntry {
        protected ErrorTableEntry errorTableEntry;
        int status;
        int ipSize;

        private MatchedEntry() {
        }
    }
}

