/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BConnectorType;
import org.ballerinalang.model.types.BEnumType;
import org.ballerinalang.model.types.BFiniteType;
import org.ballerinalang.model.types.BFunctionType;
import org.ballerinalang.model.types.BJSONType;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BServiceType;
import org.ballerinalang.model.types.BStreamType;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BTableType;
import org.ballerinalang.model.types.BTupleType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.BUnionType;
import org.ballerinalang.model.util.Flags;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BEnumerator;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.natives.NativeUnitLoader;
import org.ballerinalang.util.codegen.ActionInfo;
import org.ballerinalang.util.codegen.AttachedFunctionInfo;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ConnectorInfo;
import org.ballerinalang.util.codegen.DefaultValue;
import org.ballerinalang.util.codegen.EnumInfo;
import org.ballerinalang.util.codegen.ErrorTableEntry;
import org.ballerinalang.util.codegen.ForkjoinInfo;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.Instruction;
import org.ballerinalang.util.codegen.InstructionFactory;
import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.codegen.LocalVariableInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.PackageVarInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ResourceInfo;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.codegen.StructFieldInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.codegen.TransformerInfo;
import org.ballerinalang.util.codegen.TypeDefinitionInfo;
import org.ballerinalang.util.codegen.WorkerDataChannelInfo;
import org.ballerinalang.util.codegen.WorkerInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfoPool;
import org.ballerinalang.util.codegen.attributes.CodeAttributeInfo;
import org.ballerinalang.util.codegen.attributes.DefaultValueAttributeInfo;
import org.ballerinalang.util.codegen.attributes.ErrorTableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.LineNumberTableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.LocalVariableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.ParamDefaultValueAttributeInfo;
import org.ballerinalang.util.codegen.attributes.VarTypeCountAttributeInfo;
import org.ballerinalang.util.codegen.cpentries.ActionRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.ConstantPool;
import org.ballerinalang.util.codegen.cpentries.ConstantPoolEntry;
import org.ballerinalang.util.codegen.cpentries.FloatCPEntry;
import org.ballerinalang.util.codegen.cpentries.ForkJoinCPEntry;
import org.ballerinalang.util.codegen.cpentries.FunctionCallCPEntry;
import org.ballerinalang.util.codegen.cpentries.FunctionRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.IntegerCPEntry;
import org.ballerinalang.util.codegen.cpentries.PackageRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.StringCPEntry;
import org.ballerinalang.util.codegen.cpentries.StructureRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.TransformerRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.TypeRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.UTF8CPEntry;
import org.ballerinalang.util.codegen.cpentries.WorkerDataChannelRefCPEntry;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.ballerinalang.util.exceptions.ProgramFileFormatException;

public class ProgramFileReader {
    private ProgramFile programFile;
    private List<ConstantPoolEntry> unresolvedCPEntries = new ArrayList<ConstantPoolEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramFile readProgram(Path programFilePath) throws IOException {
        try (InputStream fileIS = null;){
            this.programFile = new ProgramFile();
            this.programFile.setProgramFilePath(programFilePath);
            fileIS = Files.newInputStream(programFilePath, StandardOpenOption.READ, LinkOption.NOFOLLOW_LINKS);
            BufferedInputStream bufferedIS = new BufferedInputStream(fileIS);
            DataInputStream dataInStream = new DataInputStream(bufferedIS);
            ProgramFile programFile = this.readProgramInternal(dataInStream);
            return programFile;
        }
    }

    public ProgramFile readProgram(InputStream programFileInStream) throws IOException {
        this.programFile = new ProgramFile();
        DataInputStream dataInStream = new DataInputStream(programFileInStream);
        return this.readProgramInternal(dataInStream);
    }

    private ProgramFile readProgramInternal(DataInputStream dataInStream) throws IOException {
        int magicNumber = dataInStream.readInt();
        if (magicNumber != -1172462386) {
            throw new BLangRuntimeException("ballerina: invalid magic number " + magicNumber);
        }
        short version = dataInStream.readShort();
        if (version != 17) {
            throw new BLangRuntimeException("ballerina: unsupported program file version " + version);
        }
        this.programFile.setVersion(version);
        this.readConstantPool(dataInStream, this.programFile);
        this.readEntryPoint(dataInStream);
        int pkgInfoCount = dataInStream.readShort();
        for (int i = 0; i < pkgInfoCount; ++i) {
            this.readPackageInfo(dataInStream);
        }
        PackageInfo entryPkg = this.programFile.getPackageInfo(this.programFile.getEntryPkgName());
        this.programFile.setEntryPackage(entryPkg);
        entryPkg.setProgramFile(this.programFile);
        this.readAttributeInfoEntries(dataInStream, this.programFile, this.programFile);
        return this.programFile;
    }

    private void readConstantPool(DataInputStream dataInStream, ConstantPool constantPool) throws IOException {
        int constantPoolSize = dataInStream.readInt();
        for (int i = 0; i < constantPoolSize; ++i) {
            byte cpTag = dataInStream.readByte();
            ConstantPoolEntry.EntryType cpEntryType = ConstantPoolEntry.EntryType.values()[cpTag - 1];
            ConstantPoolEntry cpEntry = this.readCPEntry(dataInStream, constantPool, cpEntryType);
            constantPool.addCPEntry(cpEntry);
        }
    }

    private ConstantPoolEntry readCPEntry(DataInputStream dataInStream, ConstantPool constantPool, ConstantPoolEntry.EntryType cpEntryType) throws IOException {
        switch (cpEntryType) {
            case CP_ENTRY_UTF8: {
                short length = dataInStream.readShort();
                String strValue = null;
                if (length >= 0) {
                    strValue = dataInStream.readUTF();
                }
                return new UTF8CPEntry(strValue);
            }
            case CP_ENTRY_INTEGER: {
                long longVal = dataInStream.readLong();
                return new IntegerCPEntry(longVal);
            }
            case CP_ENTRY_FLOAT: {
                double doubleVal = dataInStream.readDouble();
                return new FloatCPEntry(doubleVal);
            }
            case CP_ENTRY_STRING: {
                int cpIndex = dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                return new StringCPEntry(cpIndex, utf8CPEntry.getValue());
            }
            case CP_ENTRY_PACKAGE: {
                int cpIndex = dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                int versionCPIndex = dataInStream.readInt();
                UTF8CPEntry utf8VersionCPEntry = (UTF8CPEntry)constantPool.getCPEntry(versionCPIndex);
                return new PackageRefCPEntry(cpIndex, utf8CPEntry.getValue(), versionCPIndex, utf8VersionCPEntry.getValue());
            }
            case CP_ENTRY_FUNCTION_REF: {
                int pkgCPIndex = dataInStream.readInt();
                PackageRefCPEntry packageRefCPEntry = (PackageRefCPEntry)constantPool.getCPEntry(pkgCPIndex);
                int cpIndex = dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                String funcName = utf8CPEntry.getValue();
                FunctionRefCPEntry functionRefCPEntry = new FunctionRefCPEntry(pkgCPIndex, packageRefCPEntry.getPackageName(), cpIndex, funcName);
                Optional<PackageInfo> packageInfoOptional = Optional.ofNullable(this.programFile.getPackageInfo(packageRefCPEntry.getPackageName()));
                Optional<FunctionInfo> funcInfoOptional = packageInfoOptional.map(packageInfo -> packageInfo.getFunctionInfo(funcName));
                if (!funcInfoOptional.isPresent()) {
                    this.unresolvedCPEntries.add(functionRefCPEntry);
                    return functionRefCPEntry;
                }
                functionRefCPEntry.setFunctionInfo(funcInfoOptional.get());
                return functionRefCPEntry;
            }
            case CP_ENTRY_TRANSFORMER_REF: {
                int pkgCPIndex = dataInStream.readInt();
                PackageRefCPEntry packageRefCPEntry = (PackageRefCPEntry)constantPool.getCPEntry(pkgCPIndex);
                int cpIndex = dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                String transformerName = utf8CPEntry.getValue();
                TransformerRefCPEntry transformerRefCPEntry = new TransformerRefCPEntry(pkgCPIndex, packageRefCPEntry.getPackageName(), cpIndex, transformerName);
                Optional<PackageInfo> packageInfoOptional = Optional.ofNullable(this.programFile.getPackageInfo(packageRefCPEntry.getPackageName()));
                Optional<TransformerInfo> transInfoOptional = packageInfoOptional.map(packageInfo -> packageInfo.getTransformerInfo(transformerName));
                if (!transInfoOptional.isPresent()) {
                    this.unresolvedCPEntries.add(transformerRefCPEntry);
                    return transformerRefCPEntry;
                }
                transformerRefCPEntry.setTransformerInfo(transInfoOptional.get());
                return transformerRefCPEntry;
            }
            case CP_ENTRY_ACTION_REF: {
                int pkgCPIndex = dataInStream.readInt();
                PackageRefCPEntry packageRefCPEntry = (PackageRefCPEntry)constantPool.getCPEntry(pkgCPIndex);
                int cpIndex = dataInStream.readInt();
                UTF8CPEntry nameCPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                String actionName = nameCPEntry.getValue();
                return new ActionRefCPEntry(pkgCPIndex, packageRefCPEntry.getPackageName(), cpIndex, actionName);
            }
            case CP_ENTRY_STRUCTURE_REF: {
                int pkgCPIndex = dataInStream.readInt();
                PackageRefCPEntry packageRefCPEntry = (PackageRefCPEntry)constantPool.getCPEntry(pkgCPIndex);
                int cpIndex = dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                StructureRefCPEntry structureRefCPEntry = new StructureRefCPEntry(pkgCPIndex, packageRefCPEntry.getPackageName(), cpIndex, utf8CPEntry.getValue());
                Optional<PackageInfo> packageInfoOptional = Optional.ofNullable(this.programFile.getPackageInfo(packageRefCPEntry.getPackageName()));
                Optional<StructureTypeInfo> structInfoOptional = packageInfoOptional.map(packageInfo -> packageInfo.getStructureTypeInfo(utf8CPEntry.getValue()));
                if (!structInfoOptional.isPresent()) {
                    this.unresolvedCPEntries.add(structureRefCPEntry);
                    return structureRefCPEntry;
                }
                structureRefCPEntry.setStructureTypeInfo(structInfoOptional.get());
                return structureRefCPEntry;
            }
            case CP_ENTRY_TYPE_REF: {
                int typeSigCPIndex = dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(typeSigCPIndex);
                TypeRefCPEntry typeRefCPEntry = new TypeRefCPEntry(typeSigCPIndex, utf8CPEntry.getValue());
                this.unresolvedCPEntries.add(typeRefCPEntry);
                return typeRefCPEntry;
            }
            case CP_ENTRY_FORK_JOIN: {
                int forkJoinCPIndex = dataInStream.readInt();
                return new ForkJoinCPEntry(forkJoinCPIndex);
            }
            case CP_ENTRY_WRKR_DATA_CHNL_REF: {
                int uniqueNameCPIndex = dataInStream.readInt();
                UTF8CPEntry wrkrDtChnlTypesSigCPEntry = (UTF8CPEntry)constantPool.getCPEntry(uniqueNameCPIndex);
                return new WorkerDataChannelRefCPEntry(uniqueNameCPIndex, wrkrDtChnlTypesSigCPEntry.getValue());
            }
        }
        throw new ProgramFileFormatException("invalid constant pool entry " + cpEntryType.getValue());
    }

    private void readEntryPoint(DataInputStream dataInStream) throws IOException {
        int pkdCPIndex = dataInStream.readInt();
        PackageRefCPEntry packageRefCPEntry = (PackageRefCPEntry)this.programFile.getCPEntry(pkdCPIndex);
        this.programFile.setEntryPkgCPIndex(pkdCPIndex);
        this.programFile.setEntryPkgName(packageRefCPEntry.getPackageName());
        byte flags = dataInStream.readByte();
        if ((flags & 1) == 1) {
            this.programFile.setMainEPAvailable(true);
        }
        if ((flags & 2) == 2) {
            this.programFile.setServiceEPAvailable(true);
        }
    }

    private void readPackageInfo(DataInputStream dataInStream) throws IOException {
        PackageInfo packageInfo = new PackageInfo();
        this.readConstantPool(dataInStream, packageInfo);
        int pkgNameCPIndex = dataInStream.readInt();
        UTF8CPEntry pkgNameCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(pkgNameCPIndex);
        packageInfo.nameCPIndex = pkgNameCPIndex;
        packageInfo.pkgPath = pkgNameCPEntry.getValue();
        int pkgVersionCPIndex = dataInStream.readInt();
        UTF8CPEntry pkgVersionCPEntry = (UTF8CPEntry)this.programFile.getCPEntry(pkgVersionCPIndex);
        packageInfo.versionCPIndex = pkgVersionCPIndex;
        packageInfo.pkgVersion = pkgVersionCPEntry.getValue();
        packageInfo.setProgramFile(this.programFile);
        this.programFile.addPackageInfo(packageInfo.pkgPath, packageInfo);
        this.readStructInfoEntries(dataInStream, packageInfo);
        this.readEnumInfoEntries(dataInStream, packageInfo);
        this.readTypeDefinitionInfoEntries(dataInStream, packageInfo);
        this.readConnectorInfoEntries(dataInStream, packageInfo);
        this.readServiceInfoEntries(dataInStream, packageInfo);
        this.resolveUserDefinedTypes(packageInfo);
        this.readConnectorActionInfoEntries(dataInStream, packageInfo);
        this.readResourceInfoEntries(dataInStream, packageInfo);
        this.readConstantInfoEntries(dataInStream, packageInfo);
        this.readGlobalVarInfoEntries(dataInStream, packageInfo);
        this.readFunctionInfoEntries(dataInStream, packageInfo);
        this.readTransformerInfoEntries(dataInStream, packageInfo);
        this.resolveCPEntries();
        this.resolveConnectorMethodTables(packageInfo);
        this.readAttributeInfoEntries(dataInStream, packageInfo, packageInfo);
        this.readInstructions(dataInStream, packageInfo);
        packageInfo.complete();
    }

    private void readStructInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int structCount = dataInStream.readShort();
        for (int i = 0; i < structCount; ++i) {
            int structNameCPIndex = dataInStream.readInt();
            int flags = dataInStream.readInt();
            UTF8CPEntry structNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(structNameCPIndex);
            String structName = structNameUTF8Entry.getValue();
            StructInfo structInfo = new StructInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), structNameCPIndex, structName, flags);
            packageInfo.addStructInfo(structName, structInfo);
            BStructType bStructType = new BStructType(structInfo, structName, packageInfo.getPkgPath(), flags);
            structInfo.setType(bStructType);
            int structFiledCount = dataInStream.readShort();
            for (int j = 0; j < structFiledCount; ++j) {
                int fieldNameCPIndex = dataInStream.readInt();
                UTF8CPEntry fieldNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(fieldNameCPIndex);
                int fieldTypeSigCPIndex = dataInStream.readInt();
                UTF8CPEntry fieldTypeSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(fieldTypeSigCPIndex);
                int fieldFlags = dataInStream.readInt();
                StructFieldInfo fieldInfo = new StructFieldInfo(fieldNameCPIndex, fieldNameUTF8Entry.getValue(), fieldTypeSigCPIndex, fieldTypeSigUTF8Entry.getValue(), fieldFlags);
                structInfo.addFieldInfo(fieldInfo);
                this.readAttributeInfoEntries(dataInStream, packageInfo, fieldInfo);
            }
            String defaultInit = structName + ".<init>";
            String objectInit = "new";
            int attachedFuncCount = dataInStream.readShort();
            for (int j = 0; j < attachedFuncCount; ++j) {
                int nameCPIndex = dataInStream.readInt();
                UTF8CPEntry nameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(nameCPIndex);
                String attachedFuncName = nameUTF8Entry.getValue();
                int typeSigCPIndex = dataInStream.readInt();
                UTF8CPEntry typeSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(typeSigCPIndex);
                int funcFlags = dataInStream.readInt();
                AttachedFunctionInfo functionInfo = new AttachedFunctionInfo(nameCPIndex, attachedFuncName, typeSigCPIndex, typeSigUTF8Entry.getValue(), funcFlags);
                structInfo.funcInfoEntries.put(functionInfo.name, functionInfo);
                if (structName.equals(attachedFuncName)) {
                    structInfo.initializer = functionInfo;
                }
                if (objectInit.equals(attachedFuncName)) {
                    structInfo.initializer = functionInfo;
                }
                if (!defaultInit.equals(attachedFuncName)) continue;
                structInfo.defaultsValuesInitFunc = functionInfo;
            }
            this.readAttributeInfoEntries(dataInStream, packageInfo, structInfo);
        }
    }

    private void readTypeDefinitionInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int typeDefCount = dataInStream.readShort();
        for (int i = 0; i < typeDefCount; ++i) {
            int typeDefNameCPIndex = dataInStream.readInt();
            int flags = dataInStream.readInt();
            UTF8CPEntry typeDefNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(typeDefNameCPIndex);
            String typeDefName = typeDefNameUTF8Entry.getValue();
            TypeDefinitionInfo typeDefinitionInfo = new TypeDefinitionInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), typeDefNameCPIndex, typeDefName, flags);
            packageInfo.addTypeDefinitionInfo(typeDefName, typeDefinitionInfo);
            BFiniteType finiteType = new BFiniteType(typeDefName, packageInfo.getPkgPath());
            typeDefinitionInfo.setType(finiteType);
            int memberTypeCount = dataInStream.readShort();
            for (int j = 0; j < memberTypeCount; ++j) {
                int memberTypeCPIndex = dataInStream.readInt();
                TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)packageInfo.getCPEntry(memberTypeCPIndex);
                finiteType.memberTypes.add(this.getBTypeFromDescriptor(typeRefCPEntry.getTypeSig()));
            }
            int valueSpaceCount = dataInStream.readShort();
            for (int k = 0; k < valueSpaceCount; ++k) {
                finiteType.valueSpace.add(this.getDefaultValueToBValue(this.getDefaultValue(dataInStream, packageInfo)));
            }
            this.readAttributeInfoEntries(dataInStream, packageInfo, typeDefinitionInfo);
        }
    }

    private void readEnumInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int enumCount = dataInStream.readShort();
        for (int i = 0; i < enumCount; ++i) {
            int enumNameCPIndex = dataInStream.readInt();
            int flags = dataInStream.readInt();
            UTF8CPEntry enumNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(enumNameCPIndex);
            String enumName = enumNameUTF8Entry.getValue();
            EnumInfo enumInfo = new EnumInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), enumNameCPIndex, enumName, flags);
            packageInfo.addEnumInfo(enumName, enumInfo);
            BEnumType enumType = new BEnumType(enumName, packageInfo.getPkgPath());
            enumInfo.setType(enumType);
            int enumeratorCount = dataInStream.readShort();
            BEnumerator[] enumerators = new BEnumerator[enumeratorCount];
            for (int j = 0; j < enumeratorCount; ++j) {
                BEnumerator enumerator;
                int enumeratorNameCPIndex = dataInStream.readInt();
                UTF8CPEntry enumeratorNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(enumeratorNameCPIndex);
                String enumeratorName = enumeratorNameUTF8Entry.getValue();
                enumerators[j] = enumerator = new BEnumerator(enumeratorName, enumType);
            }
            enumType.setEnumerators(enumerators);
            this.readAttributeInfoEntries(dataInStream, packageInfo, enumInfo);
        }
    }

    private void readConnectorInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int connectorCount = dataInStream.readShort();
        for (int i = 0; i < connectorCount; ++i) {
            int connectorNameCPIndex = dataInStream.readInt();
            UTF8CPEntry connectorNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(connectorNameCPIndex);
            int flags = dataInStream.readInt();
            String connectorName = connectorNameUTF8Entry.getValue();
            ConnectorInfo connectorInfo = new ConnectorInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), connectorNameCPIndex, connectorName, flags);
            packageInfo.addConnectorInfo(connectorName, connectorInfo);
            BConnectorType bConnectorType = new BConnectorType(connectorName, packageInfo.getPkgPath());
            connectorInfo.setType(bConnectorType);
        }
    }

    private void readConnectorActionInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        for (ConnectorInfo connectorInfo : packageInfo.getConnectorInfoEntries()) {
            int actionCount = dataInStream.readShort();
            for (int j = 0; j < actionCount; ++j) {
                int actionNameCPIndex = dataInStream.readInt();
                UTF8CPEntry actionNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(actionNameCPIndex);
                String actionName = actionNameUTF8Entry.getValue();
                ActionInfo actionInfo = new ActionInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), actionNameCPIndex, actionName, connectorInfo);
                actionInfo.setPackageInfo(packageInfo);
                connectorInfo.addActionInfo(actionName, actionInfo);
                int actionSigCPIndex = dataInStream.readInt();
                UTF8CPEntry actionSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(actionSigCPIndex);
                actionInfo.setSignatureCPIndex(actionSigCPIndex);
                actionInfo.setSignature(actionSigUTF8Entry.getValue());
                int flags = dataInStream.readInt();
                this.setCallableUnitSignature(actionInfo, actionSigUTF8Entry.getValue(), packageInfo);
                boolean nativeAction = dataInStream.readByte() == 1;
                actionInfo.setNative(nativeAction);
                int workerDataChannelsLength = dataInStream.readShort();
                for (int k = 0; k < workerDataChannelsLength; ++k) {
                    this.readWorkerDataChannelEntries(dataInStream, packageInfo, actionInfo);
                }
                this.readWorkerInfoEntries(dataInStream, packageInfo, actionInfo);
                if (nativeAction) {
                    NativeCallableUnit nativeActionObj = NativeUnitLoader.getInstance().loadNativeAction(actionInfo.getPkgPath(), actionInfo.getConnectorInfo().getName(), actionInfo.getName());
                    if (nativeActionObj == null && !actionInfo.name.equals("<init>")) {
                        throw new BLangRuntimeException("native action not available " + actionInfo.getPkgPath() + ":" + actionInfo.getConnectorInfo().getName() + "." + actionName);
                    }
                    actionInfo.setNativeCallableUnit(nativeActionObj);
                }
                this.readAttributeInfoEntries(dataInStream, packageInfo, actionInfo);
            }
            this.readAttributeInfoEntries(dataInStream, packageInfo, connectorInfo);
        }
    }

    private void readServiceInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int serviceCount = dataInStream.readShort();
        for (int i = 0; i < serviceCount; ++i) {
            int serviceNameCPIndex = dataInStream.readInt();
            UTF8CPEntry serviceNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(serviceNameCPIndex);
            int flags = dataInStream.readInt();
            int endpointNameCPIndex = dataInStream.readInt();
            UTF8CPEntry endpointNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(endpointNameCPIndex);
            ServiceInfo serviceInfo = new ServiceInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), serviceNameCPIndex, serviceNameUTF8Entry.getValue(), flags, endpointNameCPIndex, endpointNameUTF8Entry.getValue());
            serviceInfo.setPackageInfo(packageInfo);
            packageInfo.addServiceInfo(serviceInfo.getName(), serviceInfo);
            serviceInfo.setType(new BServiceType(serviceInfo.getName(), packageInfo.getPkgPath()));
        }
    }

    private void readResourceInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        for (ServiceInfo serviceInfo : packageInfo.getServiceInfoEntries()) {
            int actionCount = dataInStream.readShort();
            for (int j = 0; j < actionCount; ++j) {
                int resNameCPIndex = dataInStream.readInt();
                UTF8CPEntry resNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(resNameCPIndex);
                String resName = resNameUTF8Entry.getValue();
                ResourceInfo resourceInfo = new ResourceInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), resNameCPIndex, resName);
                resourceInfo.setServiceInfo(serviceInfo);
                resourceInfo.setPackageInfo(packageInfo);
                serviceInfo.addResourceInfo(resName, resourceInfo);
                int resSigCPIndex = dataInStream.readInt();
                resourceInfo.setSignatureCPIndex(resSigCPIndex);
                UTF8CPEntry resSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(resSigCPIndex);
                String resSig = resSigUTF8Entry.getValue();
                resourceInfo.setSignature(resSig);
                this.setCallableUnitSignature(resourceInfo, resSig, packageInfo);
                int paramNameCPIndexesCount = dataInStream.readShort();
                int[] paramNameCPIndexes = new int[paramNameCPIndexesCount];
                String[] paramNames = new String[paramNameCPIndexesCount];
                for (int k = 0; k < paramNameCPIndexesCount; ++k) {
                    int paramNameCPIndex;
                    paramNameCPIndexes[k] = paramNameCPIndex = dataInStream.readInt();
                    UTF8CPEntry paramNameCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(paramNameCPIndex);
                    paramNames[k] = paramNameCPEntry.getValue();
                }
                resourceInfo.setParamNameCPIndexes(paramNameCPIndexes);
                resourceInfo.setParamNames(paramNames);
                int workerDataChannelsLength = dataInStream.readShort();
                for (int k = 0; k < workerDataChannelsLength; ++k) {
                    this.readWorkerDataChannelEntries(dataInStream, packageInfo, resourceInfo);
                }
                this.readWorkerInfoEntries(dataInStream, packageInfo, resourceInfo);
                this.readAttributeInfoEntries(dataInStream, packageInfo, resourceInfo);
            }
            this.readAttributeInfoEntries(dataInStream, packageInfo, serviceInfo);
        }
    }

    private void readConstantInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int constCount = dataInStream.readShort();
        for (int i = 0; i < constCount; ++i) {
            PackageVarInfo packageVarInfo = this.getGlobalVarInfo(dataInStream, packageInfo);
            packageInfo.addConstantInfo(packageVarInfo.getName(), packageVarInfo);
        }
    }

    private void readGlobalVarInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int globalVarCount = dataInStream.readShort();
        for (int i = 0; i < globalVarCount; ++i) {
            PackageVarInfo packageVarInfo = this.getGlobalVarInfo(dataInStream, packageInfo);
            packageInfo.addPackageVarInfo(packageVarInfo.getName(), packageVarInfo);
        }
    }

    private PackageVarInfo getGlobalVarInfo(DataInputStream dataInStream, ConstantPool constantPool) throws IOException {
        int nameCPIndex = dataInStream.readInt();
        UTF8CPEntry nameUTF8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(nameCPIndex);
        int sigCPIndex = dataInStream.readInt();
        UTF8CPEntry sigUTF8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(sigCPIndex);
        int globalMemIndex = dataInStream.readInt();
        PackageVarInfo packageVarInfo = new PackageVarInfo(nameCPIndex, nameUTF8CPEntry.getValue(), sigCPIndex, sigUTF8CPEntry.getValue(), globalMemIndex);
        this.readAttributeInfoEntries(dataInStream, constantPool, packageVarInfo);
        return packageVarInfo;
    }

    private void readFunctionInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        ServiceInfo[] serviceInfoEntries;
        int funcCount = dataInStream.readShort();
        for (int i = 0; i < funcCount; ++i) {
            this.readFunctionInfo(dataInStream, packageInfo);
        }
        packageInfo.setInitFunctionInfo(packageInfo.getFunctionInfo(packageInfo.getPkgPath() + ".<init>"));
        packageInfo.setStartFunctionInfo(packageInfo.getFunctionInfo(packageInfo.getPkgPath() + ".<start>"));
        packageInfo.setStopFunctionInfo(packageInfo.getFunctionInfo(packageInfo.getPkgPath() + ".<stop>"));
        for (ServiceInfo serviceInfo : serviceInfoEntries = packageInfo.getServiceInfoEntries()) {
            FunctionInfo serviceIniFuncInfo = packageInfo.getFunctionInfo(serviceInfo.getName() + ".<init>");
            serviceInfo.setInitFunctionInfo(serviceIniFuncInfo);
        }
    }

    private void readFunctionInfo(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        String uniqueFuncName;
        int funcNameCPIndex = dataInStream.readInt();
        UTF8CPEntry funcNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(funcNameCPIndex);
        String funcName = funcNameUTF8Entry.getValue();
        FunctionInfo functionInfo = new FunctionInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), funcNameCPIndex, funcName);
        functionInfo.setPackageInfo(packageInfo);
        int funcSigCPIndex = dataInStream.readInt();
        UTF8CPEntry funcSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(funcSigCPIndex);
        this.setCallableUnitSignature(functionInfo, funcSigUTF8Entry.getValue(), packageInfo);
        int flags = dataInStream.readInt();
        boolean nativeFunc = Flags.isFlagOn(flags, 2);
        functionInfo.setNative(nativeFunc);
        boolean attached = Flags.isFlagOn(flags, 8);
        if (attached) {
            int attachedToTypeCPIndex;
            functionInfo.attachedToTypeCPIndex = attachedToTypeCPIndex = dataInStream.readInt();
            TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)packageInfo.getCPEntry(attachedToTypeCPIndex);
            functionInfo.attachedToType = typeRefCPEntry.getType();
            uniqueFuncName = AttachedFunctionInfo.getUniqueFuncName(typeRefCPEntry.getType().getName(), funcName);
            packageInfo.addFunctionInfo(uniqueFuncName, functionInfo);
            if (typeRefCPEntry.getType().getTag() == 15) {
                BStructType structType = (BStructType)typeRefCPEntry.getType();
                AttachedFunctionInfo attachedFuncInfo = structType.structInfo.funcInfoEntries.get(funcName);
                attachedFuncInfo.functionInfo = functionInfo;
            }
        } else {
            uniqueFuncName = funcName;
            packageInfo.addFunctionInfo(uniqueFuncName, functionInfo);
        }
        int workerDataChannelsLength = dataInStream.readShort();
        for (int i = 0; i < workerDataChannelsLength; ++i) {
            this.readWorkerDataChannelEntries(dataInStream, packageInfo, functionInfo);
        }
        this.readWorkerInfoEntries(dataInStream, packageInfo, functionInfo);
        if (nativeFunc) {
            NativeCallableUnit nativeFunction = NativeUnitLoader.getInstance().loadNativeFunction(functionInfo.getPkgPath(), uniqueFuncName);
            if (nativeFunction == null) {
                throw new BLangRuntimeException("native function not available " + functionInfo.getPkgPath() + ":" + uniqueFuncName);
            }
            functionInfo.setNativeCallableUnit(nativeFunction);
        }
        this.readAttributeInfoEntries(dataInStream, packageInfo, functionInfo);
    }

    private void readTransformerInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int transformerCount = dataInStream.readShort();
        for (int i = 0; i < transformerCount; ++i) {
            this.readTransformerInfo(dataInStream, packageInfo);
        }
    }

    private void readTransformerInfo(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int transformerNameCPIndex = dataInStream.readInt();
        UTF8CPEntry transformerNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(transformerNameCPIndex);
        TransformerInfo transformerInfo = new TransformerInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), transformerNameCPIndex, transformerNameUTF8Entry.getValue());
        transformerInfo.setPackageInfo(packageInfo);
        packageInfo.addTransformerInfo(transformerNameUTF8Entry.getValue(), transformerInfo);
        int transformerSigCPIndex = dataInStream.readInt();
        UTF8CPEntry transformerSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(transformerSigCPIndex);
        this.setCallableUnitSignature(transformerInfo, transformerSigUTF8Entry.getValue(), packageInfo);
        boolean nativeFunc = Flags.isFlagOn(dataInStream.readInt(), 2);
        transformerInfo.setNative(nativeFunc);
        int workerDataChannelsLength = dataInStream.readShort();
        for (int i = 0; i < workerDataChannelsLength; ++i) {
            this.readWorkerDataChannelEntries(dataInStream, packageInfo, transformerInfo);
        }
        this.readWorkerInfoEntries(dataInStream, packageInfo, transformerInfo);
        this.readAttributeInfoEntries(dataInStream, packageInfo, transformerInfo);
    }

    public void readWorkerDataChannelEntries(DataInputStream dataInputStream, PackageInfo packageInfo, CallableUnitInfo callableUnitInfo) throws IOException {
        int sourceCPIndex = dataInputStream.readInt();
        int targetCPIndex = dataInputStream.readInt();
        UTF8CPEntry sourceCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(sourceCPIndex);
        UTF8CPEntry targetCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(targetCPIndex);
        WorkerDataChannelInfo workerDataChannelInfo = new WorkerDataChannelInfo(sourceCPIndex, sourceCPEntry.getValue(), targetCPIndex, targetCPEntry.getValue());
        int dataChannelRefCPIndex = dataInputStream.readInt();
        WorkerDataChannelRefCPEntry refCPEntry = (WorkerDataChannelRefCPEntry)packageInfo.getCPEntry(dataChannelRefCPIndex);
        refCPEntry.setWorkerDataChannelInfo(workerDataChannelInfo);
        callableUnitInfo.addWorkerDataChannelInfo(workerDataChannelInfo);
    }

    private void setCallableUnitSignature(CallableUnitInfo callableUnitInfo, String sig, PackageInfo packageInfo) {
        BFunctionType funcType = this.getFunctionType(sig, packageInfo);
        callableUnitInfo.setParamTypes(funcType.paramTypes);
        callableUnitInfo.setRetParamTypes(funcType.retParamTypes);
    }

    private BFunctionType getFunctionType(String sig, PackageInfo packageInfo) {
        int indexOfSep = sig.indexOf(")(");
        String paramSig = sig.substring(1, indexOfSep);
        String retParamSig = sig.substring(indexOfSep + 2, sig.length() - 1);
        BType[] paramTypes = this.getParamTypes(paramSig, packageInfo);
        BType[] retParamTypes = this.getParamTypes(retParamSig, packageInfo);
        return new BFunctionType(paramTypes, retParamTypes);
    }

    private BType[] getParamTypes(String signature, PackageInfo packageInfo) {
        int index = 0;
        Stack<BType> typeStack = new Stack<BType>();
        char[] chars = signature.toCharArray();
        while (index < chars.length) {
            index = this.createBTypeFromSig(chars, index, typeStack, packageInfo);
        }
        return typeStack.toArray(new BType[0]);
    }

    private int createBTypeFromSig(char[] chars, int index, Stack<BType> typeStack, PackageInfo packageInfo) {
        char ch = chars[index];
        switch (ch) {
            case 'I': {
                typeStack.push(BTypes.typeInt);
                return index + 1;
            }
            case 'F': {
                typeStack.push(BTypes.typeFloat);
                return index + 1;
            }
            case 'S': {
                typeStack.push(BTypes.typeString);
                return index + 1;
            }
            case 'B': {
                typeStack.push(BTypes.typeBoolean);
                return index + 1;
            }
            case 'L': {
                typeStack.push(BTypes.typeBlob);
                return index + 1;
            }
            case 'Y': {
                typeStack.push(BTypes.typeDesc);
                return index + 1;
            }
            case 'A': {
                typeStack.push(BTypes.typeAny);
                return index + 1;
            }
            case 'R': {
                int nameIndex = ++index;
                while (chars[nameIndex] != ';') {
                    ++nameIndex;
                }
                String typeName = new String(Arrays.copyOfRange(chars, index, nameIndex));
                typeStack.push(BTypes.getTypeFromName(typeName));
                return nameIndex + 1;
            }
            case 'C': 
            case 'D': 
            case 'E': 
            case 'G': 
            case 'H': 
            case 'J': 
            case 'T': 
            case 'Z': {
                PackageInfo packageInfoOfType;
                String name;
                char typeChar = chars[index];
                int nameIndex = ++index;
                int colonIndex = -1;
                while (chars[nameIndex] != ';') {
                    if (chars[nameIndex] == ':') {
                        colonIndex = nameIndex;
                    }
                    ++nameIndex;
                }
                if (colonIndex != -1) {
                    String pkgPath = new String(Arrays.copyOfRange(chars, index, colonIndex));
                    name = new String(Arrays.copyOfRange(chars, colonIndex + 1, nameIndex));
                    packageInfoOfType = this.programFile.getPackageInfo(pkgPath);
                } else {
                    name = new String(Arrays.copyOfRange(chars, index, nameIndex));
                    packageInfoOfType = packageInfo;
                }
                if (typeChar == 'C') {
                    typeStack.push(packageInfoOfType.getConnectorInfo(name).getType());
                } else if (typeChar == 'J') {
                    if (name.isEmpty()) {
                        typeStack.push(BTypes.typeJSON);
                    } else {
                        typeStack.push(new BJSONType(packageInfoOfType.getStructInfo(name).getType()));
                    }
                } else if (typeChar == 'D') {
                    if (name.isEmpty()) {
                        typeStack.push(BTypes.typeTable);
                    } else {
                        typeStack.push(new BTableType(packageInfoOfType.getStructInfo(name).getType()));
                    }
                } else if (typeChar == 'H') {
                    if (name.isEmpty()) {
                        typeStack.push(BTypes.typeStream);
                    } else {
                        typeStack.push(new BStreamType(packageInfoOfType.getStructInfo(name).getType()));
                    }
                } else if (typeChar == 'E') {
                    typeStack.push(packageInfoOfType.getEnumInfo(name).getType());
                } else if (typeChar == 'G') {
                    typeStack.push(packageInfoOfType.getTypeDefinitionInfo(name).getType());
                } else {
                    typeStack.push(packageInfoOfType.getStructInfo(name).getType());
                }
                return nameIndex + 1;
            }
            case '[': {
                index = this.createBTypeFromSig(chars, index + 1, typeStack, packageInfo);
                BType elemType = typeStack.pop();
                BArrayType arrayType = new BArrayType(elemType);
                typeStack.push(arrayType);
                return index;
            }
            case 'M': {
                index = this.createBTypeFromSig(chars, index + 1, typeStack, packageInfo);
                BType constrainedType = typeStack.pop();
                BType mapType = constrainedType == BTypes.typeAny ? BTypes.typeMap : new BMapType(constrainedType);
                typeStack.push(mapType);
                return index;
            }
            case 'U': {
                typeStack.push(new BFunctionType());
                return index + 1;
            }
            case 'O': 
            case 'P': {
                char typeChar = chars[index];
                int nameIndex = ++index;
                while (chars[nameIndex] != ';') {
                    ++nameIndex;
                }
                ArrayList<BType> memberTypes = new ArrayList<BType>();
                int memberCount = Integer.parseInt(new String(Arrays.copyOfRange(chars, index, nameIndex)));
                index = nameIndex;
                for (int i = 0; i < memberCount; ++i) {
                    index = this.createBTypeFromSig(chars, index + 1, typeStack, packageInfo) - 1;
                    memberTypes.add(typeStack.pop());
                }
                if (typeChar == 'O') {
                    typeStack.push(new BUnionType(memberTypes));
                } else if (typeChar == 'P') {
                    typeStack.push(new BTupleType(memberTypes));
                }
                return index + 1;
            }
            case 'N': {
                typeStack.push(BTypes.typeNull);
                return index + 1;
            }
        }
        throw new ProgramFileFormatException("unsupported base type char: " + ch);
    }

    private BType getBTypeFromDescriptor(String desc) {
        char ch = desc.charAt(0);
        switch (ch) {
            case 'I': {
                return BTypes.typeInt;
            }
            case 'F': {
                return BTypes.typeFloat;
            }
            case 'S': {
                return BTypes.typeString;
            }
            case 'B': {
                return BTypes.typeBoolean;
            }
            case 'Y': {
                return BTypes.typeDesc;
            }
            case 'L': {
                return BTypes.typeBlob;
            }
            case 'A': {
                return BTypes.typeAny;
            }
            case 'R': {
                return BTypes.getTypeFromName(desc.substring(1, desc.length() - 1));
            }
            case 'M': {
                BType constrainedType = this.getBTypeFromDescriptor(desc.substring(1));
                if (constrainedType == BTypes.typeAny) {
                    return BTypes.typeMap;
                }
                return new BMapType(constrainedType);
            }
            case 'C': 
            case 'D': 
            case 'E': 
            case 'G': 
            case 'H': 
            case 'J': 
            case 'T': 
            case 'X': 
            case 'Z': {
                String typeName = desc.substring(1, desc.length() - 1);
                String[] parts = typeName.split(":");
                if (parts.length == 1) {
                    if (ch == 'J') {
                        return BTypes.typeJSON;
                    }
                    if (ch == 'D') {
                        return BTypes.typeTable;
                    }
                    if (ch == 'H') {
                        return BTypes.typeStream;
                    }
                }
                String pkgPath = parts[0];
                String name = parts[1];
                PackageInfo packageInfoOfType = this.programFile.getPackageInfo(pkgPath);
                if (ch == 'J') {
                    return new BJSONType(packageInfoOfType.getStructInfo(name).getType());
                }
                if (ch == 'C') {
                    return packageInfoOfType.getConnectorInfo(name).getType();
                }
                if (ch == 'X') {
                    return packageInfoOfType.getServiceInfo(name).getType();
                }
                if (ch == 'D') {
                    return new BTableType(packageInfoOfType.getStructInfo(name).getType());
                }
                if (ch == 'H') {
                    return new BStreamType(packageInfoOfType.getStructInfo(name).getType());
                }
                if (ch == 'E') {
                    return packageInfoOfType.getEnumInfo(name).getType();
                }
                if (ch == 'G') {
                    return packageInfoOfType.getTypeDefinitionInfo(name).getType();
                }
                return packageInfoOfType.getStructInfo(name).getType();
            }
            case '[': {
                BType elemType = this.getBTypeFromDescriptor(desc.substring(1));
                return new BArrayType(elemType);
            }
            case 'U': {
                return new BFunctionType();
            }
            case 'O': 
            case 'P': {
                Stack<BType> typeStack = new Stack<BType>();
                this.createBTypeFromSig(desc.toCharArray(), 0, typeStack, null);
                return typeStack.pop();
            }
            case 'N': {
                return BTypes.typeNull;
            }
        }
        throw new ProgramFileFormatException("unsupported base type char: " + ch);
    }

    private void readWorkerInfoEntries(DataInputStream dataInStream, PackageInfo packageInfo, CallableUnitInfo callableUnitInfo) throws IOException {
        short workerCount = dataInStream.readShort();
        WorkerInfo defaultWorker = this.getWorkerInfo(dataInStream, packageInfo);
        callableUnitInfo.setDefaultWorkerInfo(defaultWorker);
        for (int i = 0; i < workerCount - 1; ++i) {
            WorkerInfo workerInfo = this.getWorkerInfo(dataInStream, packageInfo);
            callableUnitInfo.addWorkerInfo(workerInfo.getWorkerName(), workerInfo);
        }
    }

    private WorkerInfo getWorkerInfo(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int workerNameCPIndex = dataInStream.readInt();
        UTF8CPEntry workerNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(workerNameCPIndex);
        WorkerInfo workerInfo = new WorkerInfo(workerNameCPIndex, workerNameUTF8Entry.getValue());
        int wrkrDtChnlRefCPIndex = dataInStream.readInt();
        workerInfo.setWrkrDtChnlRefCPIndex(wrkrDtChnlRefCPIndex);
        if (wrkrDtChnlRefCPIndex >= 0) {
            WorkerDataChannelRefCPEntry refCPEntry = (WorkerDataChannelRefCPEntry)packageInfo.getCPEntry(wrkrDtChnlRefCPIndex);
            workerInfo.setWorkerDataChannelInfoForForkJoin(refCPEntry.getWorkerDataChannelInfo());
        }
        this.readForkJoinInfo(dataInStream, packageInfo, workerInfo);
        this.readAttributeInfoEntries(dataInStream, packageInfo, workerInfo);
        CodeAttributeInfo codeAttribute = (CodeAttributeInfo)workerInfo.getAttributeInfo(AttributeInfo.Kind.CODE_ATTRIBUTE);
        workerInfo.setCodeAttributeInfo(codeAttribute);
        return workerInfo;
    }

    private void readForkJoinInfo(DataInputStream dataInStream, PackageInfo packageInfo, WorkerInfo workerInfo) throws IOException {
        int forkJoinCount = dataInStream.readShort();
        ForkjoinInfo[] forkjoinInfos = new ForkjoinInfo[forkJoinCount];
        for (int i = 0; i < forkJoinCount; ++i) {
            ForkjoinInfo forkjoinInfo;
            forkjoinInfos[i] = forkjoinInfo = this.getForkJoinInfo(dataInStream, packageInfo);
        }
        workerInfo.setForkjoinInfos(forkjoinInfos);
    }

    private ForkjoinInfo getForkJoinInfo(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int indexCPIndex = dataInStream.readInt();
        int argRegLength = dataInStream.readShort();
        int[] argRegs = new int[argRegLength];
        for (int i = 0; i < argRegLength; ++i) {
            argRegs[i] = dataInStream.readInt();
        }
        ForkJoinCPEntry forkJoinCPEntry = (ForkJoinCPEntry)packageInfo.getCPEntry(indexCPIndex);
        ForkjoinInfo forkjoinInfo = new ForkjoinInfo(argRegs);
        forkjoinInfo.setIndex(forkJoinCPEntry.getForkJoinCPIndex());
        forkjoinInfo.setIndexCPIndex(indexCPIndex);
        int workerCount = dataInStream.readShort();
        for (int i = 0; i < workerCount; ++i) {
            WorkerInfo workerInfo = this.getWorkerInfo(dataInStream, packageInfo);
            forkjoinInfo.addWorkerInfo(workerInfo.getWorkerName(), workerInfo);
        }
        boolean isTimeoutAvailable = dataInStream.readBoolean();
        forkjoinInfo.setTimeoutAvailable(isTimeoutAvailable);
        int joinTypeCPIndex = dataInStream.readInt();
        UTF8CPEntry joinTypeCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(joinTypeCPIndex);
        forkjoinInfo.setJoinType(joinTypeCPEntry.getValue());
        forkjoinInfo.setJoinTypeCPIndex(joinTypeCPIndex);
        int joinWorkerCount = dataInStream.readInt();
        forkjoinInfo.setWorkerCount(joinWorkerCount);
        int joinWrkrCPIndexesLen = dataInStream.readShort();
        int[] joinWrkrCPIndexes = new int[joinWrkrCPIndexesLen];
        String[] joinWrkrNames = new String[joinWrkrCPIndexesLen];
        for (int i = 0; i < joinWrkrCPIndexesLen; ++i) {
            int cpIndex = dataInStream.readInt();
            UTF8CPEntry workerNameCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(cpIndex);
            joinWrkrCPIndexes[i] = cpIndex;
            joinWrkrNames[i] = workerNameCPEntry.getValue();
        }
        forkjoinInfo.setJoinWrkrNameIndexes(joinWrkrCPIndexes);
        forkjoinInfo.setJoinWorkerNames(joinWrkrNames);
        forkJoinCPEntry.setForkjoinInfo(forkjoinInfo);
        return forkjoinInfo;
    }

    private void readAttributeInfoEntries(DataInputStream dataInStream, ConstantPool constantPool, AttributeInfoPool attributeInfoPool) throws IOException {
        int attributesCount = dataInStream.readShort();
        for (int k = 0; k < attributesCount; ++k) {
            AttributeInfo attributeInfo = this.getAttributeInfo(dataInStream, constantPool);
            attributeInfoPool.addAttributeInfo(attributeInfo.getKind(), attributeInfo);
        }
    }

    private AttributeInfo getAttributeInfo(DataInputStream dataInStream, ConstantPool constantPool) throws IOException {
        int attribNameCPIndex = dataInStream.readInt();
        UTF8CPEntry attribNameCPEntry = (UTF8CPEntry)constantPool.getCPEntry(attribNameCPIndex);
        AttributeInfo.Kind attribKind = AttributeInfo.Kind.fromString(attribNameCPEntry.getValue());
        if (attribKind == null) {
            throw new ProgramFileFormatException("unknown attribute kind " + attribNameCPEntry.getValue());
        }
        switch (attribKind) {
            case CODE_ATTRIBUTE: {
                CodeAttributeInfo codeAttributeInfo = new CodeAttributeInfo();
                codeAttributeInfo.setAttributeNameIndex(attribNameCPIndex);
                codeAttributeInfo.setCodeAddrs(dataInStream.readInt());
                codeAttributeInfo.setMaxLongLocalVars(dataInStream.readUnsignedShort());
                codeAttributeInfo.setMaxDoubleLocalVars(dataInStream.readShort());
                codeAttributeInfo.setMaxStringLocalVars(dataInStream.readShort());
                codeAttributeInfo.setMaxIntLocalVars(dataInStream.readShort());
                codeAttributeInfo.setMaxByteLocalVars(dataInStream.readShort());
                codeAttributeInfo.setMaxRefLocalVars(dataInStream.readShort());
                codeAttributeInfo.setMaxLongRegs(dataInStream.readShort());
                codeAttributeInfo.setMaxDoubleRegs(dataInStream.readShort());
                codeAttributeInfo.setMaxStringRegs(dataInStream.readShort());
                codeAttributeInfo.setMaxIntRegs(dataInStream.readShort());
                codeAttributeInfo.setMaxByteRegs(dataInStream.readShort());
                codeAttributeInfo.setMaxRefRegs(dataInStream.readShort());
                return codeAttributeInfo;
            }
            case VARIABLE_TYPE_COUNT_ATTRIBUTE: {
                VarTypeCountAttributeInfo varCountAttributeInfo = new VarTypeCountAttributeInfo(attribNameCPIndex);
                varCountAttributeInfo.setMaxLongVars(dataInStream.readShort());
                varCountAttributeInfo.setMaxDoubleVars(dataInStream.readShort());
                varCountAttributeInfo.setMaxStringVars(dataInStream.readShort());
                varCountAttributeInfo.setMaxIntVars(dataInStream.readShort());
                varCountAttributeInfo.setMaxByteVars(dataInStream.readShort());
                varCountAttributeInfo.setMaxRefVars(dataInStream.readShort());
                return varCountAttributeInfo;
            }
            case ERROR_TABLE: {
                ErrorTableAttributeInfo tableAttributeInfo = new ErrorTableAttributeInfo(attribNameCPIndex);
                int tableEntryCount = dataInStream.readShort();
                for (int i = 0; i < tableEntryCount; ++i) {
                    int ipFrom = dataInStream.readInt();
                    int ipTo = dataInStream.readInt();
                    int ipTarget = dataInStream.readInt();
                    int priority = dataInStream.readInt();
                    int errorStructCPIndex = dataInStream.readInt();
                    ErrorTableEntry tableEntry = new ErrorTableEntry(ipFrom, ipTo, ipTarget, priority, errorStructCPIndex);
                    if (errorStructCPIndex != -1) {
                        StructureRefCPEntry structureRefCPEntry = (StructureRefCPEntry)constantPool.getCPEntry(errorStructCPIndex);
                        tableEntry.setError((StructInfo)structureRefCPEntry.getStructureTypeInfo());
                    }
                    tableAttributeInfo.addErrorTableEntry(tableEntry);
                }
                return tableAttributeInfo;
            }
            case LOCAL_VARIABLES_ATTRIBUTE: {
                LocalVariableAttributeInfo localVarAttrInfo = new LocalVariableAttributeInfo(attribNameCPIndex);
                int localVarInfoCount = dataInStream.readShort();
                for (int i = 0; i < localVarInfoCount; ++i) {
                    LocalVariableInfo localVariableInfo = this.getLocalVariableInfo(dataInStream, constantPool);
                    localVarAttrInfo.addLocalVarInfo(localVariableInfo);
                }
                return localVarAttrInfo;
            }
            case LINE_NUMBER_TABLE_ATTRIBUTE: {
                LineNumberTableAttributeInfo lnNoTblAttrInfo = new LineNumberTableAttributeInfo(attribNameCPIndex);
                int lineNoInfoCount = dataInStream.readShort();
                for (int i = 0; i < lineNoInfoCount; ++i) {
                    LineNumberInfo lineNumberInfo = this.getLineNumberInfo(dataInStream, constantPool);
                    lnNoTblAttrInfo.addLineNumberInfo(lineNumberInfo);
                }
                return lnNoTblAttrInfo;
            }
            case DEFAULT_VALUE_ATTRIBUTE: {
                DefaultValue defaultValue = this.getDefaultValue(dataInStream, constantPool);
                DefaultValueAttributeInfo defaultValAttrInfo = new DefaultValueAttributeInfo(attribNameCPIndex, defaultValue);
                return defaultValAttrInfo;
            }
            case PARAMETER_DEFAULTS_ATTRIBUTE: {
                ParamDefaultValueAttributeInfo paramDefaultValAttrInfo = new ParamDefaultValueAttributeInfo(attribNameCPIndex);
                int paramDefaultsInfoCount = dataInStream.readShort();
                for (int i = 0; i < paramDefaultsInfoCount; ++i) {
                    DefaultValue paramDefaultValue = this.getDefaultValue(dataInStream, constantPool);
                    paramDefaultValAttrInfo.addParamDefaultValueInfo(paramDefaultValue);
                }
                return paramDefaultValAttrInfo;
            }
        }
        throw new ProgramFileFormatException("unsupported attribute kind " + attribNameCPEntry.getValue());
    }

    private LocalVariableInfo getLocalVariableInfo(DataInputStream dataInStream, ConstantPool constantPool) throws IOException {
        int varNameCPIndex = dataInStream.readInt();
        UTF8CPEntry varNameCPEntry = (UTF8CPEntry)constantPool.getCPEntry(varNameCPIndex);
        int variableIndex = dataInStream.readInt();
        int typeSigCPIndex = dataInStream.readInt();
        UTF8CPEntry typeSigCPEntry = (UTF8CPEntry)constantPool.getCPEntry(typeSigCPIndex);
        BType type = this.getBTypeFromDescriptor(typeSigCPEntry.getValue());
        LocalVariableInfo localVariableInfo = new LocalVariableInfo(varNameCPEntry.getValue(), varNameCPIndex, variableIndex, typeSigCPIndex, type);
        int attchmntIndexesLength = dataInStream.readShort();
        int[] attachmentIndexes = new int[attchmntIndexesLength];
        for (int i = 0; i < attchmntIndexesLength; ++i) {
            attachmentIndexes[i] = dataInStream.readInt();
        }
        localVariableInfo.setAttachmentIndexes(attachmentIndexes);
        return localVariableInfo;
    }

    private LineNumberInfo getLineNumberInfo(DataInputStream dataInStream, ConstantPool constantPool) throws IOException {
        int lineNumber = dataInStream.readInt();
        int fileNameCPIndex = dataInStream.readInt();
        int ip = dataInStream.readInt();
        UTF8CPEntry fileNameCPEntry = (UTF8CPEntry)constantPool.getCPEntry(fileNameCPIndex);
        LineNumberInfo lineNumberInfo = new LineNumberInfo(lineNumber, fileNameCPIndex, fileNameCPEntry.getValue(), ip);
        lineNumberInfo.setPackageInfo((PackageInfo)constantPool);
        return lineNumberInfo;
    }

    private boolean readBoolean(DataInputStream codeStream) throws IOException {
        return codeStream.readInt() == 1;
    }

    private void readInstructions(DataInputStream dataInStream, PackageInfo packageInfo) throws IOException {
        int codeLength = dataInStream.readInt();
        byte[] code = new byte[codeLength];
        dataInStream.read(code);
        DataInputStream codeStream = new DataInputStream(new ByteArrayInputStream(code));
        block17: while (codeStream.available() > 0) {
            int opcode = codeStream.readUnsignedByte();
            switch (opcode) {
                case 118: 
                case 235: {
                    packageInfo.addInstruction(InstructionFactory.get(opcode, new int[0]));
                    continue block17;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 117: 
                case 123: 
                case 124: 
                case 250: {
                    int i = codeStream.readInt();
                    packageInfo.addInstruction(InstructionFactory.get(opcode, i));
                    continue block17;
                }
                case 126: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    int k = codeStream.readInt();
                    int[] operands = new int[3 + k * 2];
                    operands[0] = i;
                    operands[1] = j;
                    operands[2] = k;
                    for (int x = 0; x < k * 2; ++x) {
                        operands[x + 3] = codeStream.readInt();
                    }
                    packageInfo.addInstruction(InstructionFactory.get(opcode, operands));
                    continue block17;
                }
                case 2: 
                case 3: 
                case 4: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 90: 
                case 91: 
                case 92: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 174: 
                case 175: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 189: 
                case 193: 
                case 197: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 220: 
                case 221: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 236: 
                case 237: 
                case 243: 
                case 244: 
                case 246: 
                case 249: 
                case 251: 
                case 252: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    packageInfo.addInstruction(InstructionFactory.get(opcode, i, j));
                    continue block17;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 119: 
                case 153: 
                case 154: 
                case 155: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 196: 
                case 208: 
                case 215: 
                case 217: 
                case 219: 
                case 238: 
                case 239: 
                case 240: 
                case 245: 
                case 247: 
                case 248: 
                case 253: 
                case 254: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    int k = codeStream.readInt();
                    packageInfo.addInstruction(InstructionFactory.get(opcode, i, j, k));
                    continue block17;
                }
                case 188: 
                case 241: 
                case 242: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    int k = codeStream.readInt();
                    int h = codeStream.readInt();
                    packageInfo.addInstruction(InstructionFactory.get(opcode, i, j, k, h));
                    continue block17;
                }
                case 120: {
                    int funcRefCPIndex = codeStream.readInt();
                    int flags = codeStream.readInt();
                    FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)packageInfo.getCPEntry(funcRefCPIndex);
                    packageInfo.addInstruction(new Instruction.InstructionCALL(opcode, funcRefCPIndex, funcRefCPEntry.getFunctionInfo(), flags, this.getArgRegs(codeStream), this.getArgRegs(codeStream)));
                    continue block17;
                }
                case 121: {
                    int receiverRegIndex = codeStream.readInt();
                    int funcRefCPIndex = codeStream.readInt();
                    int flags = codeStream.readInt();
                    FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)packageInfo.getCPEntry(funcRefCPIndex);
                    packageInfo.addInstruction(new Instruction.InstructionVCALL(opcode, receiverRegIndex, funcRefCPIndex, funcRefCPEntry.getFunctionInfo(), flags, this.getArgRegs(codeStream), this.getArgRegs(codeStream)));
                    continue block17;
                }
                case 122: {
                    int actionRefCPIndex = codeStream.readInt();
                    int flags = codeStream.readInt();
                    ActionRefCPEntry actionRefCPEntry = (ActionRefCPEntry)packageInfo.getCPEntry(actionRefCPIndex);
                    packageInfo.addInstruction(new Instruction.InstructionACALL(opcode, actionRefCPIndex, actionRefCPEntry.getActionName(), flags, this.getArgRegs(codeStream), this.getArgRegs(codeStream)));
                    continue block17;
                }
                case 125: {
                    int funcRefCPIndex = codeStream.readInt();
                    int flags = codeStream.readInt();
                    int[] argRegs = this.getArgRegs(codeStream);
                    int[] retRegs = this.getArgRegs(codeStream);
                    FunctionCallCPEntry funcCallCPEntry = new FunctionCallCPEntry(flags, argRegs, retRegs);
                    int funcCallCPIndex = packageInfo.addCPEntry(funcCallCPEntry);
                    packageInfo.addInstruction(InstructionFactory.get(opcode, funcRefCPIndex, funcCallCPIndex));
                    continue block17;
                }
                case 127: {
                    int transformCPIndex = codeStream.readInt();
                    int flags = codeStream.readInt();
                    TransformerRefCPEntry transformerRefCPEntry = (TransformerRefCPEntry)packageInfo.getCPEntry(transformCPIndex);
                    packageInfo.addInstruction(new Instruction.InstructionTCALL(opcode, transformCPIndex, transformerRefCPEntry.getTransformerInfo(), flags, this.getArgRegs(codeStream), this.getArgRegs(codeStream)));
                    continue block17;
                }
                case 190: 
                case 191: {
                    int channelRefCPIndex = codeStream.readInt();
                    WorkerDataChannelRefCPEntry channelRefCPEntry = (WorkerDataChannelRefCPEntry)packageInfo.getCPEntry(channelRefCPIndex);
                    int sigCPIndex = codeStream.readInt();
                    UTF8CPEntry sigCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(sigCPIndex);
                    BType bType = this.getParamTypes(sigCPEntry.getValue(), packageInfo)[0];
                    packageInfo.addInstruction(new Instruction.InstructionWRKSendReceive(opcode, channelRefCPIndex, channelRefCPEntry.getWorkerDataChannelInfo(), sigCPIndex, bType, codeStream.readInt()));
                    continue block17;
                }
                case 192: {
                    int forkJoinIndexCPIndex = codeStream.readInt();
                    ForkJoinCPEntry forkJoinIndexCPEntry = (ForkJoinCPEntry)packageInfo.getCPEntry(forkJoinIndexCPIndex);
                    int timeoutRegIndex = codeStream.readInt();
                    int joinVarRegIndex = codeStream.readInt();
                    int joinBlockAddr = codeStream.readInt();
                    int timeoutVarRegIndex = codeStream.readInt();
                    int timeoutBlockAddr = codeStream.readInt();
                    packageInfo.addInstruction(new Instruction.InstructionFORKJOIN(opcode, forkJoinIndexCPIndex, forkJoinIndexCPEntry, timeoutRegIndex, joinVarRegIndex, joinBlockAddr, timeoutVarRegIndex, timeoutBlockAddr));
                    continue block17;
                }
                case 222: {
                    int iteratorIndex = codeStream.readInt();
                    int[] typeTags = this.getArgRegs(codeStream);
                    int[] retRegs = this.getArgRegs(codeStream);
                    packageInfo.addInstruction(new Instruction.InstructionIteratorNext(opcode, iteratorIndex, retRegs.length, typeTags, retRegs));
                    continue block17;
                }
                case 185: 
                case 186: {
                    int varCount = codeStream.readInt();
                    BType[] varTypes = new BType[varCount];
                    int[] varRegs = new int[varCount];
                    for (int m = 0; m < varCount; ++m) {
                        int varSigCPIndex = codeStream.readInt();
                        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)packageInfo.getCPEntry(varSigCPIndex);
                        varTypes[m] = typeRefCPEntry.getType();
                        varRegs[m] = codeStream.readInt();
                    }
                    packageInfo.addInstruction(new Instruction.InstructionLock(opcode, varTypes, varRegs));
                    continue block17;
                }
            }
            throw new ProgramFileFormatException("unknown opcode " + opcode + " in package " + packageInfo.getPkgPath());
        }
    }

    private void resolveCPEntries() {
        for (ConstantPoolEntry cpEntry : this.unresolvedCPEntries) {
            switch (cpEntry.getEntryType()) {
                case CP_ENTRY_FUNCTION_REF: {
                    FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)cpEntry;
                    PackageInfo packageInfo = this.programFile.getPackageInfo(funcRefCPEntry.getPackagePath());
                    FunctionInfo functionInfo = packageInfo.getFunctionInfo(funcRefCPEntry.getFunctionName());
                    funcRefCPEntry.setFunctionInfo(functionInfo);
                    break;
                }
                case CP_ENTRY_STRUCTURE_REF: {
                    StructureRefCPEntry structureRefCPEntry = (StructureRefCPEntry)cpEntry;
                    PackageInfo packageInfo = this.programFile.getPackageInfo(structureRefCPEntry.getPackagePath());
                    StructureTypeInfo structureTypeInfo = packageInfo.getStructureTypeInfo(structureRefCPEntry.getStructureName());
                    structureRefCPEntry.setStructureTypeInfo(structureTypeInfo);
                    break;
                }
                case CP_ENTRY_TYPE_REF: {
                    TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)cpEntry;
                    String typeSig = typeRefCPEntry.getTypeSig();
                    BType bType = this.getBTypeFromDescriptor(typeSig);
                    typeRefCPEntry.setType(bType);
                    break;
                }
                case CP_ENTRY_TRANSFORMER_REF: {
                    TransformerRefCPEntry transformerRefCPEntry = (TransformerRefCPEntry)cpEntry;
                    PackageInfo packageInfo = this.programFile.getPackageInfo(transformerRefCPEntry.getPackagePath());
                    TransformerInfo transformerInfo = packageInfo.getTransformerInfo(transformerRefCPEntry.getTransformerName());
                    transformerRefCPEntry.setTransformerInfo(transformerInfo);
                    break;
                }
            }
        }
    }

    private void resolveUserDefinedTypes(PackageInfo packageInfo) {
        StructInfo[] structInfoEntries = packageInfo.getStructInfoEntries();
        for (StructInfo structInfo : structInfoEntries) {
            StructFieldInfo[] fieldInfoEntries = structInfo.getFieldInfoEntries();
            BStructType structType = structInfo.getType();
            BStructType.StructField[] structFields = new BStructType.StructField[fieldInfoEntries.length];
            for (int i = 0; i < fieldInfoEntries.length; ++i) {
                BStructType.StructField structField;
                StructFieldInfo fieldInfo = fieldInfoEntries[i];
                String typeDesc = fieldInfo.getTypeDescriptor();
                BType fieldType = this.getBTypeFromDescriptor(typeDesc);
                fieldInfo.setFieldType(fieldType);
                structFields[i] = structField = new BStructType.StructField(fieldType, fieldInfo.getName(), fieldInfo.flags);
            }
            VarTypeCountAttributeInfo attributeInfo = (VarTypeCountAttributeInfo)structInfo.getAttributeInfo(AttributeInfo.Kind.VARIABLE_TYPE_COUNT_ATTRIBUTE);
            structType.setFieldTypeCount(attributeInfo.getVarTypeCount());
            structType.setStructFields(structFields);
            int attachedFuncCount = structInfo.funcInfoEntries.size();
            BStructType.AttachedFunction[] attachedFunctions = new BStructType.AttachedFunction[attachedFuncCount];
            int count = 0;
            for (AttachedFunctionInfo attachedFuncInfo : structInfo.funcInfoEntries.values()) {
                BFunctionType funcType = this.getFunctionType(attachedFuncInfo.typeSignature, packageInfo);
                BStructType.AttachedFunction attachedFunction = new BStructType.AttachedFunction(attachedFuncInfo.name, funcType, attachedFuncInfo.flags);
                attachedFunctions[count++] = attachedFunction;
                if (structInfo.initializer == attachedFuncInfo) {
                    structType.initializer = attachedFunction;
                    continue;
                }
                if (structInfo.defaultsValuesInitFunc != attachedFuncInfo) continue;
                structType.defaultsValuesInitFunc = attachedFunction;
            }
            structType.setAttachedFunctions(attachedFunctions);
        }
        for (ConstantPoolEntry cpEntry : this.unresolvedCPEntries) {
            switch (cpEntry.getEntryType()) {
                case CP_ENTRY_TYPE_REF: {
                    TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)cpEntry;
                    String typeSig = typeRefCPEntry.getTypeSig();
                    BType bType = this.getBTypeFromDescriptor(typeSig);
                    typeRefCPEntry.setType(bType);
                    break;
                }
            }
        }
    }

    private void resolveConnectorMethodTables(PackageInfo packageInfo) {
        ConnectorInfo[] connectorInfoEntries;
        for (ConnectorInfo connectorInfo : connectorInfoEntries = packageInfo.getConnectorInfoEntries()) {
            BConnectorType connectorType = connectorInfo.getType();
            VarTypeCountAttributeInfo attributeInfo = (VarTypeCountAttributeInfo)connectorInfo.getAttributeInfo(AttributeInfo.Kind.VARIABLE_TYPE_COUNT_ATTRIBUTE);
            connectorType.setFieldTypeCount(attributeInfo.getVarTypeCount());
            Map<Integer, Integer> methodTableInteger = connectorInfo.getMethodTableIndex();
            HashMap<BConnectorType, ConnectorInfo> methodTableType = new HashMap<BConnectorType, ConnectorInfo>();
            for (Integer key : methodTableInteger.keySet()) {
                int keyType = methodTableInteger.get(key);
                TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)packageInfo.getCPEntry(key);
                StructureRefCPEntry structureRefCPEntry = (StructureRefCPEntry)packageInfo.getCPEntry(keyType);
                ConnectorInfo connectorInfoType = (ConnectorInfo)structureRefCPEntry.getStructureTypeInfo();
                methodTableType.put((BConnectorType)typeRefCPEntry.getType(), connectorInfoType);
            }
            connectorInfo.setMethodTableType(methodTableType);
            for (ActionInfo actionInfo : connectorInfo.getActionInfoEntries()) {
                this.setCallableUnitSignature(actionInfo, actionInfo.getSignature(), packageInfo);
            }
        }
    }

    private DefaultValue getDefaultValue(DataInputStream dataInStream, ConstantPool constantPool) throws IOException {
        DefaultValue defaultValue;
        String typeDesc;
        int typeDescCPIndex = dataInStream.readInt();
        UTF8CPEntry typeDescCPEntry = (UTF8CPEntry)constantPool.getCPEntry(typeDescCPIndex);
        switch (typeDesc = typeDescCPEntry.getValue()) {
            case "B": {
                boolean boolValue = dataInStream.readBoolean();
                defaultValue = new DefaultValue(typeDescCPIndex, typeDesc);
                defaultValue.setBooleanValue(boolValue);
                break;
            }
            case "I": {
                int valueCPIndex = dataInStream.readInt();
                IntegerCPEntry integerCPEntry = (IntegerCPEntry)constantPool.getCPEntry(valueCPIndex);
                defaultValue = new DefaultValue(typeDescCPIndex, typeDesc);
                defaultValue.setIntValue(integerCPEntry.getValue());
                break;
            }
            case "F": {
                int valueCPIndex = dataInStream.readInt();
                FloatCPEntry floatCPEntry = (FloatCPEntry)constantPool.getCPEntry(valueCPIndex);
                defaultValue = new DefaultValue(typeDescCPIndex, typeDesc);
                defaultValue.setFloatValue(floatCPEntry.getValue());
                break;
            }
            case "S": {
                int valueCPIndex = dataInStream.readInt();
                UTF8CPEntry stringCPEntry = (UTF8CPEntry)constantPool.getCPEntry(valueCPIndex);
                defaultValue = new DefaultValue(typeDescCPIndex, typeDesc);
                defaultValue.setStringValue(stringCPEntry.getValue());
                break;
            }
            default: {
                throw new ProgramFileFormatException("unknown default value type " + typeDesc);
            }
        }
        return defaultValue;
    }

    private BValue getDefaultValueToBValue(DefaultValue defaultValue) throws IOException {
        BValueType value;
        String typeDesc;
        switch (typeDesc = defaultValue.getTypeDesc()) {
            case "B": {
                boolean boolValue = defaultValue.getBooleanValue();
                value = new BBoolean(boolValue);
                break;
            }
            case "I": {
                long intValue = defaultValue.getIntValue();
                value = new BInteger(intValue);
                break;
            }
            case "F": {
                double floatValue = defaultValue.getFloatValue();
                value = new BFloat(floatValue);
                break;
            }
            case "S": {
                String stringValue = defaultValue.getStringValue();
                value = new BString(stringValue);
                break;
            }
            default: {
                throw new ProgramFileFormatException("unknown default value type " + typeDesc);
            }
        }
        return value;
    }

    private int[] getArgRegs(DataInputStream codeStream) throws IOException {
        int nArgRegs = codeStream.readInt();
        int[] argRegs = new int[nArgRegs];
        for (int index = 0; index < nArgRegs; ++index) {
            argRegs[index] = codeStream.readInt();
        }
        return argRegs;
    }
}

