/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen.cpentries;

import java.util.Arrays;
import org.ballerinalang.util.codegen.cpentries.ConstantPoolEntry;

public class FunctionCallCPEntry
implements ConstantPoolEntry {
    private int flags;
    private int[] argRegs;
    private int[] retRegs;

    public FunctionCallCPEntry(int flags, int[] argRegs, int[] retRegs) {
        this.flags = flags;
        this.argRegs = argRegs;
        this.retRegs = retRegs;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getArgRegs() {
        return this.argRegs;
    }

    public int[] getRetRegs() {
        return this.retRegs;
    }

    @Override
    public ConstantPoolEntry.EntryType getEntryType() {
        return ConstantPoolEntry.EntryType.CP_ENTRY_FUNCTION_CALL_ARGS;
    }

    public int hashCode() {
        int[] combined = new int[this.argRegs.length + this.retRegs.length];
        System.arraycopy(this.argRegs, 0, combined, 0, this.argRegs.length);
        System.arraycopy(this.retRegs, 0, combined, this.argRegs.length, this.retRegs.length);
        return Arrays.hashCode(combined);
    }

    public boolean equals(Object obj) {
        return obj instanceof FunctionCallCPEntry && Arrays.equals(this.argRegs, ((FunctionCallCPEntry)obj).argRegs) && Arrays.equals(this.retRegs, ((FunctionCallCPEntry)obj).retRegs);
    }
}

