/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.debugger;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.util.codegen.WorkerInfo;
import org.ballerinalang.util.debugger.DebugClientHandler;
import org.ballerinalang.util.debugger.DebugException;
import org.ballerinalang.util.debugger.dto.MessageDTO;
import org.ballerinalang.util.debugger.util.DebugMsgUtil;

public class VMDebugClientHandler
implements DebugClientHandler {
    private Channel channel = null;
    private Map<String, WorkerExecutionContext> contextMap = new ConcurrentHashMap<String, WorkerExecutionContext>();

    VMDebugClientHandler() {
    }

    @Override
    public void addWorkerContext(WorkerExecutionContext ctx) {
        String workerId = this.generateAndGetWorkerId(ctx.workerInfo);
        ctx.getDebugContext().setWorkerId(workerId);
        this.contextMap.put(workerId, ctx);
    }

    private String generateAndGetWorkerId(WorkerInfo workerInfo) {
        UUID uuid = UUID.randomUUID();
        return workerInfo.getWorkerName() + "-" + uuid.toString();
    }

    @Override
    public WorkerExecutionContext getWorkerContext(String workerId) {
        return this.contextMap.get(workerId);
    }

    @Override
    public Map<String, WorkerExecutionContext> getAllWorkerContexts() {
        return this.contextMap;
    }

    @Override
    public synchronized void setChannel(Channel channel) throws DebugException {
        if (this.channel != null) {
            throw new DebugException("Debug session already exist");
        }
        this.channel = channel;
    }

    @Override
    public void clearChannel() {
        this.channel.close();
        this.channel = null;
    }

    @Override
    public boolean isChannelActive() {
        return this.channel != null;
    }

    @Override
    public void notifyExit() {
        MessageDTO message = new MessageDTO("EXIT", "Exiting from debugger.");
        this.pushMessageToClient(message);
    }

    @Override
    public void notifyHalt(MessageDTO message) {
        this.pushMessageToClient(message);
    }

    @Override
    public void sendCustomMsg(MessageDTO message) {
        this.pushMessageToClient(message);
    }

    private void pushMessageToClient(MessageDTO msg) {
        String json = DebugMsgUtil.getMsgString(msg);
        this.channel.write((Object)new TextWebSocketFrame(json));
        this.channel.flush();
    }
}

