/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.exceptions;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.ballerinalang.model.Node;
import org.ballerinalang.model.NodeLocation;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.exceptions.RuntimeErrors;
import org.ballerinalang.util.exceptions.SemanticErrors;
import org.ballerinalang.util.exceptions.SemanticException;

public class BLangExceptionHelper {
    private static ResourceBundle messageBundle = ResourceBundle.getBundle("MessagesBundle", Locale.getDefault());

    public static void throwSemanticError(String errorMessage) {
        throw new SemanticException(errorMessage);
    }

    public static void throwSemanticError(Node node, SemanticErrors semanticError, Object ... params) {
        NodeLocation nodeLocation = node.getNodeLocation();
        String location = nodeLocation.getFileName() + ":" + nodeLocation.getLineNumber() + ": ";
        String errorMsg = MessageFormat.format(messageBundle.getString(semanticError.getErrorMsgKey()), params);
        throw new SemanticException(location + errorMsg);
    }

    public static String constructSemanticError(NodeLocation nodeLocation, SemanticErrors semanticError, Object ... params) {
        String location = nodeLocation.getFileName() + ":" + nodeLocation.getLineNumber() + ": ";
        String errorMsg = MessageFormat.format(messageBundle.getString(semanticError.getErrorMsgKey()), params);
        return location + errorMsg;
    }

    public static BallerinaException getRuntimeException(RuntimeErrors runtimeErrors, Object ... params) {
        String errorMsg = MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params);
        return new BallerinaException(errorMsg);
    }

    public static SemanticException getSemanticError(NodeLocation nodeLocation, SemanticErrors semanticError, Object ... params) {
        String location = nodeLocation.getFileName() + ":" + nodeLocation.getLineNumber() + ": ";
        String errorMsg = MessageFormat.format(messageBundle.getString(semanticError.getErrorMsgKey()), params);
        return new SemanticException(location + errorMsg);
    }

    public static String getErrorMessage(RuntimeErrors runtimeErrors, Object ... params) {
        return MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params);
    }

    public static String getErrorMessage(SemanticErrors semanticError, Object ... params) {
        return MessageFormat.format(messageBundle.getString(semanticError.getErrorMsgKey()), params);
    }
}

