/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.util.metrics.Counter;
import org.ballerinalang.util.metrics.Timer;
import org.ballerinalang.util.observability.BallerinaObserver;
import org.ballerinalang.util.observability.ObserverContext;

public class BallerinaMetricsObserver
implements BallerinaObserver {
    private static final String PROPERTY_START_TIME = "_observation_start_time_";
    private static final String TAG_KEY_SERVICE = "service";
    private static final String TAG_KEY_RESOURCE = "resource";
    private static final String TAG_KEY_ACTION = "action";
    private static final PrintStream consoleError = System.err;

    @Override
    public void startServerObservation(ObserverContext observerContext, WorkerExecutionContext executionContext) {
        this.startObservation(observerContext);
    }

    @Override
    public void startClientObservation(ObserverContext observerContext, WorkerExecutionContext executionContext) {
        this.startObservation(observerContext);
    }

    private void startObservation(ObserverContext observerContext) {
        observerContext.addProperty(PROPERTY_START_TIME, System.nanoTime());
    }

    @Override
    public void stopServerObservation(ObserverContext observerContext, WorkerExecutionContext executionContext) {
        if (!observerContext.isStarted()) {
            return;
        }
        String[] additionalTags = new String[]{TAG_KEY_SERVICE, observerContext.getServiceName(), TAG_KEY_RESOURCE, observerContext.getResourceName()};
        this.stopObservation(observerContext, additionalTags);
    }

    @Override
    public void stopClientObservation(ObserverContext observerContext, WorkerExecutionContext executionContext) {
        if (!observerContext.isStarted()) {
            return;
        }
        String[] additionalTags = new String[]{TAG_KEY_ACTION, observerContext.getActionName()};
        this.stopObservation(observerContext, additionalTags);
    }

    private void stopObservation(ObserverContext observerContext, String[] additionalTags) {
        try {
            Long startTime = (Long)observerContext.getProperty(PROPERTY_START_TIME);
            long duration = System.nanoTime() - startTime;
            String namePrefix = observerContext.getConnectorName();
            Map<String, String> tags = observerContext.getTags();
            Timer responseTimer = ((Timer.Builder)Timer.builder(namePrefix + "_response_time").description("Response Time").tags((Map)tags)).tags(additionalTags).register();
            responseTimer.record(duration, TimeUnit.NANOSECONDS);
            Counter requestsCounter = ((Counter.Builder)Counter.builder(namePrefix + "_requests_total").description("Total number of requests").tags((Map)tags)).tags(additionalTags).register();
            requestsCounter.increment();
        }
        catch (RuntimeException e) {
            consoleError.println("ballerina: error collecting metrics: " + e.getMessage());
        }
    }
}

