/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.ballerinalang.util.metrics.CallbackGauge;
import org.ballerinalang.util.metrics.Counter;
import org.ballerinalang.util.metrics.Gauge;
import org.ballerinalang.util.metrics.Metric;
import org.ballerinalang.util.metrics.MetricId;
import org.ballerinalang.util.metrics.Summary;
import org.ballerinalang.util.metrics.Timer;
import org.ballerinalang.util.metrics.spi.MetricProvider;

public class MetricRegistry {
    private final MetricProvider metricProvider;
    private final ConcurrentMap<MetricId, Metric> metrics;
    private final StampedLock stampedLock;

    public MetricRegistry(MetricProvider metricProvider) {
        this.metricProvider = metricProvider;
        this.metrics = new ConcurrentHashMap<MetricId, Metric>();
        this.stampedLock = new StampedLock();
    }

    Counter counter(MetricId id) {
        return this.getOrCreate(id, Counter.class, () -> this.metricProvider.newCounter(id));
    }

    Gauge gauge(MetricId id) {
        return this.getOrCreate(id, Gauge.class, () -> this.metricProvider.newGauge(id));
    }

    <T> CallbackGauge callbackGauge(MetricId id, T obj, ToDoubleFunction<T> valueFunction) {
        return this.getOrCreate(id, CallbackGauge.class, () -> this.metricProvider.newCallbackGauge(id, obj, valueFunction));
    }

    Summary summary(MetricId id) {
        return this.getOrCreate(id, Summary.class, () -> this.metricProvider.newSummary(id));
    }

    Timer timer(MetricId id) {
        return this.getOrCreate(id, Timer.class, () -> this.metricProvider.newTimer(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends Metric> M getOrCreate(MetricId id, Class<M> metricClass, Supplier<M> metricSupplier) {
        long stamp = this.stampedLock.tryOptimisticRead();
        Metric metric = (Metric)this.metrics.get(id);
        if (!this.stampedLock.validate(stamp)) {
            stamp = this.stampedLock.readLock();
            try {
                metric = (Metric)this.metrics.get(id);
            }
            finally {
                this.stampedLock.unlockRead(stamp);
            }
        }
        if (metric != null && metricClass.isInstance(metric)) {
            return (M)metric;
        }
        stamp = this.stampedLock.writeLock();
        try {
            Metric newMetric = (Metric)metricSupplier.get();
            Metric existing = this.metrics.putIfAbsent(id, newMetric);
            if (existing != null) {
                if (metricClass.isInstance(existing)) {
                    Metric metric2 = existing;
                    return (M)metric2;
                }
                throw new IllegalArgumentException(id + " is already used for a different type of metric: " + metricClass.getSimpleName());
            }
            Metric metric3 = newMetric;
            return (M)metric3;
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        long stamp = this.stampedLock.writeLock();
        try {
            List<MetricId> ids = this.metrics.keySet().stream().filter(id -> id.getName().equals(name)).collect(Collectors.toList());
            ids.forEach(id -> {
                Metric cfr_ignored_0 = (Metric)this.metrics.remove(id);
            });
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }
}

