/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.util.LaunchListener;
import org.ballerinalang.util.metrics.BallerinaMetricsObserver;
import org.ballerinalang.util.metrics.DefaultMetricRegistry;
import org.ballerinalang.util.metrics.Gauge;
import org.ballerinalang.util.metrics.MetricRegistry;
import org.ballerinalang.util.metrics.noop.NoOpMetricProvider;
import org.ballerinalang.util.metrics.spi.MetricProvider;
import org.ballerinalang.util.observability.ObservabilityUtils;

public class MetricsLaunchListener
implements LaunchListener {
    private static final String METRIC_PROVIDER_NAME = "observability.metrics.provider";

    @Override
    public void beforeRunProgram(boolean service) {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        if (!Boolean.valueOf(configRegistry.getConfiguration("observability.metrics.enabled")).booleanValue()) {
            DefaultMetricRegistry.setInstance(new MetricRegistry(new NoOpMetricProvider()));
            return;
        }
        String providerName = configRegistry.getConfiguration(METRIC_PROVIDER_NAME);
        Iterator<MetricProvider> metricProviders = ServiceLoader.load(MetricProvider.class).iterator();
        MetricProvider metricProvider = null;
        while (metricProviders.hasNext()) {
            MetricProvider temp = metricProviders.next();
            if (providerName != null && providerName.equalsIgnoreCase(temp.getName())) {
                metricProvider = temp;
                break;
            }
            if (NoOpMetricProvider.class.isInstance(temp)) continue;
            metricProvider = temp;
            break;
        }
        if (metricProvider == null) {
            metricProvider = new NoOpMetricProvider();
        }
        metricProvider.initialize();
        DefaultMetricRegistry.setInstance(new MetricRegistry(metricProvider));
        ObservabilityUtils.addObserver(new BallerinaMetricsObserver());
    }

    @Override
    public void afterRunProgram(boolean service) {
        if (service) {
            Gauge gauge = Gauge.builder("startup_time_milliseconds").description("Startup time in milliseconds").register();
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            gauge.set(System.currentTimeMillis() - runtimeMXBean.getStartTime());
        }
    }
}

