/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.util.ArrayList;
import java.util.Map;
import org.ballerinalang.util.metrics.Tag;

public class Tags {
    private Tags() {
    }

    public static void tags(ArrayList<Tag> tags, String ... keyValues) {
        if (keyValues == null || keyValues.length == 0) {
            return;
        }
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        tags.ensureCapacity(keyValues.length / 2);
        for (int i = 0; i < keyValues.length; i += 2) {
            tags.add(Tag.of(keyValues[i], keyValues[i + 1]));
        }
    }

    public static void tags(ArrayList<Tag> existingTags, Iterable<Tag> tags) {
        tags.forEach(existingTags::add);
    }

    public static void tag(ArrayList<Tag> tags, String key, String value) {
        tags.ensureCapacity(1);
        tags.add(Tag.of(key, value));
    }

    public static void tags(ArrayList<Tag> tags, Map<String, String> tagsMap) {
        tags.ensureCapacity(tagsMap.size());
        tagsMap.forEach((key, value) -> tags.add(Tag.of(key, value)));
    }
}

