/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.observability;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.util.observability.BallerinaObserver;
import org.ballerinalang.util.observability.ObserverContext;
import org.ballerinalang.util.tracer.BSpan;
import org.ballerinalang.util.tracer.TraceManager;

public class ObservabilityUtils {
    private static final List<BallerinaObserver> observers = new CopyOnWriteArrayList<BallerinaObserver>();

    public static void addObserver(BallerinaObserver observer) {
        observers.add(observer);
    }

    public static void removeObserver(BallerinaObserver observer) {
        observers.remove(observer);
    }

    public static ObserverContext startServerObservation(String connectorName, String serviceName, String resourceName, WorkerExecutionContext executionContext) {
        ObserverContext ctx;
        Objects.requireNonNull(connectorName);
        if (executionContext != null) {
            ctx = ObservabilityUtils.getCurrentContext(executionContext);
            ObservabilityUtils.continueServerObservation(ctx, serviceName, resourceName, executionContext);
        } else {
            ctx = new ObserverContext();
        }
        ctx.setConnectorName(connectorName);
        return ctx;
    }

    public static ObserverContext startClientObservation(String connectorName, String actionName, WorkerExecutionContext executionContext) {
        ObserverContext ctx;
        Objects.requireNonNull(connectorName);
        if (executionContext != null) {
            ctx = ObservabilityUtils.getCurrentContext(executionContext);
            ObservabilityUtils.continueClientObservation(ctx, connectorName, actionName, executionContext);
        } else {
            ctx = new ObserverContext();
        }
        return ctx;
    }

    public static void continueServerObservation(ObserverContext observerContext, String serviceName, String resourceName, WorkerExecutionContext executionContext) {
        Objects.requireNonNull(executionContext);
        if (observerContext == null) {
            observerContext = ObservabilityUtils.getCurrentContext(executionContext);
        } else {
            ObservabilityUtils.setCurrentContext(observerContext, executionContext);
        }
        observerContext.setServer();
        observerContext.setStarted();
        observerContext.setServiceName(serviceName);
        observerContext.setResourceName(resourceName);
        ObserverContext ctx = observerContext;
        observers.forEach(observer -> observer.startServerObservation(ctx, executionContext));
    }

    public static void continueClientObservation(ObserverContext observerContext, String connectorName, String actionName, WorkerExecutionContext executionContext) {
        Objects.requireNonNull(executionContext);
        if (observerContext == null) {
            observerContext = ObservabilityUtils.getCurrentContext(executionContext);
        } else {
            ObservabilityUtils.setCurrentContext(observerContext, executionContext);
        }
        observerContext.setStarted();
        observerContext.setConnectorName(connectorName);
        observerContext.setActionName(actionName);
        ObserverContext ctx = observerContext;
        observers.forEach(observer -> observer.startClientObservation(ctx, executionContext));
    }

    public static void stopObservation(WorkerExecutionContext executionContext) {
        Objects.requireNonNull(executionContext);
        ObserverContext observerContext = ObservabilityUtils.getCurrentContext(executionContext);
        if (observerContext.isServer()) {
            observers.forEach(observer -> observer.stopServerObservation(observerContext, executionContext));
        } else {
            observers.forEach(observer -> observer.stopClientObservation(observerContext, executionContext));
        }
    }

    public static ObserverContext getCurrentContext(WorkerExecutionContext executionContext) {
        Objects.requireNonNull(executionContext);
        if (executionContext.localProps == null) {
            executionContext.localProps = new HashMap<String, Object>();
        }
        return (ObserverContext)executionContext.localProps.compute("__observer_context__", (key, context) -> {
            if (context == null) {
                context = new ObserverContext();
            }
            return context;
        });
    }

    public static Map<String, String> getTraceContext() {
        BSpan bSpan = TraceManager.getInstance().getParentBSpan();
        if (bSpan != null) {
            return bSpan.getTraceContext();
        }
        return Collections.emptyMap();
    }

    private static void setCurrentContext(ObserverContext observerContext, WorkerExecutionContext executionContext) {
        Objects.requireNonNull(observerContext);
        Objects.requireNonNull(executionContext);
        if (executionContext.localProps == null) {
            executionContext.localProps = new HashMap<String, Object>();
        }
        executionContext.localProps.put("__observer_context__", observerContext);
    }
}

