/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.program;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.ballerinalang.bre.BLangCallableUnitCallback;
import org.ballerinalang.bre.NativeCallContext;
import org.ballerinalang.bre.bvm.AsyncInvocableWorkerResponseContext;
import org.ballerinalang.bre.bvm.AsyncTimer;
import org.ballerinalang.bre.bvm.BLangScheduler;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.bre.bvm.CallableWorkerResponseContext;
import org.ballerinalang.bre.bvm.ForkJoinTimeoutCallback;
import org.ballerinalang.bre.bvm.ForkJoinWorkerResponseContext;
import org.ballerinalang.bre.bvm.InitWorkerResponseContext;
import org.ballerinalang.bre.bvm.SyncCallableWorkerResponseContext;
import org.ballerinalang.bre.bvm.WorkerData;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.bre.bvm.WorkerResponseContext;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BCallableFuture;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.FunctionFlags;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ForkjoinInfo;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.WorkerInfo;
import org.ballerinalang.util.codegen.attributes.CodeAttributeInfo;
import org.ballerinalang.util.exceptions.BLangNullReferenceException;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.ballerinalang.util.observability.CallableUnitCallbackObserver;
import org.ballerinalang.util.observability.CallbackObserver;
import org.ballerinalang.util.observability.ObservabilityUtils;
import org.ballerinalang.util.program.BLangVMUtils;
import org.ballerinalang.util.program.WorkerDataIndex;
import org.wso2.ballerinalang.util.Lists;

public class BLangFunctions {
    private static final String JOIN_TYPE_SOME = "some";

    private BLangFunctions() {
    }

    public static BValue[] invokeEntrypointCallable(ProgramFile bLangProgram, String packageName, String callableName, BValue[] args) {
        PackageInfo packageInfo = bLangProgram.getPackageInfo(packageName);
        FunctionInfo functionInfo = packageInfo.getFunctionInfo(callableName);
        if (functionInfo == null) {
            throw new RuntimeException("Function '" + callableName + "' is not defined");
        }
        return BLangFunctions.invokeEntrypointCallable(bLangProgram, packageInfo, functionInfo, args);
    }

    public static BValue[] invokeEntrypointCallable(ProgramFile programFile, PackageInfo packageInfo, FunctionInfo functionInfo, BValue[] args) {
        WorkerExecutionContext parentCtx = new WorkerExecutionContext(programFile);
        if (functionInfo.getParamTypes().length != args.length) {
            throw new RuntimeException("Size of input argument arrays is not equal to size of function parameters");
        }
        BLangFunctions.invokePackageInitFunction(packageInfo.getInitFunctionInfo(), parentCtx);
        BLangFunctions.invokeVMUtilFunction(packageInfo.getStartFunctionInfo(), parentCtx);
        BValue[] result = BLangFunctions.invokeCallable(functionInfo, parentCtx, args);
        BLangScheduler.waitForWorkerCompletion();
        return result;
    }

    public static void invokeCallable(CallableUnitInfo callableUnitInfo, WorkerExecutionContext parentCtx) {
        BLangFunctions.invokeCallable(callableUnitInfo, parentCtx, new int[0], new int[0], false);
    }

    public static BValue[] invokeCallable(CallableUnitInfo callableUnitInfo, BValue[] args) {
        return BLangFunctions.invokeCallable(callableUnitInfo, new WorkerExecutionContext(callableUnitInfo.getPackageInfo().getProgramFile()), args);
    }

    public static BValue[] invokeCallable(CallableUnitInfo callableUnitInfo, WorkerExecutionContext parentCtx, BValue[] args) {
        int[][] regs = BLangVMUtils.populateArgAndReturnData(parentCtx, callableUnitInfo, args);
        BLangFunctions.invokeCallable(callableUnitInfo, parentCtx, regs[0], regs[1], true);
        return BLangVMUtils.populateReturnData(parentCtx, callableUnitInfo, regs[1]);
    }

    public static void invokeServiceCallable(CallableUnitInfo callableUnitInfo, WorkerExecutionContext parentCtx, BValue[] args, CallableUnitCallback responseCallback) {
        int[][] regs = BLangVMUtils.populateArgAndReturnData(parentCtx, callableUnitInfo, args);
        BLangFunctions.invokeServiceCallable(callableUnitInfo, parentCtx, regs[0], regs[1], responseCallback);
    }

    public static void invokeServiceCallable(CallableUnitInfo callableUnitInfo, WorkerExecutionContext parentCtx, int[] argRegs, int[] retRegs, CallableUnitCallback responseCallback) {
        CallableUnitInfo.WorkerSet workerSet = callableUnitInfo.getWorkerSet();
        int generalWorkersCount = workerSet.generalWorkers.length;
        CallableWorkerResponseContext respCtx = BLangFunctions.createWorkerResponseContext(callableUnitInfo.getRetParamTypes(), generalWorkersCount);
        respCtx.registerResponseCallback(responseCallback);
        respCtx.registerResponseCallback(new CallbackObserver(parentCtx));
        respCtx.joinTargetContextInfo(parentCtx, retRegs);
        WorkerDataIndex wdi = callableUnitInfo.retWorkerIndex;
        WorkerData initWorkerLocalData = null;
        CodeAttributeInfo initWorkerCAI = null;
        if (workerSet.initWorker != null) {
            initWorkerLocalData = BLangFunctions.executeInitWorker(parentCtx, argRegs, callableUnitInfo, workerSet.initWorker, wdi);
            if (initWorkerLocalData == null) {
                BLangFunctions.handleError(parentCtx);
                return;
            }
            initWorkerCAI = workerSet.initWorker.getCodeAttributeInfo();
        }
        for (int i = 0; i < workerSet.generalWorkers.length; ++i) {
            BLangFunctions.executeWorker(respCtx, parentCtx, argRegs, callableUnitInfo, workerSet.generalWorkers[i], wdi, initWorkerLocalData, initWorkerCAI, false);
        }
    }

    public static WorkerExecutionContext invokeCallable(CallableUnitInfo callableUnitInfo, WorkerExecutionContext parentCtx, int[] argRegs, int[] retRegs, boolean waitForResponse) {
        return BLangFunctions.invokeCallable(callableUnitInfo, parentCtx, argRegs, retRegs, waitForResponse, 0);
    }

    public static WorkerExecutionContext invokeCallable(CallableUnitInfo callableUnitInfo, WorkerExecutionContext parentCtx, int[] argRegs, int[] retRegs, boolean waitForResponse, int flags) {
        WorkerExecutionContext resultCtx;
        if (FunctionFlags.isObserved((int)flags)) {
            ObservabilityUtils.startClientObservation(callableUnitInfo.attachedToType.toString(), callableUnitInfo.getName(), parentCtx);
        }
        BLangScheduler.workerWaitForResponse(parentCtx);
        if (callableUnitInfo.isNative()) {
            if (FunctionFlags.isAsync((int)flags)) {
                BLangFunctions.invokeNativeCallableAsync(callableUnitInfo, parentCtx, argRegs, retRegs);
                resultCtx = parentCtx;
            } else {
                resultCtx = BLangFunctions.invokeNativeCallable(callableUnitInfo, parentCtx, argRegs, retRegs, flags);
            }
        } else if (FunctionFlags.isAsync((int)flags)) {
            BLangFunctions.invokeNonNativeCallableAsync(callableUnitInfo, parentCtx, argRegs, retRegs);
            resultCtx = parentCtx;
        } else {
            resultCtx = BLangFunctions.invokeNonNativeCallable(callableUnitInfo, parentCtx, argRegs, retRegs, waitForResponse, flags);
        }
        resultCtx = BLangScheduler.resume(resultCtx, true);
        return resultCtx;
    }

    private static CallableWorkerResponseContext createWorkerResponseContext(BType[] retParamTypes, int generalWorkersCount) {
        if (generalWorkersCount == 1) {
            return new CallableWorkerResponseContext(retParamTypes, generalWorkersCount);
        }
        return new SyncCallableWorkerResponseContext(retParamTypes, generalWorkersCount);
    }

    public static WorkerExecutionContext invokeNonNativeCallable(CallableUnitInfo callableUnitInfo, WorkerExecutionContext parentCtx, int[] argRegs, int[] retRegs, boolean waitForResponse, int flags) {
        CallableUnitInfo.WorkerSet workerSet = callableUnitInfo.getWorkerSet();
        int generalWorkersCount = workerSet.generalWorkers.length;
        CallableWorkerResponseContext respCtx = BLangFunctions.createWorkerResponseContext(callableUnitInfo.getRetParamTypes(), generalWorkersCount);
        WaitForResponseCallback respCallback = null;
        if (waitForResponse) {
            respCallback = new WaitForResponseCallback();
            respCtx.registerResponseCallback(respCallback);
        }
        if (FunctionFlags.isObserved((int)flags)) {
            respCtx.registerResponseCallback(new CallbackObserver(parentCtx));
        }
        respCtx.joinTargetContextInfo(parentCtx, retRegs);
        WorkerDataIndex wdi = callableUnitInfo.retWorkerIndex;
        WorkerData initWorkerLocalData = null;
        CodeAttributeInfo initWorkerCAI = null;
        if (workerSet.initWorker != null) {
            initWorkerLocalData = BLangFunctions.executeInitWorker(parentCtx, argRegs, callableUnitInfo, workerSet.initWorker, wdi);
            if (initWorkerLocalData == null) {
                BLangFunctions.handleError(parentCtx);
                return null;
            }
            initWorkerCAI = workerSet.initWorker.getCodeAttributeInfo();
        }
        for (int i = 1; i < generalWorkersCount; ++i) {
            BLangFunctions.executeWorker(respCtx, parentCtx, argRegs, callableUnitInfo, workerSet.generalWorkers[i], wdi, initWorkerLocalData, initWorkerCAI, false);
        }
        WorkerExecutionContext runInCallerCtx = BLangFunctions.executeWorker(respCtx, parentCtx, argRegs, callableUnitInfo, workerSet.generalWorkers[0], wdi, initWorkerLocalData, initWorkerCAI, true);
        if (waitForResponse) {
            BLangScheduler.executeNow(runInCallerCtx);
            respCallback.waitForResponse();
            BStruct error = parentCtx.getError();
            if (error != null) {
                BLangFunctions.handleError(parentCtx);
            }
            return null;
        }
        return runInCallerCtx;
    }

    public static void invokeNonNativeCallableAsync(CallableUnitInfo callableUnitInfo, WorkerExecutionContext parentCtx, int[] argRegs, int[] retRegs) {
        CallableUnitInfo.WorkerSet workerSet = callableUnitInfo.getWorkerSet();
        int generalWorkersCount = workerSet.generalWorkers.length;
        AsyncInvocableWorkerResponseContext respCtx = new AsyncInvocableWorkerResponseContext(callableUnitInfo, generalWorkersCount);
        WorkerDataIndex wdi = callableUnitInfo.retWorkerIndex;
        WorkerData initWorkerLocalData = null;
        CodeAttributeInfo initWorkerCAI = null;
        if (workerSet.initWorker != null) {
            initWorkerLocalData = BLangFunctions.executeInitWorker(parentCtx, argRegs, callableUnitInfo, workerSet.initWorker, wdi);
            if (initWorkerLocalData == null) {
                BLangFunctions.handleError(parentCtx);
                return;
            }
            initWorkerCAI = workerSet.initWorker.getCodeAttributeInfo();
        }
        ArrayList<WorkerExecutionContext> workerExecutionContexts = new ArrayList<WorkerExecutionContext>();
        for (int i = 0; i < generalWorkersCount; ++i) {
            workerExecutionContexts.add(BLangFunctions.executeWorker(respCtx, parentCtx, argRegs, callableUnitInfo, workerSet.generalWorkers[i], wdi, initWorkerLocalData, initWorkerCAI, false));
        }
        respCtx.setWorkerExecutionContexts(workerExecutionContexts);
        BLangVMUtils.populateWorkerDataWithValues(parentCtx.workerLocal, retRegs, new BValue[]{new BCallableFuture(callableUnitInfo.getName(), respCtx)}, new BType[]{BTypes.typeFuture});
    }

    private static WorkerExecutionContext invokeNativeCallable(CallableUnitInfo callableUnitInfo, WorkerExecutionContext parentCtx, int[] argRegs, int[] retRegs, int flags) {
        WorkerData parentLocalData = parentCtx.workerLocal;
        BType[] retTypes = callableUnitInfo.getRetParamTypes();
        WorkerData caleeSF = BLangVMUtils.createWorkerDataForLocal(callableUnitInfo.getDefaultWorkerInfo(), parentCtx, argRegs, callableUnitInfo.getParamTypes());
        NativeCallContext ctx = new NativeCallContext(parentCtx, callableUnitInfo, caleeSF);
        NativeCallableUnit nativeCallable = callableUnitInfo.getNativeCallableUnit();
        if (nativeCallable == null) {
            return parentCtx;
        }
        try {
            if (nativeCallable.isBlocking()) {
                nativeCallable.execute(ctx, null);
                BLangVMUtils.populateWorkerDataWithValues(parentLocalData, retRegs, ctx.getReturnValues(), retTypes);
                if (FunctionFlags.isObserved((int)flags)) {
                    ObservabilityUtils.stopObservation(parentCtx);
                }
                return parentCtx;
            }
            CallableUnitCallback callback = FunctionFlags.isObserved((int)flags) ? new CallableUnitCallbackObserver(parentCtx, new BLangCallableUnitCallback(ctx, parentCtx, retRegs, retTypes)) : new BLangCallableUnitCallback(ctx, parentCtx, retRegs, retTypes);
            nativeCallable.execute(ctx, callback);
            return null;
        }
        catch (BLangNullReferenceException e) {
            return BLangVMUtils.handleNativeInvocationError(parentCtx, BLangVMErrors.createNullRefException(callableUnitInfo));
        }
        catch (Throwable e) {
            return BLangVMUtils.handleNativeInvocationError(parentCtx, BLangVMErrors.createError(callableUnitInfo, e.getMessage()));
        }
    }

    private static void invokeNativeCallableAsync(CallableUnitInfo callableUnitInfo, WorkerExecutionContext parentCtx, int[] argRegs, int[] retRegs) {
        WorkerData caleeSF = BLangVMUtils.createWorkerDataForLocal(callableUnitInfo.getDefaultWorkerInfo(), parentCtx, argRegs, callableUnitInfo.getParamTypes());
        NativeCallContext nativeCtx = new NativeCallContext(parentCtx, callableUnitInfo, caleeSF);
        NativeCallableUnit nativeCallable = callableUnitInfo.getNativeCallableUnit();
        if (nativeCallable == null) {
            return;
        }
        AsyncInvocableWorkerResponseContext respCtx = nativeCallable.isBlocking() ? BLangScheduler.executeBlockingNativeAsync(nativeCallable, nativeCtx) : BLangScheduler.executeNonBlockingNativeAsync(nativeCallable, nativeCtx);
        BLangVMUtils.populateWorkerDataWithValues(parentCtx.workerLocal, retRegs, new BValue[]{new BCallableFuture(callableUnitInfo.getName(), respCtx)}, new BType[]{BTypes.typeFuture});
    }

    private static void handleError(WorkerExecutionContext ctx) {
        throw new BLangRuntimeException("error: " + BLangVMErrors.getPrintableStackTrace(ctx.getError()));
    }

    private static WorkerExecutionContext executeWorker(WorkerResponseContext respCtx, WorkerExecutionContext parentCtx, int[] argRegs, CallableUnitInfo callableUnitInfo, WorkerInfo workerInfo, WorkerDataIndex wdi, WorkerData initWorkerLocalData, CodeAttributeInfo initWorkerCAI, boolean runInCaller) {
        WorkerData workerLocal = BLangVMUtils.createWorkerDataForLocal(workerInfo, parentCtx, argRegs, callableUnitInfo.getParamTypes());
        if (initWorkerLocalData != null) {
            BLangVMUtils.mergeInitWorkertData(initWorkerLocalData, workerLocal, initWorkerCAI);
        }
        WorkerData workerResult = BLangVMUtils.createWorkerData(wdi);
        WorkerExecutionContext ctx = new WorkerExecutionContext(parentCtx, respCtx, callableUnitInfo, workerInfo, workerLocal, workerResult, wdi.retRegs, runInCaller);
        BLangScheduler.schedule(ctx);
        return ctx;
    }

    private static WorkerData executeInitWorker(WorkerExecutionContext parentCtx, int[] argRegs, CallableUnitInfo callableUnitInfo, WorkerInfo workerInfo, WorkerDataIndex wdi) {
        InitWorkerResponseContext respCtx = new InitWorkerResponseContext(parentCtx);
        WorkerExecutionContext ctx = BLangFunctions.executeWorker(respCtx, parentCtx, argRegs, callableUnitInfo, workerInfo, wdi, null, null, true);
        BLangScheduler.executeNow(ctx);
        WorkerData workerLocal = ctx.workerLocal;
        if (respCtx.isErrored()) {
            return null;
        }
        return workerLocal;
    }

    public static void invokePackageInitFunction(FunctionInfo initFuncInfo, WorkerExecutionContext context) {
        BLangFunctions.invokeCallable(initFuncInfo, context, new int[0], new int[0], true);
        if (context.getError() != null) {
            String stackTraceStr = BLangVMErrors.getPrintableStackTrace(context.getError());
            throw new BLangRuntimeException("error: " + stackTraceStr);
        }
    }

    public static void invokePackageInitFunction(FunctionInfo initFuncInfo) {
        WorkerExecutionContext context = new WorkerExecutionContext(initFuncInfo.getPackageInfo().getProgramFile());
        BLangFunctions.invokePackageInitFunction(initFuncInfo, context);
    }

    public static void invokeVMUtilFunction(FunctionInfo utilFuncInfo, WorkerExecutionContext context) {
        BLangFunctions.invokeCallable(utilFuncInfo, context, new int[0], new int[0], true);
        if (context.getError() != null) {
            String stackTraceStr = BLangVMErrors.getPrintableStackTrace(context.getError());
            throw new BLangRuntimeException("error: " + stackTraceStr);
        }
    }

    public static void invokeVMUtilFunction(FunctionInfo initFuncInfo) {
        WorkerExecutionContext context = new WorkerExecutionContext(initFuncInfo.getPackageInfo().getProgramFile());
        BLangFunctions.invokeVMUtilFunction(initFuncInfo, context);
    }

    public static void invokeServiceInitFunction(FunctionInfo initFuncInfo) {
        WorkerExecutionContext context = new WorkerExecutionContext(initFuncInfo.getPackageInfo().getProgramFile());
        BLangFunctions.invokeCallable(initFuncInfo, context, new int[0], new int[0], true);
        if (context.getError() != null) {
            String stackTraceStr = BLangVMErrors.getPrintableStackTrace(context.getError());
            throw new BLangRuntimeException("error: " + stackTraceStr);
        }
    }

    public static WorkerExecutionContext invokeForkJoin(WorkerExecutionContext parentCtx, ForkjoinInfo forkjoinInfo, int joinTargetIp, int joinVarReg, int timeoutRegIndex, int timeoutTargetIp, int timeoutVarReg) {
        WorkerInfo[] workerInfos = forkjoinInfo.getWorkerInfos();
        LinkedHashSet<String> joinWorkerNames = new LinkedHashSet<String>(Lists.of((Object[])forkjoinInfo.getJoinWorkerNames()));
        if (joinWorkerNames.isEmpty()) {
            joinWorkerNames.addAll(forkjoinInfo.getWorkerInfoMap().keySet());
        }
        Map<String, String> channels = BLangFunctions.getChannels(forkjoinInfo);
        int reqJoinCount = forkjoinInfo.getJoinType().equalsIgnoreCase(JOIN_TYPE_SOME) ? forkjoinInfo.getWorkerCount() : joinWorkerNames.size();
        ForkJoinWorkerResponseContext respCtx = new ForkJoinWorkerResponseContext(parentCtx, joinTargetIp, joinVarReg, timeoutTargetIp, timeoutVarReg, workerInfos.length, reqJoinCount, joinWorkerNames, channels);
        if (forkjoinInfo.isTimeoutAvailable()) {
            long timeout = parentCtx.workerLocal.longRegs[timeoutRegIndex];
            AsyncTimer.schedule(new ForkJoinTimeoutCallback(respCtx), timeout * 1000L);
        }
        Map<String, Object> globalProps = parentCtx.globalProps;
        BLangScheduler.workerWaitForResponse(parentCtx);
        for (int i = 1; i < workerInfos.length; ++i) {
            BLangFunctions.executeWorker(respCtx, parentCtx, forkjoinInfo.getArgRegs(), workerInfos[i], globalProps, false);
        }
        return BLangFunctions.executeWorker(respCtx, parentCtx, forkjoinInfo.getArgRegs(), workerInfos[0], globalProps, true);
    }

    private static WorkerExecutionContext executeWorker(WorkerResponseContext respCtx, WorkerExecutionContext parentCtx, int[] argRegs, WorkerInfo workerInfo, Map<String, Object> globalProps, boolean runInCaller) {
        WorkerData workerLocal = BLangVMUtils.createWorkerDataForLocal(workerInfo, parentCtx, argRegs);
        WorkerExecutionContext ctx = new WorkerExecutionContext(parentCtx, respCtx, parentCtx.callableUnitInfo, workerInfo, workerLocal, runInCaller);
        return BLangScheduler.schedule(ctx);
    }

    private static Map<String, String> getChannels(ForkjoinInfo forkjoinInfo) {
        HashMap<String, String> channels = new HashMap<String, String>();
        forkjoinInfo.getWorkerInfoMap().forEach((k, v) -> {
            String cfr_ignored_0 = channels.put((String)k, v.getWorkerDataChannelInfoForForkJoin() != null ? v.getWorkerDataChannelInfoForForkJoin().getChannelName() : null);
        });
        return channels;
    }

    private static class WaitForResponseCallback
    implements CallableUnitCallback {
        private Semaphore check = new Semaphore(0);

        private WaitForResponseCallback() {
        }

        @Override
        public void notifySuccess() {
            this.check.release();
        }

        @Override
        public void notifyFailure(BStruct error) {
            this.check.release();
        }

        public void waitForResponse() {
            try {
                this.check.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

