/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.program;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class BLangPrograms {
    public static Path validateAndResolveSourcePath(Path programDirPath, Path sourcePath) {
        if (sourcePath == null) {
            throw new IllegalArgumentException("source package/file cannot be null");
        }
        try {
            Path realSourcePath = programDirPath.resolve(sourcePath).toRealPath(new LinkOption[0]);
            if (Files.isDirectory(realSourcePath, LinkOption.NOFOLLOW_LINKS)) {
                return realSourcePath;
            }
            if (!realSourcePath.toString().endsWith(".bal")) {
                throw new IllegalArgumentException("invalid file: " + sourcePath);
            }
            return realSourcePath;
        }
        catch (NoSuchFileException x) {
            throw new IllegalArgumentException("no such file or directory: " + sourcePath);
        }
        catch (IOException e) {
            throw new RuntimeException("error reading from file: " + sourcePath + " reason: " + e.getMessage(), e);
        }
    }

    public static void createDirectory(Path dirPath) {
        try {
            if (Files.exists(dirPath, new LinkOption[0]) && Files.isDirectory(dirPath, LinkOption.NOFOLLOW_LINKS)) {
                return;
            }
            if (Files.exists(dirPath, new LinkOption[0]) && !Files.isDirectory(dirPath, LinkOption.NOFOLLOW_LINKS)) {
                throw new RuntimeException("error creating user repository: a file with same name as the directory exists: '" + dirPath.toString() + "'");
            }
            Files.createDirectory(dirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("error creating Ballerina user repository: " + e.getMessage());
        }
    }
}

