/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.tracer;

import io.opentracing.Span;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.util.tracer.TraceManager;

public class BSpan {
    private static final TraceManager manager = TraceManager.getInstance();
    private Map<String, String> properties;
    private Map<String, String> tags;
    private String connectorName = "BallerinaConnector";
    private String actionName = "BallerinaAction";
    private WorkerExecutionContext executionContext = null;
    private Map<String, Span> spans;
    private boolean isRoot = false;

    private BSpan() {
    }

    public BSpan(WorkerExecutionContext executionContext, boolean isClientContext) {
        this.properties = new HashMap<String, String>();
        this.tags = new HashMap<String, String>();
        this.executionContext = executionContext;
        this.isRoot = !isClientContext;
        this.tags.put("span.kind", isClientContext ? "client" : "server");
    }

    public void startSpan() {
        manager.startSpan(this.executionContext);
    }

    public void finishSpan() {
        manager.finishSpan(this);
    }

    public void log(Map<String, Object> fields) {
        manager.log(this, fields);
    }

    public void logError(Map<String, Object> fields) {
        this.addTags(Collections.singletonMap("error", "true"));
        manager.log(this, fields);
    }

    public void addTags(Map<String, String> tags) {
        if (this.spans != null) {
            manager.addTags(this, tags);
        } else {
            this.tags.putAll(tags);
        }
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        if (this.properties != null) {
            this.properties.put(key, value);
        }
    }

    public String getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Map<String, Span> getSpans() {
        return this.spans;
    }

    public void setSpans(Map<String, Span> spans) {
        this.spans = spans;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Map<String, String> getTraceContext() {
        return manager.extractTraceContext(this.spans, this.connectorName);
    }
}

