/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.tracer;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.util.observability.BallerinaObserver;
import org.ballerinalang.util.observability.ObserverContext;
import org.ballerinalang.util.tracer.BSpan;
import org.ballerinalang.util.tracer.TraceConstants;
import org.ballerinalang.util.tracer.TraceUtil;

public class BallerinaTracingObserver
implements BallerinaObserver {
    @Override
    public void startServerObservation(ObserverContext observerContext, WorkerExecutionContext executionContext) {
        BSpan span = new BSpan(executionContext, false);
        span.setConnectorName(observerContext.getServiceName());
        span.setActionName(observerContext.getResourceName());
        Map httpHeaders = (Map)observerContext.getProperty("trace_properties");
        if (httpHeaders != null) {
            httpHeaders.entrySet().stream().filter(c -> ((String)c.getKey()).startsWith("trace___")).forEach(e -> span.addProperty(((String)e.getKey()).substring(TraceConstants.TRACE_PREFIX_LENGTH), (String)e.getValue()));
        }
        TraceUtil.setBSpan(executionContext, span);
        span.startSpan();
    }

    @Override
    public void startClientObservation(ObserverContext observerContext, WorkerExecutionContext executionContext) {
        BSpan activeSpan = new BSpan(executionContext, true);
        TraceUtil.setBSpan(executionContext, activeSpan);
        activeSpan.setConnectorName(observerContext.getConnectorName());
        activeSpan.setActionName(observerContext.getActionName());
        observerContext.addProperty("trace_properties", activeSpan.getProperties());
        activeSpan.startSpan();
    }

    @Override
    public void stopServerObservation(ObserverContext observerContext, WorkerExecutionContext executionContext) {
        this.stopObservation(observerContext, executionContext);
    }

    @Override
    public void stopClientObservation(ObserverContext observerContext, WorkerExecutionContext executionContext) {
        this.stopObservation(observerContext, executionContext);
    }

    public void stopObservation(ObserverContext observerContext, WorkerExecutionContext executionContext) {
        BSpan span = TraceUtil.getBSpan(executionContext);
        if (span != null) {
            BStruct error = (BStruct)observerContext.getProperty("bstruct_error");
            if (error != null) {
                HashMap<String, Object> logProps = new HashMap<String, Object>();
                logProps.put("error.kind", "Exception");
                logProps.put("message", BLangVMErrors.getPrintableStackTrace(error));
                logProps.put("event", "error");
                span.logError(logProps);
            }
            span.addTags(observerContext.getTags());
            TraceUtil.finishBSpan(span);
        }
    }
}

