/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.tracer;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.util.tracer.BSpan;
import org.ballerinalang.util.tracer.RequestExtractor;
import org.ballerinalang.util.tracer.RequestInjector;
import org.ballerinalang.util.tracer.TraceUtil;
import org.ballerinalang.util.tracer.TracersStore;

public class TraceManager {
    private static final TraceManager instance = new TraceManager();
    private TracersStore tracerStore;
    private Stack<BSpan> bSpanStack;

    private TraceManager() {
        Map configurations = ConfigRegistry.getInstance().getConfigTable("observability.tracing");
        this.tracerStore = new TracersStore(configurations);
        this.bSpanStack = new Stack();
    }

    public static TraceManager getInstance() {
        return instance;
    }

    public void startSpan(WorkerExecutionContext ctx) {
        BSpan activeBSpan = TraceUtil.getBSpan(ctx);
        if (activeBSpan != null) {
            Map<String, Span> spanList;
            BSpan parentBSpan = !this.bSpanStack.empty() ? this.bSpanStack.peek() : null;
            String service = activeBSpan.getConnectorName();
            String resource = activeBSpan.getActionName();
            if (parentBSpan != null) {
                spanList = this.startSpan(resource, parentBSpan.getSpans(), activeBSpan.getTags(), service, false);
            } else {
                Map<String, String> spanHeaders = activeBSpan.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
                spanList = this.startSpan(resource, this.extractSpanContext(spanHeaders, service), activeBSpan.getTags(), service, true);
            }
            activeBSpan.setSpans(spanList);
            this.bSpanStack.push(activeBSpan);
        }
    }

    public void finishSpan(BSpan bSpan) {
        bSpan.getSpans().values().forEach(Span::finish);
        if (!this.bSpanStack.empty()) {
            this.bSpanStack.pop();
        }
    }

    public void log(BSpan bSpan, Map<String, Object> fields) {
        bSpan.getSpans().values().forEach(span -> span.log(fields));
    }

    public void addTags(BSpan bSpan, Map<String, String> tags) {
        bSpan.getSpans().values().forEach(span -> tags.forEach((key, value) -> span.setTag(key, String.valueOf(value))));
    }

    public BSpan getParentBSpan() {
        return !this.bSpanStack.empty() ? this.bSpanStack.peek() : null;
    }

    public Map<String, String> extractTraceContext(Map<String, Span> activeSpanMap, String serviceName) {
        HashMap<String, String> carrierMap = new HashMap<String, String>();
        for (Map.Entry<String, Span> activeSpanEntry : activeSpanMap.entrySet()) {
            Span span;
            Map<String, Tracer> tracers = this.tracerStore.getTracers(serviceName);
            Tracer tracer = tracers.get(activeSpanEntry.getKey());
            if (tracer == null || (span = activeSpanEntry.getValue()) == null) continue;
            tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new RequestInjector("trace___", carrierMap));
        }
        return carrierMap;
    }

    private Map<String, Span> startSpan(String spanName, Map<String, ?> spanContextMap, Map<String, String> tags, String serviceName, boolean isParent) {
        HashMap<String, Span> spanMap = new HashMap<String, Span>();
        Map<String, Tracer> tracers = this.tracerStore.getTracers(serviceName);
        for (Map.Entry<String, ?> spanContextEntry : spanContextMap.entrySet()) {
            Tracer tracer = tracers.get(spanContextEntry.getKey().toString());
            Tracer.SpanBuilder spanBuilder = tracer.buildSpan(spanName);
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                spanBuilder = spanBuilder.withTag(tag.getKey(), tag.getValue());
            }
            if (spanContextEntry.getValue() != null) {
                spanBuilder = isParent ? spanBuilder.asChildOf((SpanContext)spanContextEntry.getValue()) : spanBuilder.asChildOf((Span)spanContextEntry.getValue());
            }
            Span span = spanBuilder.start();
            spanMap.put(spanContextEntry.getKey().toString(), span);
        }
        return spanMap;
    }

    private Map<String, Object> extractSpanContext(Map<String, String> headers, String serviceName) {
        HashMap<String, Object> spanContext = new HashMap<String, Object>();
        Map<String, Tracer> tracers = this.tracerStore.getTracers(serviceName);
        for (Map.Entry<String, Tracer> tracerEntry : tracers.entrySet()) {
            spanContext.put(tracerEntry.getKey(), tracerEntry.getValue().extract(Format.Builtin.HTTP_HEADERS, (Object)new RequestExtractor(headers)));
        }
        return spanContext;
    }
}

