/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.tracer;

import io.opentracing.Tracer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.util.tracer.OpenTracer;
import org.ballerinalang.util.tracer.exception.InvalidConfigurationException;

class TracersStore {
    private List<TracerGenerator> tracers;
    private Map<String, Map<String, Tracer>> tracerStore;

    TracersStore(Map<String, String> tracingConfigs) {
        if (Boolean.parseBoolean(tracingConfigs.get("enabled"))) {
            this.tracers = new ArrayList<TracerGenerator>();
            this.tracerStore = new HashMap<String, Map<String, Tracer>>();
            ServiceLoader<OpenTracer> openTracers = ServiceLoader.load(OpenTracer.class);
            HashMap tracerMap = new HashMap();
            openTracers.forEach(t -> tracerMap.put(t.getName(), t));
            String tracerName = tracingConfigs.getOrDefault("name", "jaeger");
            OpenTracer tracer = (OpenTracer)tracerMap.get(tracerName);
            if (tracer != null) {
                this.tracers.add(new TracerGenerator(tracer.getName(), tracer, tracingConfigs));
            }
        } else {
            this.tracers = Collections.emptyList();
            this.tracerStore = new HashMap<String, Map<String, Tracer>>();
        }
    }

    Map<String, Tracer> getTracers(String serviceName) {
        if (this.tracerStore.containsKey(serviceName)) {
            return this.tracerStore.get(serviceName);
        }
        HashMap<String, Tracer> tracerMap = new HashMap<String, Tracer>();
        for (TracerGenerator tracerGenerator : this.tracers) {
            try {
                Tracer tracer = tracerGenerator.generate(serviceName);
                tracerMap.put(tracerGenerator.name, tracer);
            }
            catch (Throwable throwable) {}
        }
        this.tracerStore.put(serviceName, tracerMap);
        return tracerMap;
    }

    private static class TracerGenerator {
        String name;
        OpenTracer tracer;
        Map<String, String> properties;

        TracerGenerator(String name, OpenTracer tracer, Map<String, String> properties) {
            this.name = name;
            this.tracer = tracer;
            this.properties = properties;
        }

        Tracer generate(String serviceName) throws InvalidConfigurationException {
            return this.tracer.getTracer(this.name, this.properties, serviceName);
        }
    }
}

