/*
*  Copyright (c) 2017, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
*
*  WSO2 Inc. licenses this file to you under the Apache License,
*  Version 2.0 (the "License"); you may not use this file except
*  in compliance with the License.
*  You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing,
*  software distributed under the License is distributed on an
*  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
*  KIND, either express or implied.  See the License for the
*  specific language governing permissions and limitations
*  under the License.
*/
package org.ballerinalang.connector.api;

/**
 * {@code Annotation} This API provides the functionality to access annotation attribute values given
 * annotation attribute name.
 *
 * @since 0.94
 */
public interface Annotation {

    /**
     * Returns name of the Annotation.
     *
     * @return name of the annotation
     */
    String getName();

    /**
     * Returns struct value Annotation.
     *
     * @return struct value
     */
    Struct getValue();

    /**
     * This method returns annAttrValue object for the given attribute name.
     *
     * @param attributeName of the annotation attribute.
     * @return annAttrValue object.
     */
    @Deprecated
    AnnAttrValue getAnnAttrValue(String attributeName);

}
