/*
*  Copyright (c) 2016, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
*
*  WSO2 Inc. licenses this file to you under the Apache License,
*  Version 2.0 (the "License"); you may not use this file except
*  in compliance with the License.
*  You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing,
*  software distributed under the License is distributed on an
*  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
*  KIND, either express or implied.  See the License for the
*  specific language governing permissions and limitations
*  under the License.
*/
package org.ballerinalang.model.types;

/**
 * This class contains all the supported type names as string.
 *
 * @since 0.8.0
 */
public class TypeConstants {

    public static final String INT_TNAME = "int";
    public static final String FLOAT_TNAME = "float";
    public static final String STRING_TNAME = "string";
    public static final String BOOLEAN_TNAME = "boolean";
    public static final String BLOB_TNAME = "blob";
    public static final String ARRAY_TNAME = "[]";
    public static final String MAP_TNAME = "map";
    public static final String FUTURE_TNAME = "future";
    public static final String XML_TNAME = "xml";
    public static final String JSON_TNAME = "json";
    public static final String C_JSON_TNAME = "c-json";
    public static final String CONNECTOR_TNAME = "connector";
    public static final String STRUCT_TNAME = "struct";
    static final String ITERATOR_TNAME = "iterator";
    public static final String TABLE_TNAME = "table";
    public static final String STREAM_TNAME = "stream";
    public static final String ANY_TNAME = "any";
    public static final String TYPEDESC_TNAME = "typedesc";
    public static final String NULL_TNAME = "null";
    public static final String VOID_TNAME = "void";
    public static final String XML_ATTRIBUTES_TNAME = "xml-attributes";

    public static final String INT_TSIG = "I";
    public static final String FLOAT_TSIG = "F";
    public static final String STRING_TSIG = "S";
    public static final String BOOLEAN_TSIG = "B";
    public static final String BLOB_TSIG = "L";
    public static final String REFTYPE_TSIG = "R";
    public static final String CONNECTOR_TSIG = "C";
    public static final String STRUCT_TSIG = "T";
    public static final String STREAM_TSIG = "H";
    public static final String ARRAY_TSIG = "[";
    public static final String VOID_TSIG = "V";
    public static final String ANY_TSIG = "A";


}

