/*
*  Copyright (c) 2017, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
*
*  WSO2 Inc. licenses this file to you under the Apache License,
*  Version 2.0 (the "License"); you may not use this file except
*  in compliance with the License.
*  You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing,
*  software distributed under the License is distributed on an
*  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
*  KIND, either express or implied.  See the License for the
*  specific language governing permissions and limitations
*  under the License.
*/
package org.ballerinalang.model.types;

/**
 * This class contains tag values of each type in Ballerina.
 *
 * @since 0.87
 */
public class TypeTags {
    public static final int INT_TAG = 1;
    public static final int FLOAT_TAG = 2;
    public static final int STRING_TAG = 3;
    public static final int BOOLEAN_TAG = 4;
    public static final int BLOB_TAG = 5;
    public static final int ANY_TAG = 6;
    public static final int MAP_TAG = 7;
    public static final int XML_TAG = 8;
    public static final int JSON_TAG = 9;
    public static final int MESSAGE_TAG = 10;
    public static final int TABLE_TAG = 11;
    public static final int VOID_TAG = 12;
    public static final int CONNECTOR_TAG = 13;
    public static final int FUNCTION_POINTER_TAG = 14;
    public static final int STRUCT_TAG = 15;
    public static final int ARRAY_TAG = 16;
    public static final int ANNOTATION_TAG = 17;
    public static final int NULL_TAG = 18;
    public static final int XML_ATTRIBUTES_TAG = 19;
    public static final int TYPE_TAG = 20;
    public static final int TYPEDESC_TAG = 20;
    public static final int ENUM_TAG = 21;
    public static final int ITERATOR_TAG = 22;
    public static final int SERVICE_TAG = 23;
    public static final int STREAM_TAG = 25;
    public static final int FUTURE_TAG = 26;
    public static final int UNION_TAG = 27;
    public static final int TUPLE_TAG = 28;
    public static final int FINITE_TYPE_TAG = 29;
}
