/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.ArrayList;
import java.util.Map;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ResourceInfo;
import org.ballerinalang.util.codegen.StructInfo;

public class BLangVMErrors {
    private static final String DEFAULT_PKG_PATH = ".";
    private static final String MSG_CALL_FAILED = "call failed";
    private static final String MSG_CALL_CANCELLED = "call cancelled";
    public static final String PACKAGE_BUILTIN = "ballerina.builtin";
    private static final String PACKAGE_RUNTIME = "ballerina.runtime";
    public static final String STRUCT_GENERIC_ERROR = "error";
    private static final String STRUCT_NULL_REF_EXCEPTION = "NullReferenceException";
    private static final String STRUCT_ILLEGAL_STATE_EXCEPTION = "IllegalStateException";
    public static final String STRUCT_CALL_STACK_ELEMENT = "CallStackElement";
    private static final String STRUCT_CALL_FAILED_EXCEPTION = "CallFailedException";
    public static final String TRANSACTION_ERROR = "TransactionError";

    public static BStruct createError(Context context, String message) {
        return BLangVMErrors.createError(context, true, message);
    }

    public static BStruct createError(Context context, int ip, String message) {
        return BLangVMErrors.createError(context, true, message);
    }

    public static BStruct createError(WorkerExecutionContext context, String message) {
        return BLangVMErrors.generateError(context, true, message);
    }

    public static BStruct createError(CallableUnitInfo callableUnitInfo, String message) {
        return BLangVMErrors.generateError(callableUnitInfo, true, message);
    }

    public static BStruct createError(Context context, boolean attachCallStack, String message) {
        return BLangVMErrors.createError(context, attachCallStack, message, null);
    }

    public static BStruct createError(Context context, boolean attachCallStack, String message, BStruct cause) {
        return BLangVMErrors.generateError(context.getCallableUnitInfo(), attachCallStack, message, cause);
    }

    public static BStruct createError(Context context, boolean attachCallStack, StructInfo errorType, Object ... values) {
        return BLangVMErrors.generateError(context.getCallableUnitInfo(), attachCallStack, errorType, values);
    }

    public static BStruct createTypeCastError(WorkerExecutionContext context, String sourceType, String targetType) {
        String errorMessage = "'" + sourceType + "' cannot be cast to '" + targetType + "'";
        return BLangVMErrors.createError(context, errorMessage);
    }

    public static BStruct createTypeConversionError(WorkerExecutionContext context, String errorMessage) {
        return BLangVMErrors.createError(context, errorMessage);
    }

    public static BStruct createNullRefException(Context context) {
        PackageInfo errorPackageInfo = context.getProgramFile().getPackageInfo(PACKAGE_RUNTIME);
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo(STRUCT_NULL_REF_EXCEPTION);
        return BLangVMErrors.generateError(context.getCallableUnitInfo(), true, errorStructInfo, "");
    }

    public static BStruct createNullRefException(WorkerExecutionContext context) {
        PackageInfo errorPackageInfo = context.programFile.getPackageInfo(PACKAGE_RUNTIME);
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo(STRUCT_NULL_REF_EXCEPTION);
        return BLangVMErrors.generateError(context, true, errorStructInfo, new Object[0]);
    }

    public static BStruct createNullRefException(CallableUnitInfo callableUnitInfo) {
        ProgramFile progFile = callableUnitInfo.getPackageInfo().getProgramFile();
        PackageInfo errorPackageInfo = progFile.getPackageInfo(PACKAGE_RUNTIME);
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo(STRUCT_NULL_REF_EXCEPTION);
        return BLangVMErrors.generateError(callableUnitInfo, true, errorStructInfo, new Object[0]);
    }

    public static BStruct createCallFailedException(WorkerExecutionContext context, Map<String, BStruct> errors) {
        PackageInfo errorPackageInfo = context.programFile.getPackageInfo(PACKAGE_RUNTIME);
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo(STRUCT_CALL_FAILED_EXCEPTION);
        return BLangVMErrors.generateError(context, true, errorStructInfo, MSG_CALL_FAILED, errors.isEmpty() ? null : errors.values().iterator().next(), BLangVMErrors.createErrorCauseArray(errors));
    }

    public static BStruct createCallCancelledException(CallableUnitInfo callableUnitInfo) {
        PackageInfo errorPackageInfo = callableUnitInfo.getPackageInfo().getProgramFile().getPackageInfo(PACKAGE_RUNTIME);
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo(STRUCT_CALL_FAILED_EXCEPTION);
        return BLangVMErrors.generateError(callableUnitInfo, true, errorStructInfo, MSG_CALL_CANCELLED);
    }

    public static BStruct createIllegalStateException(Context context, String msg) {
        PackageInfo errorPackageInfo = context.getProgramFile().getPackageInfo(PACKAGE_RUNTIME);
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo(STRUCT_ILLEGAL_STATE_EXCEPTION);
        return BLangVMErrors.createError(context, true, errorStructInfo, msg);
    }

    private static BRefValueArray createErrorCauseArray(Map<String, BStruct> errors) {
        BRefValueArray result = new BRefValueArray();
        long i = 0L;
        for (BStruct entry : errors.values()) {
            result.add(i, entry);
            ++i;
        }
        return result;
    }

    private static BStruct generateError(WorkerExecutionContext context, boolean attachCallStack, Object ... values) {
        PackageInfo errorPackageInfo = context.programFile.getPackageInfo(PACKAGE_BUILTIN);
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo(STRUCT_GENERIC_ERROR);
        return BLangVMErrors.generateError(context, attachCallStack, errorStructInfo, values);
    }

    private static BStruct generateError(CallableUnitInfo callableUnitInfo, boolean attachCallStack, Object ... values) {
        ProgramFile progFile = callableUnitInfo.getPackageInfo().getProgramFile();
        PackageInfo errorPackageInfo = progFile.getPackageInfo(PACKAGE_BUILTIN);
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo(STRUCT_GENERIC_ERROR);
        return BLangVMErrors.generateError(callableUnitInfo, attachCallStack, errorStructInfo, values);
    }

    private static BStruct generateError(WorkerExecutionContext context, boolean attachCallStack, StructInfo structInfo, Object ... values) {
        BStruct error = BLangVMStructs.createBStruct(structInfo, values);
        if (attachCallStack) {
            BLangVMErrors.attachStackFrame(error, context);
        }
        return error;
    }

    private static BStruct generateError(CallableUnitInfo callableUnitInfo, boolean attachCallStack, StructInfo structInfo, Object ... values) {
        BStruct error = BLangVMStructs.createBStruct(structInfo, values);
        if (attachCallStack) {
            BLangVMErrors.attachStackFrame(error, callableUnitInfo);
        }
        return error;
    }

    public static void attachStackFrame(BStruct error, WorkerExecutionContext context) {
        error.addNativeData(STRUCT_CALL_STACK_ELEMENT, BLangVMErrors.getStackFrame(context));
    }

    public static void attachStackFrame(BStruct error, CallableUnitInfo callableUnitInfo) {
        error.addNativeData(STRUCT_CALL_STACK_ELEMENT, BLangVMErrors.getStackFrame(callableUnitInfo, 0));
    }

    public static BRefValueArray generateCallStack(WorkerExecutionContext context, CallableUnitInfo nativeCUI) {
        BRefValueArray callStack = new BRefValueArray();
        long index = 0L;
        if (nativeCUI != null) {
            callStack.add(index, BLangVMErrors.getStackFrame(nativeCUI, 0));
            ++index;
        }
        while (!context.isRootContext()) {
            callStack.add(index, BLangVMErrors.getStackFrame(context));
            context = context.parent;
            ++index;
        }
        return callStack;
    }

    public static BStruct getStackFrame(CallableUnitInfo callableUnitInfo, int ip) {
        if (callableUnitInfo == null) {
            return null;
        }
        ProgramFile progFile = callableUnitInfo.getPackageInfo().getProgramFile();
        PackageInfo runtimePackage = progFile.getPackageInfo(PACKAGE_RUNTIME);
        StructInfo callStackElement = runtimePackage.getStructInfo(STRUCT_CALL_STACK_ELEMENT);
        int currentIP = ip - 1;
        Object[] values = new Object[4];
        String parentScope = "";
        if (callableUnitInfo instanceof ResourceInfo) {
            parentScope = ((ResourceInfo)callableUnitInfo).getServiceInfo().getName() + DEFAULT_PKG_PATH;
        }
        values[0] = parentScope + callableUnitInfo.getName();
        values[1] = callableUnitInfo.getPkgPath();
        if (callableUnitInfo.isNative()) {
            values[2] = "<native>";
            values[3] = 0;
        } else {
            LineNumberInfo lineNumberInfo = callableUnitInfo.getPackageInfo().getLineNumberInfo(currentIP);
            if (lineNumberInfo != null) {
                values[2] = lineNumberInfo.getFileName();
                values[3] = lineNumberInfo.getLineNumber();
            }
        }
        return BLangVMStructs.createBStruct(callStackElement, values);
    }

    public static BStruct getStackFrame(WorkerExecutionContext context) {
        if (context == null) {
            return null;
        }
        return BLangVMErrors.getStackFrame(context.callableUnitInfo, context.ip);
    }

    private static boolean isCFE(BStruct error) {
        return error.getType().getName().equals(STRUCT_CALL_FAILED_EXCEPTION);
    }

    public static String getPrintableStackTrace(BStruct error) {
        BRefValueArray causeArray = null;
        BStruct causeStruct = null;
        if (BLangVMErrors.isCFE(error)) {
            causeArray = (BRefValueArray)error.getRefField(1);
        } else {
            causeStruct = (BStruct)error.getRefField(0);
        }
        if (causeArray != null) {
            return BLangVMErrors.getCauseStackTraceArray(causeArray);
        }
        if (causeStruct != null) {
            return BLangVMErrors.getCasueStackTrace(error);
        }
        return null;
    }

    public static String getCauseStackTraceArray(BRefValueArray cause) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((long)i < cause.size()) {
            sb.append(BLangVMErrors.getCasueStackTrace((BStruct)cause.get(i)) + "\n");
            ++i;
        }
        return sb.toString();
    }

    public static String getCasueStackTrace(BStruct error) {
        StringBuilder sb = new StringBuilder();
        String errorMsg = BLangVMErrors.getErrorMessage(error);
        sb.append(errorMsg).append("\n\tat ");
        BStruct stackFrame = (BStruct)error.getNativeData(STRUCT_CALL_STACK_ELEMENT);
        if (stackFrame.getStringField(1).isEmpty() || DEFAULT_PKG_PATH.equals(stackFrame.getStringField(1)) || stackFrame.getStringField(1).equals(PACKAGE_BUILTIN)) {
            sb.append(stackFrame.getStringField(0));
        } else {
            sb.append(stackFrame.getStringField(1)).append(":").append(stackFrame.getStringField(0));
        }
        sb.append("(").append(stackFrame.getStringField(2));
        if (stackFrame.getIntField(0) > 0L) {
            sb.append(":").append(stackFrame.getIntField(0));
        }
        sb.append(")");
        if (BLangVMErrors.isCFE(error)) {
            BRefValueArray cause = (BRefValueArray)error.getRefField(1);
            if (cause != null && cause.size() > 0L) {
                sb.append("\ncaused by ").append(BLangVMErrors.getCauseStackTraceArray(cause));
            }
        } else {
            BStruct cause = (BStruct)error.getRefField(0);
            if (cause != null) {
                sb.append("\ncaused by ").append(BLangVMErrors.getCasueStackTrace(cause));
            }
        }
        return sb.toString();
    }

    private static String getErrorMessage(BStruct error) {
        String msg;
        String errorMsg = error.getType().getName();
        if (error.getType().getPackagePath() != null && !error.getType().getPackagePath().equals(DEFAULT_PKG_PATH) && !error.getType().getPackagePath().equals(PACKAGE_BUILTIN)) {
            errorMsg = error.getType().getPackagePath() + ":" + errorMsg;
        }
        if ((msg = error.getStringField(0)) != null && !msg.isEmpty()) {
            errorMsg = errorMsg + ", message: " + BLangVMErrors.makeFirstLetterLowerCase(msg);
        }
        return errorMsg;
    }

    private static String makeFirstLetterLowerCase(String s) {
        if (s == null) {
            return null;
        }
        char[] c = s.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    public static String getAggregatedRootErrorMessages(BStruct error) {
        if (BLangVMErrors.isCFE(error)) {
            BRefValueArray causesArray = (BRefValueArray)error.getRefField(1);
            if (causesArray != null && causesArray.size() > 0L) {
                ArrayList<String> messages = new ArrayList<String>();
                int i = 0;
                while ((long)i < causesArray.size()) {
                    messages.add(BLangVMErrors.getAggregatedRootErrorMessages((BStruct)causesArray.get(i)));
                    ++i;
                }
                return String.join((CharSequence)", ", messages.toArray(new String[0]));
            }
            return error.getStringField(0);
        }
        BStruct cause = (BStruct)error.getRefField(0);
        if (cause != null) {
            return BLangVMErrors.getAggregatedRootErrorMessages(cause);
        }
        return error.getStringField(0);
    }
}

