/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.io.PrintStream;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.ControlStack;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.WorkerResult;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.WorkerInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BLangVMWorkers {
    public static void invoke(ProgramFile programFile, CallableUnitInfo callableUnitInfo, Context parent, Map<String, Object> properties) {
    }

    public static void invoke(ProgramFile programFile, CallableUnitInfo callableUnitInfo, Context parent) {
        BLangVMWorkers.invoke(programFile, callableUnitInfo, parent, parent.getProperties());
    }

    private static void populateWorkerStack(CallableUnitInfo callableUnitInfo, WorkerInfo workerInfo, Context ctx, WorkerReturnIndex returnIndex, StackFrame callerSF) {
        ControlStack controlStack = null;
        StackFrame startSF = new StackFrame(callableUnitInfo.getPackageInfo(), -1, new int[0]);
        controlStack.pushFrame(startSF);
        startSF.setLongRegs(new long[returnIndex.longRegCount]);
        startSF.setDoubleRegs(new double[returnIndex.doubleRegCount]);
        startSF.setStringRegs(new String[returnIndex.stringRegCount]);
        startSF.setIntRegs(new int[returnIndex.intRegCount]);
        startSF.setRefRegs(new BRefType[returnIndex.refRegCount]);
        startSF.setByteRegs(new byte[returnIndex.byteRegCount][]);
        StackFrame calleeSF = new StackFrame(callableUnitInfo, workerInfo, -1, returnIndex.retRegs);
        controlStack.pushFrame(calleeSF);
    }

    private static WorkerReturnIndex calculateWorkerReturnIndex(BType[] retTypes) {
        WorkerReturnIndex index = new WorkerReturnIndex();
        index.retRegs = new int[retTypes.length];
        block7: for (int i = 0; i < retTypes.length; ++i) {
            BType retType = retTypes[i];
            switch (retType.getTag()) {
                case 1: {
                    ++index.longRegCount;
                    continue block7;
                }
                case 2: {
                    ++index.doubleRegCount;
                    continue block7;
                }
                case 3: {
                    ++index.stringRegCount;
                    continue block7;
                }
                case 4: {
                    ++index.intRegCount;
                    continue block7;
                }
                case 5: {
                    ++index.byteRegCount;
                    continue block7;
                }
                default: {
                    ++index.refRegCount;
                }
            }
        }
        return index;
    }

    static class WorkerReturnIndex {
        int[] retRegs;
        int longRegCount = 0;
        int doubleRegCount = 0;
        int stringRegCount = 0;
        int intRegCount = 0;
        int refRegCount = 0;
        int byteRegCount = 0;

        WorkerReturnIndex() {
        }
    }

    static class WorkerExecutor
    implements Runnable {
        private static PrintStream outStream = System.out;
        private Context bContext;
        private WorkerInfo workerInfo;
        private Queue<WorkerResult> resultHolder;
        private Semaphore resultCounter;

        public WorkerExecutor(Context bContext, WorkerInfo workerInfo, Queue<WorkerResult> resultHolder) {
            this.bContext = bContext;
            this.workerInfo = workerInfo;
            this.resultHolder = resultHolder;
        }

        @Override
        public void run() throws BallerinaException {
        }
    }
}

