/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.bre.bvm.BLangScheduler;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.SyncCallableWorkerResponseContext;
import org.ballerinalang.bre.bvm.WorkerDataChannel;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.bre.bvm.WorkerSignal;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.util.program.BLangVMUtils;

public class ForkJoinWorkerResponseContext
extends SyncCallableWorkerResponseContext {
    private int reqJoinCount;
    private int joinTargetIp;
    private int joinVarReg;
    private int timeoutTargetIp;
    private int timeoutVarReg;
    private Set<String> joinWorkerNames;
    private Map<String, String> channelNames;
    private final Map<String, BStruct> workerErrors;
    private int haltCount;
    private int errorCount;

    public ForkJoinWorkerResponseContext(WorkerExecutionContext targetCtx, int joinTargetIp, int joinVarReg, int timeoutTargetIp, int timeoutVarReg, int workerCount, int reqJoinCount, Set<String> joinWorkerNames, Map<String, String> channelNames) {
        super(null, workerCount);
        this.targetCtx = targetCtx;
        this.joinTargetIp = joinTargetIp;
        this.joinVarReg = joinVarReg;
        this.timeoutTargetIp = timeoutTargetIp;
        this.timeoutVarReg = timeoutVarReg;
        this.reqJoinCount = reqJoinCount;
        this.joinWorkerNames = joinWorkerNames;
        this.channelNames = channelNames;
        this.workerErrors = new HashMap<String, BStruct>();
    }

    @Override
    protected WorkerExecutionContext onReturn(WorkerSignal signal) {
        return null;
    }

    @Override
    protected void onMessage(WorkerSignal signal) {
    }

    @Override
    protected synchronized WorkerExecutionContext onHalt(WorkerSignal signal) {
        if (!this.joinWorkerNames.contains(signal.getSourceContext().workerInfo.getWorkerName())) {
            return null;
        }
        if (++this.haltCount != this.reqJoinCount) {
            return null;
        }
        if (this.isFulfilled()) {
            return null;
        }
        this.setAsFulfilled();
        this.workerErrors.forEach(this::printError);
        this.setCurrentSignal(signal);
        return this.onHaltFinalized();
    }

    @Override
    protected synchronized WorkerExecutionContext onError(WorkerSignal signal) {
        BStruct error = signal.getSourceContext().getError();
        if (this.isFulfilled()) {
            this.printError(signal.getSourceContext().workerInfo.getWorkerName(), error);
            return null;
        }
        if (this.workerCount - ++this.errorCount >= this.reqJoinCount) {
            this.workerErrors.put(signal.getSourceContext().workerInfo.getWorkerName(), error);
            return null;
        }
        this.setAsFulfilled();
        this.workerErrors.put(signal.getSourceContext().workerInfo.getWorkerName(), error);
        this.modifyDebugCommands(this.targetCtx, signal.getSourceContext());
        return BLangScheduler.errorThrown(this.targetCtx, this.createCallFailedError(signal.getSourceContext(), this.workerErrors));
    }

    @Override
    protected synchronized WorkerExecutionContext onTimeout(WorkerSignal signal) {
        if (this.isFulfilled()) {
            return null;
        }
        this.setAsFulfilled();
        BMap mbMap = new BMap();
        this.channelNames.forEach((k, v) -> {
            BRefType workerRes = this.getWorkerResult((String)v);
            mbMap.put(k, workerRes);
        });
        this.targetCtx.workerLocal.refRegs[this.timeoutVarReg] = mbMap;
        return BLangScheduler.resume(this.targetCtx, this.timeoutTargetIp, false);
    }

    protected WorkerExecutionContext onHaltFinalized() {
        BMap mbMap = new BMap();
        this.channelNames.forEach((k, v) -> {
            BRefType workerRes = this.getWorkerResult((String)v);
            mbMap.put(k, workerRes);
        });
        this.targetCtx.workerLocal.refRegs[this.joinVarReg] = mbMap;
        this.modifyDebugCommands(this.targetCtx, this.currentSignal.getSourceContext());
        return BLangScheduler.resume(this.targetCtx, this.joinTargetIp, true);
    }

    private BRefType getWorkerResult(String channelName) {
        if (channelName == null) {
            return null;
        }
        WorkerDataChannel dataChannel = this.getWorkerDataChannel(channelName);
        WorkerDataChannel.WorkerResult result = dataChannel.tryTakeData();
        return result != null ? result.value : null;
    }

    private void printError(String workerName, BStruct error) {
        BLangVMUtils.log("error in worker - " + workerName + System.lineSeparator() + BLangVMErrors.getPrintableStackTrace(error));
    }

    private BStruct createCallFailedError(WorkerExecutionContext context, Map<String, BStruct> errors) {
        return BLangVMErrors.createCallFailedException(context, errors);
    }
}

