/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.WorkerInfo;
import org.ballerinalang.util.codegen.attributes.CodeAttributeInfo;

public class StackFrame {
    long[] longRegs;
    double[] doubleRegs;
    String[] stringRegs;
    int[] intRegs;
    byte[][] byteRegs;
    BRefType[] refRegs;
    int retAddrs;
    int[] retRegIndexes;
    BStruct errorThrown;
    CallableUnitInfo callableUnitInfo;
    PackageInfo packageInfo;
    WorkerInfo workerInfo;
    public BValue[] returnValues;
    final AtomicBoolean workerReturned = new AtomicBoolean();
    String returnedWorker = "";
    public StackFrame prevStackFrame;

    public StackFrame(PackageInfo packageInfo, int retAddrs, int[] retRegIndexes) {
        this.packageInfo = packageInfo;
        this.retAddrs = retAddrs;
        this.retRegIndexes = retRegIndexes;
    }

    public StackFrame(CallableUnitInfo callableUnitInfo, WorkerInfo workerInfo, int retAddrs, int[] retRegIndexes) {
        this.callableUnitInfo = callableUnitInfo;
        this.packageInfo = callableUnitInfo.getPackageInfo();
        this.workerInfo = workerInfo;
        CodeAttributeInfo codeAttribInfo = workerInfo.getCodeAttributeInfo();
        this.longRegs = new long[codeAttribInfo.getMaxLongRegs()];
        this.doubleRegs = new double[codeAttribInfo.getMaxDoubleRegs()];
        this.stringRegs = new String[codeAttribInfo.getMaxStringRegs()];
        this.intRegs = new int[codeAttribInfo.getMaxIntRegs()];
        this.byteRegs = new byte[codeAttribInfo.getMaxByteRegs()][];
        Arrays.fill((Object[])this.byteRegs, new byte[0]);
        this.refRegs = new BRefType[codeAttribInfo.getMaxRefRegs()];
        this.retAddrs = retAddrs;
        this.retRegIndexes = retRegIndexes;
    }

    public StackFrame(CallableUnitInfo callableUnitInfo, WorkerInfo workerInfo, int retAddrs, int[] retRegIndexes, BValue[] returnValues) {
        this.callableUnitInfo = callableUnitInfo;
        this.packageInfo = callableUnitInfo.getPackageInfo();
        this.workerInfo = workerInfo;
        CodeAttributeInfo codeAttribInfo = workerInfo.getCodeAttributeInfo();
        this.longRegs = new long[codeAttribInfo.getMaxLongRegs()];
        this.doubleRegs = new double[codeAttribInfo.getMaxDoubleRegs()];
        this.stringRegs = new String[codeAttribInfo.getMaxStringRegs()];
        this.intRegs = new int[codeAttribInfo.getMaxIntRegs()];
        this.byteRegs = new byte[codeAttribInfo.getMaxByteRegs()][];
        Arrays.fill((Object[])this.byteRegs, new byte[0]);
        this.refRegs = new BRefType[codeAttribInfo.getMaxRefRegs()];
        this.retAddrs = retAddrs;
        this.retRegIndexes = retRegIndexes;
        this.returnValues = returnValues;
    }

    public long[] getLongRegs() {
        return this.longRegs;
    }

    public double[] getDoubleRegs() {
        return this.doubleRegs;
    }

    public String[] getStringRegs() {
        return this.stringRegs;
    }

    public int[] getIntRegs() {
        return this.intRegs;
    }

    public byte[][] getByteRegs() {
        return this.byteRegs;
    }

    public BRefType[] getRefRegs() {
        return this.refRegs;
    }

    public void setLongRegs(long[] longRegs) {
        this.longRegs = longRegs;
    }

    public void setDoubleRegs(double[] doubleRegs) {
        this.doubleRegs = doubleRegs;
    }

    public void setStringRegs(String[] stringRegs) {
        this.stringRegs = stringRegs;
    }

    public void setIntRegs(int[] intRegs) {
        this.intRegs = intRegs;
    }

    public void setByteRegs(byte[][] byteRegs) {
        this.byteRegs = byteRegs;
    }

    public void setRefRegs(BRefType[] refRegs) {
        this.refRegs = refRegs;
    }

    public int getRetAddrs() {
        return this.retAddrs;
    }

    public BStruct getErrorThrown() {
        return this.errorThrown;
    }

    public void setErrorThrown(BStruct errorThrown) {
        this.errorThrown = errorThrown;
    }

    public CallableUnitInfo getCallableUnitInfo() {
        return this.callableUnitInfo;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public WorkerInfo getWorkerInfo() {
        return this.workerInfo;
    }

    public boolean tryReturn() {
        return this.workerReturned.compareAndSet(false, true);
    }

    public void markedAsReturned() {
        this.workerReturned.set(true);
    }
}

