/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.LinkedList;
import java.util.Queue;
import org.ballerinalang.bre.bvm.BLangScheduler;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.model.values.BRefType;

public class WorkerDataChannel {
    private WorkerExecutionContext pendingCtx;
    private Queue<WorkerResult> channel = new LinkedList<WorkerResult>();

    public synchronized void putData(BRefType data) {
        this.channel.add(new WorkerResult(data));
        if (this.pendingCtx != null) {
            BLangScheduler.resume(this.pendingCtx);
            this.pendingCtx = null;
        }
    }

    public synchronized WorkerResult tryTakeData(WorkerExecutionContext ctx) {
        WorkerResult result = this.channel.peek();
        if (result != null) {
            this.channel.remove();
            return result;
        }
        this.pendingCtx = ctx;
        --ctx.ip;
        BLangScheduler.workerWaitForResponse(ctx);
        return null;
    }

    public synchronized WorkerResult tryTakeData() {
        return this.channel.poll();
    }

    public static class WorkerResult {
        public BRefType value;

        public WorkerResult(BRefType value) {
            this.value = value;
        }
    }
}

