/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.broker;

import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.config.BrokerCommonConfiguration;
import io.ballerina.messaging.broker.common.config.BrokerConfigProvider;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.BrokerImpl;
import io.ballerina.messaging.broker.core.Consumer;
import io.ballerina.messaging.broker.core.ContentChunk;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.Metadata;
import io.ballerina.messaging.broker.core.configuration.BrokerCoreConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerUtils {
    private static final Logger logger = LoggerFactory.getLogger(BrokerUtils.class);
    private static BrokerImpl broker;

    public static void addSubscription(String topic, Consumer consumer) {
        String queueName = consumer.getQueueName();
        try {
            broker.createQueue(queueName, false, false, true);
            broker.bind(queueName, "amq.topic", topic, FieldTable.EMPTY_TABLE);
            broker.addConsumer(consumer);
        }
        catch (ValidationException | BrokerException e) {
            logger.error("Error adding subscription: ", e);
        }
    }

    public static void removeSubscription(Consumer consumer) {
        broker.removeConsumer(consumer);
    }

    public static void publish(String topic, byte[] payload) {
        Message message = new Message(Broker.getNextMessageId(), new Metadata(topic, "amq.topic", (long)payload.length));
        ByteBuf content = Unpooled.copiedBuffer((byte[])payload);
        message.addChunk(new ContentChunk(0L, content));
        try {
            broker.publish(message);
        }
        catch (BrokerException e) {
            logger.error("Error publishing to topic: ", (Throwable)e);
        }
    }

    public static void publish(String topic, ByteBuf payload) {
        Message message = new Message(Broker.getNextMessageId(), new Metadata(topic, "amq.topic", (long)payload.array().length));
        message.addChunk(new ContentChunk(0L, payload));
        try {
            broker.publish(message);
        }
        catch (BrokerException e) {
            logger.error("Error publishing to topic: ", (Throwable)e);
        }
    }

    private static BrokerImpl startupBroker() throws Exception {
        BallerinaBrokerConfigProvider configProvider = new BallerinaBrokerConfigProvider();
        BrokerCommonConfiguration brokerCommonConfiguration = new BrokerCommonConfiguration();
        brokerCommonConfiguration.setEnableInMemoryMode(true);
        configProvider.registerConfigurationObject("ballerina.broker", brokerCommonConfiguration);
        BrokerCoreConfiguration brokerCoreConfiguration = new BrokerCoreConfiguration();
        configProvider.registerConfigurationObject("ballerina.broker.core", brokerCoreConfiguration);
        StartupContext startupContext = new StartupContext();
        startupContext.registerService(BrokerConfigProvider.class, (Object)configProvider);
        BrokerImpl brokerInstance = new BrokerImpl(startupContext);
        brokerInstance.startMessageDelivery();
        return brokerInstance;
    }

    public static byte[] retrieveBytes(Message message) {
        ByteBuffer messageByteBuffer = ByteBuffer.allocate((int)message.getMetadata().getContentLength());
        for (ContentChunk messageContentChunk : message.getContentChunks()) {
            byte[] contentChunkByteArray = messageContentChunk.getBytes();
            messageByteBuffer = messageByteBuffer.put(contentChunkByteArray, (int)messageContentChunk.getOffset(), contentChunkByteArray.length);
        }
        return messageByteBuffer.array();
    }

    static {
        try {
            broker = BrokerUtils.startupBroker();
        }
        catch (Exception e) {
            throw new BallerinaException("Error starting up in-memory broker: ", e);
        }
    }

    private static class BallerinaBrokerConfigProvider
    implements BrokerConfigProvider {
        private Map<String, Object> configMap = new HashMap<String, Object>();

        private BallerinaBrokerConfigProvider() {
        }

        public <T> T getConfigurationObject(String namespace, Class<T> configurationClass) throws Exception {
            return configurationClass.cast(this.configMap.get(namespace));
        }

        void registerConfigurationObject(String namespace, Object configObject) {
            this.configMap.put(namespace, configObject);
        }
    }
}

