/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.api;

import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.values.BValue;

public interface Value {
    public Type getType();

    public long getIntValue();

    public double getFloatValue();

    public String getStringValue();

    public boolean getBooleanValue();

    public Struct getStructValue();

    public BValue getVMValue();

    public static enum Type {
        INT(1),
        FLOAT(2),
        STRING(3),
        BOOLEAN(4),
        ARRAY(16),
        MAP(7),
        STRUCT(15),
        JSON(9),
        XML(8),
        TYPEDESC(20),
        ENUM(21),
        NULL(18),
        OTHER(-1);

        int tag;

        private Type(int i) {
            this.tag = i;
        }

        public int getTag() {
            return this.tag;
        }

        public static Type getType(int tag) {
            for (Type type : Type.values()) {
                if (type.tag != tag) continue;
                return type;
            }
            return OTHER;
        }

        public static Type getType(BValue value) {
            if (value == null) {
                return NULL;
            }
            for (Type type : Type.values()) {
                if (type.tag != value.getType().getTag()) continue;
                return type;
            }
            return OTHER;
        }
    }
}

