/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Struct;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.util.JsonGenerator;
import org.ballerinalang.model.util.JsonNode;
import org.ballerinalang.model.util.JsonParser;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BTable;
import org.ballerinalang.util.exceptions.BallerinaException;

public class TableJSONDataSource
implements BJSON.JSONDataSource {
    private BTable df;
    private JSONObjectGenerator objGen;
    private boolean isInTransaction;

    public TableJSONDataSource(BTable df, boolean isInTransaction) {
        this(df, new DefaultJSONObjectGenerator(), isInTransaction);
    }

    private TableJSONDataSource(BTable df, JSONObjectGenerator objGen, boolean isInTransaction) {
        this.df = df;
        this.objGen = objGen;
        this.isInTransaction = isInTransaction;
    }

    @Override
    public void serialize(JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        while (this.df.hasNext(this.isInTransaction)) {
            this.df.next();
            this.objGen.transform(this.df).serialize(gen);
        }
        gen.writeEndArray();
    }

    private static void constructJsonData(BTable df, JsonNode objNode, String name, TypeKind type, int index, BStructType.StructField[] structFields) {
        switch (type) {
            case STRING: {
                objNode.set(name, df.getString(index));
                break;
            }
            case INT: {
                objNode.set(name, df.getInt(index));
                break;
            }
            case FLOAT: {
                objNode.set(name, df.getFloat(index));
                break;
            }
            case BOOLEAN: {
                objNode.set(name, df.getBoolean(index));
                break;
            }
            case BLOB: {
                objNode.set(name, df.getBlob(index));
                break;
            }
            case ARRAY: {
                objNode.set(name, TableJSONDataSource.getDataArray(df, index));
                break;
            }
            case JSON: {
                objNode.set(name, JsonParser.parse(df.getString(index)));
                break;
            }
            case STRUCT: {
                objNode.set(name, TableJSONDataSource.getStructData(df.getStruct(index), structFields, index));
                break;
            }
            case XML: {
                objNode.set(name, df.getString(index));
                break;
            }
            default: {
                objNode.set(name, df.getString(index));
            }
        }
    }

    private static JsonNode getStructData(Object[] data, BStructType.StructField[] structFields, int index) {
        JsonNode jsonData = null;
        try {
            if (structFields == null) {
                jsonData = new JsonNode(JsonNode.Type.ARRAY);
                if (data != null) {
                    for (Object value : data) {
                        if (value instanceof String) {
                            jsonData.add((String)value);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            jsonData.add((Boolean)value);
                            continue;
                        }
                        if (value instanceof Long) {
                            jsonData.add((Long)value);
                            continue;
                        }
                        if (value instanceof Double) {
                            jsonData.add((Double)value);
                            continue;
                        }
                        if (value instanceof Integer) {
                            jsonData.add(((Integer)value).intValue());
                            continue;
                        }
                        if (value instanceof Float) {
                            jsonData.add(((Float)value).floatValue());
                            continue;
                        }
                        if (!(value instanceof BigDecimal)) continue;
                        jsonData.add(((BigDecimal)value).doubleValue());
                    }
                }
            } else {
                jsonData = new JsonNode(JsonNode.Type.OBJECT);
                boolean structError = true;
                if (data != null) {
                    int i = 0;
                    for (Object value : data) {
                        BStructType.StructField[] interanlStructFields;
                        BType internaltType = structFields[index - 1].fieldType;
                        if (internaltType.getTag() == 15 && (interanlStructFields = ((BStructType)internaltType).getStructFields()) != null) {
                            if (value instanceof String) {
                                jsonData.set(interanlStructFields[i].fieldName, (String)value);
                            } else if (value instanceof Boolean) {
                                jsonData.set(interanlStructFields[i].fieldName, (Boolean)value);
                            } else if (value instanceof Long) {
                                jsonData.set(interanlStructFields[i].fieldName, (Long)value);
                            } else if (value instanceof Double) {
                                jsonData.set(interanlStructFields[i].fieldName, (Double)value);
                            } else if (value instanceof Integer) {
                                jsonData.set(interanlStructFields[i].fieldName, ((Integer)value).intValue());
                            } else if (value instanceof Float) {
                                jsonData.set(interanlStructFields[i].fieldName, ((Float)value).floatValue());
                            } else if (value instanceof BigDecimal) {
                                jsonData.set(interanlStructFields[i].fieldName, ((BigDecimal)value).doubleValue());
                            } else if (value instanceof Struct) {
                                jsonData.set(interanlStructFields[i].fieldName, TableJSONDataSource.getStructData(((Struct)value).getAttributes(), interanlStructFields, i + 1));
                            }
                            structError = false;
                        }
                        ++i;
                    }
                }
                if (structError) {
                    throw new BallerinaException("error in constructing the json object from struct type data");
                }
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in retrieving struct data to construct the inner json object:" + e.getMessage());
        }
        return jsonData;
    }

    private static JsonNode getDataArray(BTable df, int columnIndex) {
        JsonNode jsonArray;
        block6: {
            Object obj;
            Object[] dataArray;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                dataArray = df.getArray(columnIndex);
                                int length = dataArray.length;
                                jsonArray = new JsonNode(JsonNode.Type.ARRAY);
                                if (length <= 0) break block6;
                                obj = dataArray[0];
                                if (!(obj instanceof String)) break block7;
                                for (Object value : dataArray) {
                                    jsonArray.add((String)value);
                                }
                                break block6;
                            }
                            if (!(obj instanceof Boolean)) break block8;
                            for (Object value : dataArray) {
                                jsonArray.add((Boolean)value);
                            }
                            break block6;
                        }
                        if (!(obj instanceof Integer)) break block9;
                        for (Object value : dataArray) {
                            jsonArray.add(((Integer)value).intValue());
                        }
                        break block6;
                    }
                    if (!(obj instanceof Long)) break block10;
                    for (Object value : dataArray) {
                        jsonArray.add((Long)value);
                    }
                    break block6;
                }
                if (!(obj instanceof Float)) break block11;
                for (Object value : dataArray) {
                    jsonArray.add(((Float)value).floatValue());
                }
                break block6;
            }
            if (!(obj instanceof Double)) break block6;
            for (Object value : dataArray) {
                jsonArray.add((Double)value);
            }
        }
        return jsonArray;
    }

    public static interface JSONObjectGenerator {
        public JsonNode transform(BTable var1) throws IOException;
    }

    private static class DefaultJSONObjectGenerator
    implements JSONObjectGenerator {
        private DefaultJSONObjectGenerator() {
        }

        @Override
        public JsonNode transform(BTable df) throws IOException {
            JsonNode objNode = new JsonNode(JsonNode.Type.OBJECT);
            BStructType structType = df.getStructType();
            BStructType.StructField[] structFields = null;
            if (structType != null) {
                structFields = structType.getStructFields();
            }
            int index = 0;
            for (ColumnDefinition col : df.getColumnDefs()) {
                String name = structFields != null ? structFields[index].getFieldName() : col.getName();
                TableJSONDataSource.constructJsonData(df, objNode, name, col.getType(), index + 1, structFields);
                ++index;
            }
            return objNode;
        }
    }
}

