/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.TypeSignature;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BValue;

public class BJSONType
extends BType {
    private BType constraint;

    public BJSONType(String typeName, String pkgPath) {
        super(typeName, pkgPath, BJSON.class);
    }

    public BJSONType(BType constraint) {
        super("json", null, BJSON.class);
        this.constraint = constraint;
    }

    public BType getConstrainedType() {
        return this.constraint;
    }

    @Override
    public <V extends BValue> V getZeroValue() {
        return null;
    }

    @Override
    public <V extends BValue> V getEmptyValue() {
        return (V)new BJSON("{}");
    }

    @Override
    public TypeSignature getSig() {
        if (this.constraint == null) {
            return new TypeSignature("J");
        }
        return new TypeSignature("J", this.constraint.getPackagePath(), this.constraint.getName());
    }

    @Override
    public int getTag() {
        return 9;
    }

    @Override
    public String toString() {
        if (this.constraint == null) {
            return super.toString();
        }
        return "json<" + this.constraint.getName() + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BJSONType)) {
            return false;
        }
        BJSONType other = (BJSONType)obj;
        if (this.constraint == other.constraint) {
            return true;
        }
        if (this.constraint == null || other.constraint == null) {
            return false;
        }
        return this.constraint.equals(other.constraint);
    }
}

