/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.TypeSignature;
import org.ballerinalang.model.values.BValue;

public class BUnionType
extends BType {
    private List<BType> memberTypes;
    private boolean nullable;

    public BUnionType() {
        super(null, null, BValue.class);
    }

    public BUnionType(List<BType> memberTypes) {
        super(null, null, BValue.class);
        this.memberTypes = memberTypes;
        this.nullable = memberTypes.contains(BTypes.typeNull);
    }

    public List<BType> getMemberTypes() {
        return this.memberTypes;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public <V extends BValue> V getZeroValue() {
        return null;
    }

    @Override
    public <V extends BValue> V getEmptyValue() {
        return null;
    }

    @Override
    public TypeSignature getSig() {
        return new TypeSignature("O", this.memberTypes.stream().map(type -> type.getSig()).collect(Collectors.toList()));
    }

    @Override
    public int getTag() {
        return 27;
    }

    @Override
    public String toString() {
        List list = this.memberTypes.stream().map(BType::toString).collect(Collectors.toList());
        return String.join((CharSequence)"|", list);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BUnionType)) {
            return false;
        }
        BUnionType that = (BUnionType)o;
        return Objects.equals(this.memberTypes, that.memberTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.memberTypes);
    }
}

