/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import java.util.List;

public class TypeSignature {
    public static final String SIG_INT = "I";
    public static final String SIG_FLOAT = "F";
    public static final String SIG_STRING = "S";
    public static final String SIG_BOOLEAN = "B";
    public static final String SIG_BLOB = "L";
    public static final String SIG_REFTYPE = "R";
    public static final String SIG_JSON = "J";
    public static final String SIG_TABLE = "D";
    public static final String SIG_FUTURE = "X";
    public static final String SIG_STREAM = "H";
    public static final String SIG_MAP = "M";
    public static final String SIG_CONNECTOR = "C";
    public static final String SIG_STRUCT = "T";
    public static final String SIG_ENUM = "E";
    public static final String SIG_FUNCTION = "U";
    public static final String SIG_ARRAY = "[";
    public static final String SIG_ANY = "A";
    public static final String SIG_TYPEDESC = "Y";
    public static final String SIG_VOID = "V";
    public static final String SIG_ANNOTATION = "@";
    public static final String SIG_UNION = "O";
    public static final String SIG_NULL = "N";
    public static final String SIG_TUPLE = "P";
    public static final String SIG_FINITE_TYPE = "G";
    private String sigChar;
    private TypeSignature elementTypeSig;
    private List<TypeSignature> memberTypeSigs;
    private String pkgPath;
    private String name;

    public TypeSignature(String sigChar) {
        this.sigChar = sigChar;
    }

    public TypeSignature(String sigChar, TypeSignature elementTypeSig) {
        this(sigChar);
        this.elementTypeSig = elementTypeSig;
    }

    public TypeSignature(String sigChar, List<TypeSignature> memberTypeSigs) {
        this(sigChar);
        this.memberTypeSigs = memberTypeSigs;
    }

    public TypeSignature(String sigChar, String name) {
        this(sigChar);
        this.name = name;
    }

    public TypeSignature(String sigChar, String packagePath, String name) {
        this(sigChar);
        this.pkgPath = packagePath;
        this.name = name;
    }

    public String getSigChar() {
        return this.sigChar;
    }

    public String getPkgPath() {
        return this.pkgPath;
    }

    public String getName() {
        return this.name;
    }

    public TypeSignature getElementTypeSig() {
        return this.elementTypeSig;
    }

    public String toString() {
        if (this.elementTypeSig != null) {
            return this.sigChar + this.elementTypeSig.toString();
        }
        if (this.memberTypeSigs != null) {
            StringBuilder sig = new StringBuilder(this.sigChar + this.memberTypeSigs.size() + ";");
            this.memberTypeSigs.forEach(memberSig -> sig.append(memberSig));
            return sig.toString();
        }
        if (this.pkgPath != null) {
            return this.sigChar + this.pkgPath + ":" + this.name + ";";
        }
        if (this.name != null) {
            return this.sigChar + this.name + ";";
        }
        return this.sigChar;
    }
}

