/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.ballerinalang.bre.bvm.CPU;
import org.ballerinalang.model.TableJSONDataSource;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BJSONType;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.BUnionType;
import org.ballerinalang.model.util.JsonNode;
import org.ballerinalang.model.util.XMLUtils;
import org.ballerinalang.model.util.XMLValidationUtils;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BBooleanArray;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BFloatArray;
import org.ballerinalang.model.values.BIntArray;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BTable;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.model.values.BXMLItem;
import org.ballerinalang.model.values.BXMLSequence;
import org.ballerinalang.util.codegen.StructFieldInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.exceptions.RuntimeErrors;

public class JSONUtils {
    private static final String NULL = "null";
    private static final OMFactory OM_FACTORY = OMAbstractFactory.getOMFactory();
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_PREFIX = "xsi";
    private static final String NIL = "nil";

    public static boolean hasElement(BJSON json, String elementName) {
        JsonNode jsonNode = json.value();
        return jsonNode.has(elementName);
    }

    public static BJSON convertMapToJSON(BMap<String, BValue> map) {
        return JSONUtils.convertMapToJSON(map, null);
    }

    public static BJSON convertMapToJSON(BMap<String, BValue> map, BJSONType targetType) {
        Set<String> keys = map.keySet();
        BJSON bjson = new BJSON(new JsonNode(JsonNode.Type.OBJECT));
        JsonNode jsonNode = bjson.value();
        for (String key : keys) {
            try {
                BValue bvalue = map.get(key);
                if (bvalue == null) {
                    jsonNode.set(key, new BJSON(NULL).value());
                    continue;
                }
                if (bvalue.getType() == BTypes.typeString) {
                    jsonNode.set(key, bvalue.stringValue());
                    continue;
                }
                if (bvalue.getType() == BTypes.typeInt) {
                    jsonNode.set(key, ((BInteger)bvalue).intValue());
                    continue;
                }
                if (bvalue.getType() == BTypes.typeFloat) {
                    jsonNode.set(key, ((BFloat)bvalue).floatValue());
                    continue;
                }
                if (bvalue.getType() == BTypes.typeBoolean) {
                    jsonNode.set(key, ((BBoolean)bvalue).booleanValue());
                    continue;
                }
                if (bvalue.getType().getTag() == 7) {
                    jsonNode.set(key, JSONUtils.convertMapToJSON((BMap)bvalue).value());
                    continue;
                }
                if (bvalue.getType() == BTypes.typeJSON) {
                    jsonNode.set(key, ((BJSON)bvalue).value());
                    continue;
                }
                if (bvalue instanceof BNewArray) {
                    jsonNode.set(key, JSONUtils.convertArrayToJSON((BNewArray)bvalue).value());
                    continue;
                }
                if (bvalue instanceof BStruct) {
                    jsonNode.set(key, JSONUtils.convertStructToJSON((BStruct)bvalue).value());
                    continue;
                }
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, BTypes.typeJSON, bvalue.getType());
            }
            catch (Exception e) {
                JSONUtils.handleError(e, key);
            }
        }
        if (targetType != null && !CPU.isAssignable(bjson, targetType)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, targetType, bjson.getType());
        }
        return bjson;
    }

    public static BJSON convertArrayToJSON(BIntArray intArray) {
        BJSON bjson = new BJSON(new JsonNode(JsonNode.Type.ARRAY));
        JsonNode arrayNode = bjson.value();
        int i = 0;
        while ((long)i < intArray.size()) {
            long value = intArray.get(i);
            arrayNode.add(value);
            ++i;
        }
        return bjson;
    }

    public static BJSON convertArrayToJSON(BFloatArray floatArray) {
        BJSON bjson = new BJSON(new JsonNode(JsonNode.Type.ARRAY));
        JsonNode arrayNode = bjson.value();
        int i = 0;
        while ((long)i < floatArray.size()) {
            double value = floatArray.get(i);
            arrayNode.add(value);
            ++i;
        }
        return bjson;
    }

    public static BJSON convertArrayToJSON(BStringArray stringArray) {
        BJSON bjson = new BJSON(new JsonNode(JsonNode.Type.ARRAY));
        JsonNode arrayNode = bjson.value();
        int i = 0;
        while ((long)i < stringArray.size()) {
            String value = stringArray.get(i);
            arrayNode.add(value);
            ++i;
        }
        return bjson;
    }

    public static BJSON convertArrayToJSON(BBooleanArray booleanArray) {
        BJSON bjson = new BJSON(new JsonNode(JsonNode.Type.ARRAY));
        JsonNode arrayNode = bjson.value();
        int i = 0;
        while ((long)i < booleanArray.size()) {
            int value = booleanArray.get(i);
            arrayNode.add(value == 1);
            ++i;
        }
        return bjson;
    }

    public static BJSON convertArrayToJSON(BNewArray bArray) {
        if (bArray instanceof BIntArray) {
            return JSONUtils.convertArrayToJSON((BIntArray)bArray);
        }
        if (bArray instanceof BFloatArray) {
            return JSONUtils.convertArrayToJSON((BFloatArray)bArray);
        }
        if (bArray instanceof BStringArray) {
            return JSONUtils.convertArrayToJSON((BStringArray)bArray);
        }
        if (bArray instanceof BBooleanArray) {
            return JSONUtils.convertArrayToJSON((BBooleanArray)bArray);
        }
        if (bArray instanceof BRefValueArray) {
            return JSONUtils.convertArrayToJSON((BRefValueArray)bArray);
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, BTypes.typeJSON, bArray.getType());
    }

    public static BJSON convertArrayToJSON(BRefValueArray refValueArray) {
        BJSON bjson = new BJSON(new JsonNode(JsonNode.Type.ARRAY));
        JsonNode arrayNode = bjson.value();
        int i = 0;
        while ((long)i < refValueArray.size()) {
            BRefType value = refValueArray.get(i);
            if (value == null) {
                arrayNode.add(new BJSON(NULL).value());
            } else if (value.getType().getTag() == 7) {
                arrayNode.add(JSONUtils.convertMapToJSON((BMap)value).value());
            } else if (value instanceof BJSON) {
                arrayNode.add(((BJSON)value).value());
            } else if (value instanceof BStruct) {
                arrayNode.add(JSONUtils.convertStructToJSON((BStruct)value).value());
            } else if (value instanceof BNewArray) {
                arrayNode.add(JSONUtils.convertArrayToJSON((BNewArray)value).value());
            } else {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, BTypes.typeJSON, value.getType());
            }
            ++i;
        }
        return bjson;
    }

    public static BJSON convertStructToJSON(BStruct struct) {
        return JSONUtils.convertStructToJSON(struct, null);
    }

    public static BJSON convertStructToJSON(BStruct struct, BJSONType targetType) {
        BJSON bjson = new BJSON(new JsonNode(JsonNode.Type.OBJECT));
        JsonNode jsonNode = bjson.value();
        BStructType structType = struct.getType();
        int longRegIndex = -1;
        int doubleRegIndex = -1;
        int stringRegIndex = -1;
        int booleanRegIndex = -1;
        int refRegIndex = -1;
        for (BStructType.StructField structField : structType.getStructFields()) {
            String key = structField.getFieldName();
            BType fieldType = structField.getFieldType();
            try {
                switch (fieldType.getTag()) {
                    case 1: {
                        jsonNode.set(key, struct.getIntField(++longRegIndex));
                        break;
                    }
                    case 2: {
                        jsonNode.set(key, struct.getFloatField(++doubleRegIndex));
                        break;
                    }
                    case 3: {
                        jsonNode.set(key, struct.getStringField(++stringRegIndex));
                        break;
                    }
                    case 4: {
                        jsonNode.set(key, struct.getBooleanField(++booleanRegIndex) == 1);
                        break;
                    }
                    case 5: {
                        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, BTypes.typeJSON, BTypes.typeBlob);
                    }
                    default: {
                        BRefType value = struct.getRefField(++refRegIndex);
                        if (value == null) {
                            jsonNode.set(key, new BJSON(NULL).value());
                            break;
                        }
                        if (value.getType().getTag() == 7) {
                            jsonNode.set(key, JSONUtils.convertMapToJSON((BMap)value).value());
                            break;
                        }
                        if (value instanceof BJSON) {
                            jsonNode.set(key, ((BJSON)value).value());
                            break;
                        }
                        if (value instanceof BNewArray) {
                            jsonNode.set(key, JSONUtils.convertArrayToJSON((BNewArray)value).value());
                            break;
                        }
                        if (value instanceof BStruct) {
                            jsonNode.set(key, JSONUtils.convertStructToJSON((BStruct)value).value());
                            break;
                        }
                        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, BTypes.typeJSON, value.getType());
                    }
                }
            }
            catch (Exception e) {
                JSONUtils.handleError(e, key);
            }
        }
        if (targetType != null && !CPU.isAssignable(bjson, targetType)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, targetType, bjson.getType());
        }
        return bjson;
    }

    public static BJSON toJSON(BTable table, boolean isInTransaction) {
        return new BJSON(new TableJSONDataSource(table, isInTransaction));
    }

    public static BJSON getElement(BJSON json, String elementName) {
        JsonNode jsonNode = json.value();
        if (!jsonNode.isObject()) {
            return null;
        }
        try {
            JsonNode element = jsonNode.get(elementName);
            if (element == null || element.isNull()) {
                return null;
            }
            return new BJSON(element);
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, t.getMessage());
        }
    }

    public static void setElement(BJSON json, String elementName, BJSON element) {
        JsonNode jsonElement;
        if (json == null) {
            return;
        }
        JsonNode jsonNode = json.value();
        JsonNode jsonNode2 = jsonElement = element == null ? null : element.value();
        if (!jsonNode.isObject()) {
            return;
        }
        try {
            jsonNode.set(elementName, jsonElement);
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_SET_ERROR, t.getMessage());
        }
    }

    public static boolean isJSONArray(BJSON json) {
        if (json == null) {
            return false;
        }
        JsonNode jsonNode = json.value();
        return jsonNode.isArray();
    }

    public static int getJSONArrayLength(BJSON json) {
        if (json == null) {
            return -1;
        }
        JsonNode jsonNode = json.value();
        return jsonNode.size();
    }

    public static BJSON getArrayElement(BJSON json, long index) {
        JsonNode jsonNode = json.value();
        if (!jsonNode.isArray()) {
            return null;
        }
        try {
            if ((long)jsonNode.size() <= index) {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, jsonNode.size());
            }
            JsonNode element = jsonNode.get((int)index);
            if (element == null || element.isNull()) {
                return null;
            }
            return new BJSON(element);
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, t.getMessage());
        }
    }

    public static void setArrayElement(BJSON json, long index, BJSON element) {
        if (json == null) {
            return;
        }
        JsonNode arrayNode = json.value();
        if (!arrayNode.isArray()) {
            return;
        }
        JsonNode jsonElement = element == null ? null : element.value();
        try {
            if ((long)arrayNode.size() <= index) {
                int i = arrayNode.size();
                while ((long)i < index) {
                    arrayNode.addNull();
                    ++i;
                }
                arrayNode.add(jsonElement);
            } else {
                arrayNode.set((int)index, jsonElement);
            }
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_SET_ERROR, t.getMessage());
        }
    }

    public static BXML convertToXML(BJSON json, String attributePrefix, String arrayEntryTag) {
        BXML xml;
        JsonNode jsonNode = json.value();
        List<BXML> omElementArrayList = JSONUtils.traverseTree(jsonNode, attributePrefix, arrayEntryTag);
        if (omElementArrayList.size() == 1) {
            xml = omElementArrayList.get(0);
        } else {
            BRefValueArray elementsSeq = new BRefValueArray();
            int count = omElementArrayList.size();
            for (int i = 0; i < count; ++i) {
                elementsSeq.add(i, omElementArrayList.get(i));
            }
            xml = new BXMLSequence(elementsSeq);
        }
        return xml;
    }

    private static List<BXML> traverseTree(JsonNode node, String attributePrefix, String arrayEntryTag) {
        ArrayList<BXML> xmlArray = new ArrayList<BXML>();
        if (node.isValueNode()) {
            BXML<?> xml = XMLUtils.parse(node.asText());
            xmlArray.add(xml);
        } else {
            JSONUtils.traverseJsonNode(node, null, null, xmlArray, attributePrefix, arrayEntryTag);
        }
        return xmlArray;
    }

    private static OMElement traverseJsonNode(JsonNode node, String nodeName, OMElement parentElement, List<BXML> omElementArrayList, String attributePrefix, String arrayEntryTag) {
        OMElement currentRoot = null;
        if (nodeName != null) {
            if (nodeName.startsWith(attributePrefix)) {
                if (!node.isValueNode()) {
                    throw new BallerinaException("attribute cannot be an object or array");
                }
                if (parentElement != null) {
                    String attributeKey = nodeName.substring(1);
                    XMLValidationUtils.validateXMLName(attributeKey);
                    parentElement.addAttribute(attributeKey, node.asText(), null);
                }
                return parentElement;
            }
            XMLValidationUtils.validateXMLName(nodeName);
            currentRoot = OM_FACTORY.createOMElement(nodeName, null);
        }
        if (node.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> nodeIterator = node.fields();
            while (nodeIterator.hasNext()) {
                Map.Entry<String, JsonNode> nodeEntry = nodeIterator.next();
                JsonNode objectNode = nodeEntry.getValue();
                currentRoot = JSONUtils.traverseJsonNode(objectNode, nodeEntry.getKey(), currentRoot, omElementArrayList, attributePrefix, arrayEntryTag);
                if (nodeName != null) continue;
                omElementArrayList.add(new BXMLItem((OMNode)currentRoot));
                currentRoot = null;
            }
        } else if (node.isArray()) {
            Iterator<JsonNode> arrayItemsIterator = node.elements();
            while (arrayItemsIterator.hasNext()) {
                JsonNode arrayNode = arrayItemsIterator.next();
                currentRoot = JSONUtils.traverseJsonNode(arrayNode, arrayEntryTag, currentRoot, omElementArrayList, attributePrefix, arrayEntryTag);
                if (nodeName != null) continue;
                omElementArrayList.add(new BXMLItem((OMNode)currentRoot));
                currentRoot = null;
            }
        } else if (node.isValueNode() && currentRoot != null) {
            if (node.isNull()) {
                OMNamespace xsiNameSpace = OM_FACTORY.createOMNamespace(XSI_NAMESPACE, XSI_PREFIX);
                currentRoot.addAttribute(NIL, "true", xsiNameSpace);
            } else {
                OMText txt1 = OM_FACTORY.createOMText((OMContainer)currentRoot, node.asText());
                currentRoot.addChild((OMNode)txt1);
            }
        } else {
            throw new BallerinaException("error in converting json to xml");
        }
        if (parentElement != null) {
            parentElement.addChild((OMNode)currentRoot);
            currentRoot = parentElement;
        }
        return currentRoot;
    }

    private static long jsonNodeToInt(JsonNode jsonNode) {
        if (jsonNode.isLong()) {
            return jsonNode.longValue();
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeInt, JSONUtils.getTypeName(jsonNode));
    }

    private static double jsonNodeToFloat(JsonNode jsonNode) {
        if (jsonNode.isDouble()) {
            return jsonNode.doubleValue();
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeFloat, JSONUtils.getTypeName(jsonNode));
    }

    private static boolean jsonNodeToBool(JsonNode jsonNode) {
        if (jsonNode.isBoolean()) {
            return jsonNode.booleanValue();
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeBoolean, JSONUtils.getTypeName(jsonNode));
    }

    public static BMap<String, ?> jsonNodeToBMap(JsonNode jsonNode, BMapType mapType) {
        BMap<String, BValue> map = new BMap<String, BValue>(mapType);
        if (!jsonNode.isObject()) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, JSONUtils.getComplexObjectTypeName(JsonNode.Type.OBJECT), JSONUtils.getTypeName(jsonNode));
        }
        Iterator<Map.Entry<String, JsonNode>> fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry<String, JsonNode> field = fields.next();
            BValue bValue = JSONUtils.getBValue(field.getValue(), mapType.getConstrainedType());
            map.put(field.getKey(), bValue);
        }
        return map;
    }

    public static BStruct convertJSONToStruct(BJSON bjson, BStructType structType) {
        return JSONUtils.convertJSONNodeToStruct(bjson.value(), structType);
    }

    public static BStruct convertJSONNodeToStruct(JsonNode jsonNode, BStructType structType) {
        if (!jsonNode.isObject()) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, JSONUtils.getComplexObjectTypeName(JsonNode.Type.OBJECT), JSONUtils.getTypeName(jsonNode));
        }
        int longRegIndex = -1;
        int doubleRegIndex = -1;
        int stringRegIndex = -1;
        int booleanRegIndex = -1;
        int refRegIndex = -1;
        int blobRegIndex = -1;
        BStruct bStruct = new BStruct(structType);
        StructInfo structInfo = structType.structInfo;
        block11: for (StructFieldInfo fieldInfo : structInfo.getFieldInfoEntries()) {
            BType fieldType = fieldInfo.getFieldType();
            String fieldName = fieldInfo.getName();
            try {
                boolean fieldExists = jsonNode.has(fieldName);
                JsonNode jsonValue = jsonNode.get(fieldName);
                switch (fieldType.getTag()) {
                    case 1: {
                        ++longRegIndex;
                        if (!fieldExists) continue block11;
                        bStruct.setIntField(longRegIndex, JSONUtils.jsonNodeToInt(jsonValue));
                        break;
                    }
                    case 2: {
                        ++doubleRegIndex;
                        if (!fieldExists) continue block11;
                        bStruct.setFloatField(doubleRegIndex, JSONUtils.jsonNodeToFloat(jsonValue));
                        break;
                    }
                    case 3: {
                        String stringVal = !fieldExists ? "" : (jsonValue.isString() ? jsonValue.stringValue() : jsonValue.toString());
                        bStruct.setStringField(++stringRegIndex, stringVal);
                        break;
                    }
                    case 4: {
                        ++booleanRegIndex;
                        if (!fieldExists) continue block11;
                        bStruct.setBooleanField(booleanRegIndex, JSONUtils.jsonNodeToBool(jsonValue) ? 1 : 0);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 9: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 27: {
                        ++refRegIndex;
                        if (!fieldExists) continue block11;
                        bStruct.setRefField(refRegIndex, (BRefType)JSONUtils.convertJSON(jsonValue, fieldType));
                        break;
                    }
                    case 14: {
                        if (fieldExists) {
                            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, fieldName, JSONUtils.getTypeName(jsonValue));
                        }
                        bStruct.setRefField(++refRegIndex, null);
                        break;
                    }
                    case 5: {
                        bStruct.setBlobField(++blobRegIndex, new byte[0]);
                        break;
                    }
                    default: {
                        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, fieldName, JSONUtils.getTypeName(jsonValue));
                    }
                }
            }
            catch (Exception e) {
                JSONUtils.handleError(e, fieldName);
            }
        }
        return bStruct;
    }

    public static Object convertJSON(JsonNode jsonValue, BType targetType) {
        switch (targetType.getTag()) {
            case 1: {
                return JSONUtils.jsonNodeToInt(jsonValue);
            }
            case 2: {
                return JSONUtils.jsonNodeToFloat(jsonValue);
            }
            case 3: {
                if (jsonValue.isString()) {
                    return jsonValue.stringValue();
                }
                return jsonValue.toString();
            }
            case 4: {
                return JSONUtils.jsonNodeToBool(jsonValue);
            }
            case 27: {
                BUnionType type = (BUnionType)targetType;
                if (jsonValue.isNull() && type.isNullable()) {
                    return null;
                }
                List matchingTypes = type.getMemberTypes().stream().filter(memberType -> memberType != BTypes.typeNull).collect(Collectors.toList());
                if (matchingTypes.size() != 1) break;
                return JSONUtils.convertJSON(jsonValue, (BType)matchingTypes.get(0));
            }
            case 15: {
                return JSONUtils.convertJSONNodeToStruct(jsonValue, (BStructType)targetType);
            }
            case 6: 
            case 9: {
                if (jsonValue.isNull()) {
                    return null;
                }
                return new BJSON(jsonValue);
            }
            case 16: {
                return JSONUtils.jsonNodeToBArray(jsonValue, (BArrayType)targetType);
            }
            case 7: {
                return JSONUtils.jsonNodeToBMap(jsonValue, (BMapType)targetType);
            }
            case 18: {
                if (!jsonValue.isNull()) break;
                return null;
            }
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, targetType, JSONUtils.getTypeName(jsonValue));
    }

    public static BStringArray getKeys(BJSON json) {
        if (json == null) {
            return new BStringArray();
        }
        JsonNode node = json.value();
        if (!node.isObject()) {
            return new BStringArray();
        }
        ArrayList<String> keys = new ArrayList<String>();
        Iterator<String> keysItr = node.fieldNames();
        while (keysItr.hasNext()) {
            keys.add(keysItr.next());
        }
        return new BStringArray(keys.toArray(new String[keys.size()]));
    }

    public static BRefType<?> convertUnionTypeToJSON(BRefType<?> source) {
        if (source == null) {
            return null;
        }
        switch (source.getType().getTag()) {
            case 1: {
                return new BJSON(new JsonNode(((BInteger)source).intValue()));
            }
            case 2: {
                return new BJSON(new JsonNode(((BFloat)source).floatValue()));
            }
            case 3: {
                return new BJSON(new JsonNode(((BString)source).stringValue()));
            }
            case 4: {
                return new BJSON(new JsonNode(((BBoolean)source).booleanValue()));
            }
            case 18: {
                return null;
            }
            case 7: {
                return JSONUtils.convertMapToJSON((BMap)source);
            }
            case 15: {
                return JSONUtils.convertStructToJSON((BStruct)source);
            }
            case 9: {
                return source;
            }
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, BTypes.typeJSON, source.getType());
    }

    public static void remove(BJSON json, String fieldName) {
        JsonNode node = json.value();
        if (!node.isObject()) {
            return;
        }
        node.remove(fieldName);
    }

    private static BNewArray jsonNodeToBArray(JsonNode arrayNode, BArrayType targetArrayType) {
        if (!arrayNode.isArray()) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, JSONUtils.getComplexObjectTypeName(JsonNode.Type.ARRAY), JSONUtils.getTypeName(arrayNode));
        }
        BType elementType = targetArrayType.getElementType();
        switch (elementType.getTag()) {
            case 1: {
                return JSONUtils.jsonNodeToBIntArray(arrayNode);
            }
            case 2: {
                return JSONUtils.jsonNodeToBFloatArray(arrayNode);
            }
            case 3: {
                return JSONUtils.jsonNodeToBStringArray(arrayNode);
            }
            case 4: {
                return JSONUtils.jsonNodeToBBooleanArray(arrayNode);
            }
            case 6: {
                BRefValueArray refValueArray = new BRefValueArray(elementType);
                for (int i = 0; i < arrayNode.size(); ++i) {
                    JsonNode element = arrayNode.get(i);
                    refValueArray.add(i, (BRefType)JSONUtils.getBValue(element));
                }
                return refValueArray;
            }
        }
        BRefValueArray refValueArray = new BRefValueArray(elementType);
        for (int i = 0; i < arrayNode.size(); ++i) {
            JsonNode element = arrayNode.get(i);
            if (elementType.getTag() == 7) {
                refValueArray.add(i, JSONUtils.jsonNodeToBMap(element, (BMapType)elementType));
                continue;
            }
            if (elementType instanceof BStructType) {
                refValueArray.add(i, JSONUtils.convertJSONNodeToStruct(element, (BStructType)elementType));
                continue;
            }
            if (elementType instanceof BArrayType) {
                refValueArray.add(i, JSONUtils.jsonNodeToBArray(element, (BArrayType)elementType));
                continue;
            }
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING, elementType, JSONUtils.getTypeName(element));
        }
        return refValueArray;
    }

    private static BIntArray jsonNodeToBIntArray(JsonNode arrayNode) {
        BIntArray intArray = new BIntArray();
        for (int i = 0; i < arrayNode.size(); ++i) {
            JsonNode jsonValue = arrayNode.get(i);
            intArray.add(i, JSONUtils.jsonNodeToInt(jsonValue));
        }
        return intArray;
    }

    private static BFloatArray jsonNodeToBFloatArray(JsonNode arrayNode) {
        BFloatArray floatArray = new BFloatArray();
        for (int i = 0; i < arrayNode.size(); ++i) {
            JsonNode jsonValue = arrayNode.get(i);
            floatArray.add(i, JSONUtils.jsonNodeToFloat(jsonValue));
        }
        return floatArray;
    }

    private static BStringArray jsonNodeToBStringArray(JsonNode arrayNode) {
        BStringArray stringArray = new BStringArray();
        for (int i = 0; i < arrayNode.size(); ++i) {
            JsonNode jsonValue = arrayNode.get(i);
            String value = jsonValue.isString() ? jsonValue.stringValue() : jsonValue.toString();
            stringArray.add(i, value);
        }
        return stringArray;
    }

    private static BBooleanArray jsonNodeToBBooleanArray(JsonNode arrayNode) {
        BBooleanArray booleanArray = new BBooleanArray();
        for (int i = 0; i < arrayNode.size(); ++i) {
            JsonNode jsonValue = arrayNode.get(i);
            booleanArray.add(i, JSONUtils.jsonNodeToBool(jsonValue) ? 1 : 0);
        }
        return booleanArray;
    }

    private static BValue getBValue(JsonNode json) {
        return JSONUtils.getBValue(json, null);
    }

    private static boolean checkTypes(BType lhs, BType rhs) {
        if (lhs == null) {
            return true;
        }
        if (lhs.getTag() == rhs.getTag()) {
            return true;
        }
        return lhs.getTag() == 6;
    }

    private static BValue getBValue(JsonNode json, BType type) {
        if (json == null || json.isNull()) {
            return null;
        }
        if (json.isString()) {
            if (JSONUtils.checkTypes(type, BTypes.typeString)) {
                return new BString(json.stringValue());
            }
        } else if (json.isLong()) {
            if (JSONUtils.checkTypes(type, BTypes.typeInt)) {
                return new BInteger(json.longValue());
            }
        } else if (json.isDouble()) {
            if (JSONUtils.checkTypes(type, BTypes.typeFloat)) {
                return new BFloat(json.doubleValue());
            }
        } else if (json.isBoolean()) {
            if (JSONUtils.checkTypes(type, BTypes.typeBoolean)) {
                return new BBoolean(json.booleanValue());
            }
        } else {
            if (type == null || type.getTag() == BTypes.typeAny.getTag()) {
                return new BJSON(json);
            }
            if (type instanceof BStructType) {
                return JSONUtils.convertJSONNodeToStruct(json, (BStructType)type);
            }
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, type, JSONUtils.getTypeName(json));
    }

    public static String getTypeName(JsonNode jsonValue) {
        if (jsonValue == null) {
            return NULL;
        }
        JsonNode.Type nodeType = jsonValue.getType();
        switch (nodeType) {
            case LONG: {
                return "int";
            }
            case DOUBLE: {
                return "float";
            }
            case ARRAY: 
            case OBJECT: {
                return JSONUtils.getComplexObjectTypeName(nodeType);
            }
        }
        return nodeType.name().toLowerCase();
    }

    private static String getComplexObjectTypeName(JsonNode.Type nodeType) {
        return "json-" + nodeType.name().toLowerCase();
    }

    private static void handleError(Exception e, String fieldName) {
        String errorMsg = e.getCause() == null ? "error while mapping '" + fieldName + "': " : "";
        throw new BallerinaException(errorMsg + e.getMessage(), e);
    }
}

