/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.util.JsonGenerator;
import org.ballerinalang.util.exceptions.BallerinaException;

public class JsonNode {
    private String stringValue;
    private long longValue;
    private double doubleValue;
    private boolean booleanValue;
    private Type type;
    private Map<String, JsonNode> fields;
    private List<JsonNode> arrayElements;
    protected JsonNode parentNode;
    protected String fieldName;

    public JsonNode() {
        this(Type.OBJECT);
    }

    public JsonNode(Type type) {
        this.type = type;
    }

    public JsonNode(String stringValue) {
        this.setString(stringValue);
    }

    public JsonNode(long longValue) {
        this.setNumber(longValue);
    }

    public JsonNode(double doubleValue) {
        this.setNumber(doubleValue);
    }

    public JsonNode(boolean booleanValue) {
        this.setBooleanValue(booleanValue);
    }

    public Type getType() {
        return this.type;
    }

    public void add(JsonNode arrayElement) {
        if (this.arrayElements == null) {
            this.arrayElements = new LinkedList<JsonNode>();
        }
        this.arrayElements.add(arrayElement);
    }

    public void add(long value) {
        this.add(new JsonNode(value));
    }

    public void add(double value) {
        this.add(new JsonNode(value));
    }

    public void add(boolean value) {
        this.add(new JsonNode(value));
    }

    public void add(String value) {
        this.add(new JsonNode(value));
    }

    public void addNull() {
        this.add(new JsonNode(Type.NULL));
    }

    public void setString(String stringValue) {
        if (stringValue != null) {
            this.stringValue = stringValue;
            this.type = Type.STRING;
        } else {
            this.type = Type.NULL;
        }
    }

    public void setNumber(long longValue) {
        this.longValue = longValue;
        this.type = Type.LONG;
    }

    public void setNumber(double doubleValue) {
        this.doubleValue = doubleValue;
        this.type = Type.DOUBLE;
    }

    public void setBooleanValue(boolean booleanValue) {
        this.booleanValue = booleanValue;
        this.type = Type.BOOLEAN;
    }

    public void setNull() {
        this.type = Type.NULL;
    }

    public boolean isNull() {
        return this.type == Type.NULL;
    }

    public boolean isObject() {
        return this.type == Type.OBJECT;
    }

    public boolean isArray() {
        return this.type == Type.ARRAY;
    }

    public boolean isValueNode() {
        return this.isString() || this.isLong() || this.isDouble() || this.isBoolean() || this.isNull();
    }

    public boolean isLong() {
        return this.type == Type.LONG;
    }

    public boolean isDouble() {
        return this.type == Type.DOUBLE;
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isBoolean() {
        return this.type == Type.BOOLEAN;
    }

    public int size() {
        if (this.arrayElements != null) {
            return this.arrayElements.size();
        }
        return 0;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public long longValue() {
        return this.longValue;
    }

    public double doubleValue() {
        return this.doubleValue;
    }

    public boolean booleanValue() {
        return this.booleanValue;
    }

    public void set(String name, String stringValue) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, JsonNode>();
        }
        if (stringValue == null) {
            this.fields.put(name, new JsonNode(Type.NULL));
        } else {
            this.fields.put(name, new JsonNode(stringValue));
        }
    }

    public void set(String name, long longValue) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, JsonNode>();
        }
        this.fields.put(name, new JsonNode(longValue));
    }

    public void set(String name, double doubleValue) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, JsonNode>();
        }
        this.fields.put(name, new JsonNode(doubleValue));
    }

    public void set(String name, boolean booleanValue) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, JsonNode>();
        }
        this.fields.put(name, new JsonNode(booleanValue));
    }

    public void set(String name, JsonNode jsonNode) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, JsonNode>();
        }
        if (jsonNode != null) {
            this.fields.put(name, jsonNode);
        } else {
            this.fields.put(name, new JsonNode(Type.NULL));
        }
    }

    public void set(int index, JsonNode jsonNode) {
        if (this.arrayElements == null) {
            throw new BallerinaException("JSON array is empty to set values");
        }
        this.arrayElements.set(index, jsonNode);
    }

    public boolean has(String name) {
        return this.get(name) != null;
    }

    public JsonNode get(String name) {
        if (this.fields != null) {
            return this.fields.get(name);
        }
        return null;
    }

    public JsonNode get(int index) {
        if (this.arrayElements != null) {
            return this.arrayElements.get(index);
        }
        return null;
    }

    public String asText() {
        switch (this.type) {
            case BOOLEAN: {
                return Boolean.toString(this.booleanValue());
            }
            case DOUBLE: {
                return Double.toString(this.doubleValue());
            }
            case LONG: {
                return Long.toString(this.longValue());
            }
            case NULL: {
                return "null";
            }
            case STRING: {
                return this.stringValue();
            }
        }
        return "";
    }

    public Iterator<String> fieldNames() {
        if (this.fields != null) {
            return this.fields.keySet().iterator();
        }
        return new HashSet(0).iterator();
    }

    public Iterator<Map.Entry<String, JsonNode>> fields() {
        if (this.fields != null) {
            return new LinkedHashMap<String, JsonNode>(this.fields).entrySet().iterator();
        }
        return new LinkedHashMap(0).entrySet().iterator();
    }

    public Iterator<JsonNode> elements() {
        if (this.arrayElements != null) {
            return this.arrayElements.iterator();
        }
        return new ArrayList(0).iterator();
    }

    public void remove(String fieldName) {
        if (this.fields != null) {
            this.fields.remove(fieldName);
        }
    }

    public String toString() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        JsonGenerator gen = new JsonGenerator(byteOut);
        try {
            this.serialize(gen);
            gen.flush();
        }
        catch (IOException e) {
            throw new BallerinaException("Error in converting JSON to a string: " + e.getMessage(), e);
        }
        return new String(byteOut.toByteArray());
    }

    public void serialize(OutputStream out) throws IOException {
        JsonGenerator gen = new JsonGenerator(out);
        this.serialize(gen);
        gen.flush();
    }

    public void serialize(JsonGenerator gen) throws IOException {
        switch (this.type) {
            case ARRAY: {
                gen.writeStartArray();
                if (this.arrayElements != null) {
                    for (JsonNode node : this.arrayElements) {
                        if (node != null) {
                            node.serialize(gen);
                            continue;
                        }
                        gen.writeNull();
                    }
                }
                gen.writeEndArray();
                break;
            }
            case BOOLEAN: {
                gen.writeBoolean(this.booleanValue);
                break;
            }
            case DOUBLE: {
                gen.writeNumber(this.doubleValue);
                break;
            }
            case LONG: {
                gen.writeNumber(this.longValue);
                break;
            }
            case NULL: {
                gen.writeNull();
                break;
            }
            case OBJECT: {
                gen.startObject();
                if (this.fields != null) {
                    for (Map.Entry<String, JsonNode> entry : this.fields.entrySet()) {
                        gen.writeFieldName(entry.getKey());
                        JsonNode value = entry.getValue();
                        if (value != null) {
                            entry.getValue().serialize(gen);
                            continue;
                        }
                        gen.writeNull();
                    }
                }
                gen.endObject();
                break;
            }
            case STRING: {
                gen.writeString(this.stringValue);
                break;
            }
        }
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        STRING,
        LONG,
        DOUBLE,
        BOOLEAN,
        NULL;

    }
}

