/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.Arrays;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BBlob;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BValue;

public class BBlobArray
extends BNewArray {
    private static BType arrayType = new BArrayType(BTypes.typeBlob);
    private byte[][] values;

    public BBlobArray(byte[][] values) {
        this.values = values;
        this.size = values.length;
    }

    public BBlobArray() {
        this.values = (byte[][])this.newArrayInstance(byte[].class);
    }

    public void add(long index, byte[] value) {
        this.prepareForAdd(index, this.values.length);
        this.values[(int)index] = value;
    }

    public byte[] get(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.values[(int)index];
    }

    @Override
    public BType getType() {
        return arrayType;
    }

    @Override
    public void grow(int newLength) {
        this.values = (byte[][])Arrays.copyOf(this.values, newLength);
    }

    @Override
    public BValue copy() {
        BBlobArray blobArray = new BBlobArray((byte[][])Arrays.copyOf(this.values, this.values.length));
        blobArray.size = this.size;
        return blobArray;
    }

    @Override
    public BValue getBValue(long index) {
        return new BBlob(this.get(index));
    }
}

