/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;

public final class BFloat
extends BValueType
implements BRefType<Double> {
    private double value;

    public BFloat(double value) {
        this.value = value;
    }

    @Override
    public long intValue() {
        return (long)this.value;
    }

    @Override
    public double floatValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return false;
    }

    @Override
    public byte[] blobValue() {
        return null;
    }

    @Override
    public String stringValue() {
        return Double.toString(this.value);
    }

    @Override
    public BType getType() {
        return BTypes.typeFloat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BFloat bFloat = (BFloat)o;
        return Double.compare(bFloat.value, this.value) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.value);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public Double value() {
        return this.value;
    }

    @Override
    public BValue copy() {
        return new BFloat(this.value);
    }
}

