/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.Arrays;
import java.util.StringJoiner;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BValue;

public class BFloatArray
extends BNewArray {
    private static BType arrayType = new BArrayType(BTypes.typeFloat);
    private double[] values;

    public BFloatArray(double[] values) {
        this.values = values;
        this.size = values.length;
    }

    public BFloatArray() {
        this.values = (double[])this.newArrayInstance(Double.TYPE);
    }

    public void add(long index, double value) {
        this.prepareForAdd(index, this.values.length);
        this.values[(int)index] = value;
    }

    public double get(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.values[(int)index];
    }

    @Override
    public BType getType() {
        return arrayType;
    }

    @Override
    public void grow(int newLength) {
        this.values = Arrays.copyOf(this.values, newLength);
    }

    @Override
    public BValue copy() {
        BFloatArray floatArray = new BFloatArray(Arrays.copyOf(this.values, this.values.length));
        floatArray.size = this.size;
        return floatArray;
    }

    @Override
    public String stringValue() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (int i = 0; i < this.size; ++i) {
            sj.add(Double.toString(this.values[i]));
        }
        return sj.toString();
    }

    @Override
    public BValue getBValue(long index) {
        return new BFloat(this.get(index));
    }
}

