/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BCollection;
import org.ballerinalang.model.values.BIntArray;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;

public class BIntRange
implements BRefType,
BCollection {
    private long startValue;
    private long endValue;

    public BIntRange(long startValue, long endValue) {
        this.startValue = startValue;
        this.endValue = endValue;
    }

    @Override
    public String stringValue() {
        return null;
    }

    @Override
    public BIterator newIterator() {
        return new BIntRangeIterator(this);
    }

    @Override
    public BType getType() {
        return BIntArray.arrayType;
    }

    @Override
    public BValue copy() {
        return null;
    }

    public Object value() {
        return null;
    }

    static class BIntRangeIterator
    implements BIterator {
        private BIntRange collection;
        long cursor = 0L;
        long currentValue;

        BIntRangeIterator(BIntRange collection) {
            this.collection = collection;
            this.currentValue = collection.startValue;
        }

        @Override
        public BValue[] getNext(int arity) {
            long cursor = this.cursor++;
            long currentValue = this.currentValue++;
            if (arity == 1) {
                return new BValue[]{new BInteger(currentValue)};
            }
            return new BValue[]{new BInteger(cursor), new BInteger(currentValue)};
        }

        @Override
        public boolean hasNext() {
            return this.collection.startValue <= this.currentValue && this.currentValue <= this.collection.endValue;
        }
    }
}

