/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BCollection;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.runtime.message.BallerinaMessageDataSource;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BMap<K, V extends BValue>
extends BallerinaMessageDataSource
implements BRefType,
BCollection {
    private LinkedHashMap<K, V> map;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private BType type = BTypes.typeMap;

    public BMap() {
        this.map = new LinkedHashMap();
    }

    public BMap(BMapType type) {
        this.map = new LinkedHashMap();
        this.type = type;
    }

    public V get(K key) {
        this.readLock.lock();
        try {
            if (!this.map.containsKey(key)) {
                throw new BallerinaException("cannot find key '" + key + "'");
            }
            BValue bValue = (BValue)this.map.get(key);
            return (V)bValue;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, boolean except) {
        this.readLock.lock();
        try {
            if (!this.map.containsKey(key) && except) {
                throw new BallerinaException("cannot find key '" + key + "'");
            }
            BValue bValue = (BValue)this.map.get(key);
            return (V)bValue;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void put(K key, V value) {
        this.writeLock.lock();
        try {
            this.map.put(key, value);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasKey(K key) {
        this.readLock.lock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public LinkedHashMap<K, V> getMap() {
        return this.map;
    }

    public int size() {
        this.readLock.lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        this.writeLock.lock();
        try {
            boolean hasKey = this.map.containsKey(key);
            if (hasKey) {
                this.map.remove(key);
            }
            boolean bl = hasKey;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<K> keySet() {
        this.readLock.lock();
        try {
            Set<K> set = this.map.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.map.size() == 0;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Object value() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stringValue() {
        this.readLock.lock();
        try {
            StringJoiner sj = new StringJoiner(", ", "{", "}");
            for (Map.Entry<K, V> e : this.map.entrySet()) {
                String key = "\"" + (String)e.getKey() + "\"";
                BValue value = (BValue)e.getValue();
                String stringValue = value == null ? null : (value instanceof BString ? "\"" + value.stringValue() + "\"" : value.stringValue());
                sj.add(key + ":" + stringValue);
            }
            String string = sj.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public BType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BValue copy() {
        this.readLock.lock();
        try {
            BMap newMap = (BMap)BTypes.typeMap.getEmptyValue();
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                BValue value = (BValue)entry.getValue();
                newMap.put(entry.getKey(), value == null ? null : value.copy());
            }
            BMap bMap = newMap;
            return bMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getMessageAsString() {
        return this.stringValue();
    }

    @Override
    public void serializeData(OutputStream outputStream) {
        try {
            outputStream.write(this.stringValue().getBytes(Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new BallerinaException("Error occurred while serializing data", e);
        }
    }

    @Override
    public BIterator newIterator() {
        return new BMapIterator(this);
    }

    static class BMapIterator<K, V extends BValue>
    implements BIterator {
        BMap<K, V> collection;
        Iterator<Map.Entry<K, V>> iterator;

        BMapIterator(BMap<K, V> value) {
            this.collection = value;
            this.iterator = new LinkedHashMap(((BMap)value).map).entrySet().iterator();
        }

        @Override
        public BValue[] getNext(int arity) {
            Map.Entry<K, V> next = this.iterator.next();
            if (arity == 1) {
                return new BValue[]{(BValue)next.getValue()};
            }
            return new BValue[]{new BString((String)next.getKey()), (BValue)next.getValue()};
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

