/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.lang.reflect.Array;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BCollection;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.RuntimeErrors;

public abstract class BNewArray
implements BRefType,
BCollection {
    protected static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected static final int DEFAULT_ARRAY_SIZE = 100;
    protected int size = 0;

    public abstract void grow(int var1);

    @Override
    public String stringValue() {
        return null;
    }

    @Override
    public BType getType() {
        return null;
    }

    public BRefType value() {
        return null;
    }

    protected Object newArrayInstance(Class<?> componentType) {
        return Array.newInstance(componentType, 100);
    }

    protected void prepareForAdd(long index, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.resetSize(intIndex);
    }

    protected void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    protected void rangeCheck(long index, int size) {
        if (index > 0x7FFFFFF7L || index < Integer.MIN_VALUE) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        if ((int)index < 0) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    protected void rangeCheckForGet(long index, int size) {
        this.rangeCheck(index, size);
        if (index < 0L || index >= (long)size) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    protected void ensureCapacity(int requestedCapacity, int currentArraySize) {
        if (requestedCapacity - currentArraySize >= 0) {
            int newArraySize = currentArraySize + (currentArraySize >> 1);
            newArraySize = Math.max(newArraySize, requestedCapacity);
            newArraySize = Math.min(newArraySize, 0x7FFFFFF7);
            this.grow(newArraySize);
        }
    }

    public long size() {
        return this.size;
    }

    public abstract BValue getBValue(long var1);

    @Override
    public BIterator newIterator() {
        return new BArrayIterator(this);
    }

    static class BArrayIterator
    implements BIterator {
        BNewArray array;
        long cursor = 0L;
        long length;

        BArrayIterator(BNewArray value) {
            this.array = value;
            this.length = value.size();
        }

        @Override
        public BValue[] getNext(int arity) {
            long cursor = this.cursor++;
            if (arity == 1) {
                return new BValue[]{this.array.getBValue(cursor)};
            }
            return new BValue[]{new BInteger(cursor), this.array.getBValue(cursor)};
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.length;
        }
    }
}

