/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.Arrays;
import java.util.StringJoiner;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;

public class BRefValueArray
extends BNewArray {
    private BType arrayType;
    private BRefType[] values;

    public BRefValueArray(BRefType[] values, BType type) {
        this.values = values;
        this.arrayType = type;
        this.size = values.length;
    }

    public BRefValueArray(BType type) {
        this.arrayType = type;
        this.values = (BRefType[])this.newArrayInstance(BRefType.class);
        Arrays.fill(this.values, type.getEmptyValue());
    }

    public BRefValueArray() {
        this.values = (BRefType[])this.newArrayInstance(BRefType.class);
    }

    public void add(long index, BRefType value) {
        this.prepareForAdd(index, this.values.length);
        this.values[(int)index] = value;
    }

    public BRefType get(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.values[(int)index];
    }

    @Override
    public BType getType() {
        return this.arrayType;
    }

    @Override
    public void grow(int newLength) {
        this.values = Arrays.copyOf(this.values, newLength);
    }

    @Override
    public BValue copy() {
        BRefValueArray refValueArray = new BRefValueArray(Arrays.copyOf(this.values, this.values.length), this.arrayType);
        refValueArray.size = this.size;
        return refValueArray;
    }

    @Override
    public String stringValue() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (int i = 0; i < this.size; ++i) {
            sj.add(this.values[i] == null ? "null" : this.values[i].stringValue());
        }
        return sj.toString();
    }

    @Override
    public BValue getBValue(long index) {
        return this.get(index);
    }
}

