/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.util.exceptions.BallerinaException;

public final class BString
extends BValueType
implements BRefType<String> {
    private String value;

    public BString(String value) {
        this.value = value;
    }

    @Override
    public long intValue() {
        long result;
        try {
            result = Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            throw new BallerinaException("input value " + this.value + " cannot be cast to integer");
        }
        return result;
    }

    @Override
    public double floatValue() {
        double result;
        try {
            result = Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            throw new BallerinaException("input value " + this.value + " cannot be cast to float");
        }
        return result;
    }

    @Override
    public boolean booleanValue() {
        return false;
    }

    @Override
    public byte[] blobValue() {
        return null;
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public BType getType() {
        return BTypes.typeString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BString bString = (BString)o;
        return this.value != null ? this.value.equals(bString.value) : bString.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public BValue copy() {
        return new BString(this.value);
    }
}

