/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.Arrays;
import java.util.StringJoiner;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;

public class BStringArray
extends BNewArray {
    private static BType arrayType = new BArrayType(BTypes.typeString);
    private String[] values;

    public BStringArray(String[] values) {
        this.values = values;
        this.size = values.length;
    }

    public BStringArray() {
        this.values = (String[])this.newArrayInstance(String.class);
        Arrays.fill(this.values, "");
    }

    public void add(long index, String value) {
        this.prepareForAdd(index, this.values.length);
        this.values[(int)index] = value;
    }

    public String get(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.values[(int)index];
    }

    public String[] getStringArray() {
        return this.values;
    }

    @Override
    public BType getType() {
        return arrayType;
    }

    @Override
    public void grow(int newLength) {
        this.values = Arrays.copyOf(this.values, newLength);
    }

    @Override
    public BValue copy() {
        BStringArray stringArray = new BStringArray(Arrays.copyOf(this.values, this.values.length));
        stringArray.size = this.size;
        return stringArray;
    }

    @Override
    public String stringValue() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (int i = 0; i < this.size; ++i) {
            sj.add("\"" + this.values[i] + "\"");
        }
        return sj.toString();
    }

    @Override
    public BValue getBValue(long index) {
        return new BString(this.get(index));
    }
}

