/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringJoiner;
import org.ballerinalang.bre.bvm.VarLock;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.LockableStructureType;

public final class BStruct
implements BRefType,
LockableStructureType {
    private HashMap<String, Object> nativeData = new HashMap();
    private long[] longFields;
    private VarLock[] longLocks;
    private double[] doubleFields;
    private VarLock[] doubleLocks;
    private String[] stringFields;
    private VarLock[] stringLocks;
    private int[] intFields;
    private VarLock[] intLocks;
    private byte[][] byteFields;
    private VarLock[] byteLocks;
    private BRefType[] refFields;
    private VarLock[] refLocks;
    private BStructType structType;

    public BStruct(BStructType structType) {
        this.structType = structType;
        int[] fieldCount = this.structType.getFieldTypeCount();
        this.longFields = new long[fieldCount[0]];
        this.doubleFields = new double[fieldCount[1]];
        this.stringFields = new String[fieldCount[2]];
        this.intFields = new int[fieldCount[3]];
        this.byteFields = new byte[fieldCount[4]][];
        this.refFields = new BRefType[fieldCount[5]];
        Arrays.fill(this.stringFields, "");
    }

    public BStruct value() {
        return this;
    }

    @Override
    public String stringValue() {
        int stringIndex = 0;
        int intIndex = 0;
        int longIndex = 0;
        int doubleIndex = 0;
        int byteIndex = 0;
        int refValIndex = 0;
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        for (BStructType.StructField field : this.structType.getStructFields()) {
            BRefType val;
            byte[] blob;
            String fieldName = field.getFieldName();
            BType fieldType = field.getFieldType();
            Object fieldVal = fieldType == BTypes.typeString ? "\"" + this.stringFields[stringIndex++] + "\"" : (fieldType == BTypes.typeInt ? Long.valueOf(this.longFields[longIndex++]) : (fieldType == BTypes.typeFloat ? Double.valueOf(this.doubleFields[doubleIndex++]) : (fieldType == BTypes.typeBoolean ? Boolean.valueOf(this.intFields[intIndex++] == 1) : (fieldType == BTypes.typeBlob ? ((blob = this.byteFields[byteIndex++]) == null ? null : new String(blob, StandardCharsets.UTF_8)) : ((val = this.refFields[refValIndex++]) == null ? null : val.stringValue())))));
            sj.add(fieldName + ":" + fieldVal);
        }
        return sj.toString();
    }

    @Override
    public BStructType getType() {
        return this.structType;
    }

    @Override
    public long getIntField(int index) {
        return this.longFields[index];
    }

    @Override
    public void setIntField(int index, long value) {
        this.longFields[index] = value;
    }

    @Override
    public double getFloatField(int index) {
        return this.doubleFields[index];
    }

    @Override
    public void setFloatField(int index, double value) {
        this.doubleFields[index] = value;
    }

    @Override
    public String getStringField(int index) {
        return this.stringFields[index];
    }

    @Override
    public void setStringField(int index, String value) {
        this.stringFields[index] = value;
    }

    @Override
    public int getBooleanField(int index) {
        return this.intFields[index];
    }

    @Override
    public byte[] getBlobField(int index) {
        return this.byteFields[index];
    }

    @Override
    public void setBlobField(int index, byte[] value) {
        this.byteFields[index] = value;
    }

    @Override
    public void setBooleanField(int index, int value) {
        this.intFields[index] = value;
    }

    @Override
    public BRefType getRefField(int index) {
        return this.refFields[index];
    }

    @Override
    public void setRefField(int index, BRefType value) {
        this.refFields[index] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean lockIntField(WorkerExecutionContext ctx, int index) {
        long[] lArray;
        if (this.longLocks == null) {
            lArray = this.longFields;
            // MONITORENTER : this.longFields
            if (this.longLocks == null) {
                this.longLocks = new VarLock[this.longFields.length];
            }
            // MONITOREXIT : lArray
        }
        if (this.longLocks[index] != null) return this.longLocks[index].lock(ctx);
        lArray = this.longFields;
        // MONITORENTER : this.longFields
        if (this.longLocks[index] == null) {
            this.longLocks[index] = new VarLock();
        }
        // MONITOREXIT : lArray
        return this.longLocks[index].lock(ctx);
    }

    @Override
    public void unlockIntField(int index) {
        this.longLocks[index].unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean lockFloatField(WorkerExecutionContext ctx, int index) {
        double[] dArray;
        if (this.doubleLocks == null) {
            dArray = this.doubleFields;
            // MONITORENTER : this.doubleFields
            if (this.doubleLocks == null) {
                this.doubleLocks = new VarLock[this.doubleFields.length];
            }
            // MONITOREXIT : dArray
        }
        if (this.doubleLocks[index] != null) return this.doubleLocks[index].lock(ctx);
        dArray = this.doubleFields;
        // MONITORENTER : this.doubleFields
        if (this.doubleLocks[index] == null) {
            this.doubleLocks[index] = new VarLock();
        }
        // MONITOREXIT : dArray
        return this.doubleLocks[index].lock(ctx);
    }

    @Override
    public void unlockFloatField(int index) {
        this.doubleLocks[index].unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean lockStringField(WorkerExecutionContext ctx, int index) {
        String[] stringArray;
        if (this.stringLocks == null) {
            stringArray = this.stringFields;
            // MONITORENTER : this.stringFields
            if (this.stringLocks == null) {
                this.stringLocks = new VarLock[this.stringFields.length];
            }
            // MONITOREXIT : stringArray
        }
        if (this.stringLocks[index] != null) return this.stringLocks[index].lock(ctx);
        stringArray = this.stringFields;
        // MONITORENTER : this.stringFields
        if (this.stringLocks[index] == null) {
            this.stringLocks[index] = new VarLock();
        }
        // MONITOREXIT : stringArray
        return this.stringLocks[index].lock(ctx);
    }

    @Override
    public void unlockStringField(int index) {
        this.stringLocks[index].unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean lockBooleanField(WorkerExecutionContext ctx, int index) {
        int[] nArray;
        if (this.intLocks == null) {
            nArray = this.intFields;
            // MONITORENTER : this.intFields
            if (this.intLocks == null) {
                this.intLocks = new VarLock[this.intFields.length];
            }
            // MONITOREXIT : nArray
        }
        if (this.intLocks[index] != null) return this.intLocks[index].lock(ctx);
        nArray = this.intFields;
        // MONITORENTER : this.intFields
        if (this.intLocks[index] == null) {
            this.intLocks[index] = new VarLock();
        }
        // MONITOREXIT : nArray
        return this.intLocks[index].lock(ctx);
    }

    @Override
    public void unlockBooleanField(int index) {
        this.intLocks[index].unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean lockBlobField(WorkerExecutionContext ctx, int index) {
        byte[][] byArray;
        if (this.byteLocks == null) {
            byArray = this.byteFields;
            // MONITORENTER : this.byteFields
            if (this.byteLocks == null) {
                this.byteLocks = new VarLock[this.byteFields.length];
            }
            // MONITOREXIT : byArray
        }
        if (this.byteLocks[index] != null) return this.byteLocks[index].lock(ctx);
        byArray = this.byteFields;
        // MONITORENTER : this.byteFields
        if (this.byteLocks[index] == null) {
            this.byteLocks[index] = new VarLock();
        }
        // MONITOREXIT : byArray
        return this.byteLocks[index].lock(ctx);
    }

    @Override
    public void unlockBlobField(int index) {
        this.byteLocks[index].unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean lockRefField(WorkerExecutionContext ctx, int index) {
        BRefType[] bRefTypeArray;
        if (this.refLocks == null) {
            bRefTypeArray = this.refFields;
            // MONITORENTER : this.refFields
            if (this.refLocks == null) {
                this.refLocks = new VarLock[this.refFields.length];
            }
            // MONITOREXIT : bRefTypeArray
        }
        if (this.refLocks[index] != null) return this.refLocks[index].lock(ctx);
        bRefTypeArray = this.refFields;
        // MONITORENTER : this.refFields
        if (this.refLocks[index] == null) {
            this.refLocks[index] = new VarLock();
        }
        // MONITOREXIT : bRefTypeArray
        return this.refLocks[index].lock(ctx);
    }

    @Override
    public void unlockRefField(int index) {
        this.refLocks[index].unlock();
    }

    @Override
    public BValue copy() {
        BStruct bStruct = new BStruct(this.structType);
        bStruct.longFields = Arrays.copyOf(this.longFields, this.longFields.length);
        bStruct.doubleFields = Arrays.copyOf(this.doubleFields, this.doubleFields.length);
        bStruct.stringFields = Arrays.copyOf(this.stringFields, this.stringFields.length);
        bStruct.intFields = Arrays.copyOf(this.intFields, this.intFields.length);
        bStruct.byteFields = (byte[][])Arrays.copyOf(this.byteFields, this.byteFields.length);
        bStruct.refFields = Arrays.copyOf(this.refFields, this.refFields.length);
        return bStruct;
    }

    public void addNativeData(String key, Object data) {
        this.nativeData.put(key, data);
    }

    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    public String toString() {
        return this.stringValue();
    }
}

