/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.List;
import java.util.StringJoiner;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.DataIterator;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BTableType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BCollection;
import org.ballerinalang.model.values.BFunctionPointer;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.TableProvider;
import org.ballerinalang.util.TableUtils;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.program.BLangFunctions;

public class BTable
implements BRefType<Object>,
BCollection {
    protected DataIterator iterator;
    private boolean hasNextVal;
    private boolean nextPrefetched;
    private TableProvider tableProvider;
    private String tableName;
    protected BStructType constraintType;
    private BStringArray primaryKeys;
    private BStringArray indices;
    private boolean isInMemoryTable;
    private boolean loadSQLTableToMemory;
    private boolean tableClosed;

    public BTable() {
        this.iterator = null;
        this.tableProvider = null;
        this.nextPrefetched = false;
        this.hasNextVal = false;
        this.tableName = null;
        this.constraintType = null;
        this.isInMemoryTable = false;
    }

    public BTable(DataIterator dataIterator, boolean loadSQLTableToMemory) {
        this.iterator = dataIterator;
        this.nextPrefetched = false;
        this.hasNextVal = false;
        this.tableProvider = null;
        this.tableName = null;
        this.constraintType = null;
        this.isInMemoryTable = false;
        this.loadSQLTableToMemory = loadSQLTableToMemory;
    }

    public BTable(String tableName, BStructType constraintType) {
        this.nextPrefetched = false;
        this.hasNextVal = false;
        this.tableProvider = null;
        this.tableName = tableName;
        this.isInMemoryTable = false;
        this.constraintType = constraintType;
    }

    public BTable(String query, BTable fromTable, BTable joinTable, BStructType constraintType, BRefValueArray params) {
        this.tableProvider = TableProvider.getInstance();
        this.tableName = joinTable != null ? this.tableProvider.createTable(fromTable.tableName, joinTable.tableName, query, constraintType, params) : this.tableProvider.createTable(fromTable.tableName, query, constraintType, params);
        this.constraintType = constraintType;
        this.isInMemoryTable = true;
    }

    public BTable(BType type, BStruct configStruct) {
        BType constrainedType;
        BStringArray primaryKeys = null;
        BStringArray indexColumns = null;
        BRefValueArray data = null;
        if (configStruct != null) {
            primaryKeys = (BStringArray)configStruct.getRefField(0);
            indexColumns = (BStringArray)configStruct.getRefField(1);
            data = (BRefValueArray)configStruct.getRefField(2);
        }
        if ((constrainedType = ((BTableType)type).getConstrainedType()) == null) {
            throw new BallerinaException("table cannot be created without a constraint");
        }
        this.tableProvider = TableProvider.getInstance();
        this.tableName = this.tableProvider.createTable(constrainedType, primaryKeys, indexColumns);
        this.constraintType = (BStructType)constrainedType;
        this.primaryKeys = primaryKeys;
        this.indices = indexColumns;
        this.isInMemoryTable = true;
        if (data != null) {
            this.insertInitialData(data);
        }
    }

    @Override
    public Object value() {
        return null;
    }

    @Override
    public String stringValue() {
        if (!this.isInMemoryTable) {
            return "";
        }
        String constraint = this.constraintType != null ? "<" + this.constraintType.toString() + ">" : "";
        StringBuilder tableWrapper = new StringBuilder("table" + constraint + " ");
        StringJoiner tableContent = new StringJoiner(", ", "{", "}");
        tableContent.add(this.createStringValueEntry("index", this.indices));
        tableContent.add(this.createStringValueEntry("primaryKey", this.primaryKeys));
        tableContent.add(this.createStringValueDataEntry());
        tableWrapper.append(tableContent.toString());
        return tableWrapper.toString();
    }

    private String createStringValueEntry(String key, BStringArray contents) {
        return key + ": " + contents.stringValue();
    }

    private String createStringValueDataEntry() {
        StringBuilder sb = new StringBuilder();
        sb.append("data: ");
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        while (this.hasNext(false)) {
            BStruct struct = this.getNext();
            sj.add(struct.stringValue());
        }
        sb.append(sj.toString());
        return sb.toString();
    }

    @Override
    public BType getType() {
        return BTypes.typeTable;
    }

    public boolean hasNext(boolean isInTransaction) {
        if (this.tableClosed) {
            throw new BallerinaException("Trying to perform hasNext operation over a closed table");
        }
        if (this.isIteratorGenerationConditionMet()) {
            this.generateIterator();
        }
        if (!this.nextPrefetched) {
            this.hasNextVal = this.iterator.next();
            this.nextPrefetched = true;
        }
        if (!this.hasNextVal) {
            this.reset(isInTransaction);
        }
        return this.hasNextVal;
    }

    public void next() {
        if (this.tableClosed) {
            throw new BallerinaException("Trying to perform an operation over a closed table");
        }
        if (this.isIteratorGenerationConditionMet()) {
            this.generateIterator();
        }
        if (!this.nextPrefetched) {
            this.iterator.next();
        } else {
            this.nextPrefetched = false;
        }
    }

    public void close(boolean isInTransaction) {
        if (this.iterator != null) {
            this.iterator.close(isInTransaction);
        }
        this.tableClosed = true;
    }

    public void reset(boolean isInTransaction) {
        if (this.loadSQLTableToMemory) {
            this.iterator.reset(false);
        } else if (this.isInMemoryTable) {
            if (this.iterator != null) {
                this.iterator.reset(false);
                this.iterator = null;
            }
        } else if (this.iterator != null) {
            this.iterator.reset(isInTransaction);
        }
        this.resetIterationHelperAttributes();
    }

    public BStruct getNext() {
        this.next();
        return this.iterator.generateNext();
    }

    public void performAddOperation(BStruct data, Context context) {
        try {
            this.addData(data, context);
            context.setReturnValues(new BValue[0]);
        }
        catch (Throwable e) {
            context.setReturnValues(TableUtils.createTableOperationError(context, e));
        }
    }

    public void addData(BStruct data, Context context) {
        if (!this.isInMemoryTable) {
            throw new BallerinaException("data cannot be added to a table returned from a database");
        }
        if (data.getType() != this.constraintType) {
            throw new BallerinaException("incompatible types: struct of type:" + data.getType().getName() + " cannot be added to a table with type:" + this.constraintType.getName());
        }
        this.tableProvider.insertData(this.tableName, data);
        this.reset(false);
    }

    public void addData(BStruct data) {
        this.addData(data, null);
    }

    public void performRemoveOperation(Context context, BFunctionPointer lambdaFunction) {
        try {
            if (!this.isInMemoryTable) {
                throw new BallerinaException("data cannot be deleted from a table returned from a database");
            }
            int deletedCount = 0;
            while (this.hasNext(false)) {
                BStruct data = this.getNext();
                BValue[] args = new BValue[]{data};
                BValue[] returns = BLangFunctions.invokeCallable((CallableUnitInfo)lambdaFunction.value().getFunctionInfo(), args);
                if (!((BBoolean)returns[0]).booleanValue()) continue;
                ++deletedCount;
                this.removeData(data);
            }
            context.setReturnValues(new BInteger(deletedCount));
            this.reset(false);
        }
        catch (Throwable e) {
            context.setReturnValues(TableUtils.createTableOperationError(context, e));
        }
    }

    private void removeData(BStruct data) {
        this.tableProvider.deleteData(this.tableName, data);
    }

    public String getString(int columnIndex) {
        return this.iterator.getString(columnIndex);
    }

    public long getInt(int columnIndex) {
        return this.iterator.getInt(columnIndex);
    }

    public double getFloat(int columnIndex) {
        return this.iterator.getFloat(columnIndex);
    }

    public boolean getBoolean(int columnIndex) {
        return this.iterator.getBoolean(columnIndex);
    }

    public String getBlob(int columnIndex) {
        return this.iterator.getBlob(columnIndex);
    }

    public Object[] getStruct(int columnIndex) {
        return this.iterator.getStruct(columnIndex);
    }

    public Object[] getArray(int columnIndex) {
        return this.iterator.getArray(columnIndex);
    }

    public List<ColumnDefinition> getColumnDefs() {
        return this.iterator.getColumnDefinitions();
    }

    public BStructType getStructType() {
        return this.iterator.getStructType();
    }

    @Override
    public BValue copy() {
        return null;
    }

    @Override
    public BIterator newIterator() {
        return new BTableIterator(this);
    }

    protected void generateIterator() {
        this.iterator = this.tableProvider.createIterator(this.tableName, this.constraintType);
        this.resetIterationHelperAttributes();
    }

    protected boolean isIteratorGenerationConditionMet() {
        return this.isInMemoryTable && this.iterator == null;
    }

    protected void resetIterationHelperAttributes() {
        this.nextPrefetched = false;
        this.hasNextVal = false;
    }

    protected void finalize() {
        if (this.isInMemoryTable) {
            if (this.iterator != null) {
                this.iterator.close(false);
            }
            this.tableProvider.dropTable(this.tableName);
        }
    }

    private void insertInitialData(BRefValueArray data) {
        int count = (int)data.size();
        for (int i = 0; i < count; ++i) {
            if (!(data.get(i) instanceof BStruct)) {
                throw new BallerinaException("initial data should be in struct type");
            }
            this.addData((BStruct)data.get(i));
        }
    }

    protected boolean iteratorResetRequired() {
        return this.isInMemoryTable;
    }

    private static class BTableIterator<K, V extends BValue>
    implements BIterator {
        private BTable table;
        private int cursor = 0;

        BTableIterator(BTable value) {
            this.table = value;
        }

        @Override
        public BValue[] getNext(int arity) {
            if (arity == 1) {
                return new BValue[]{this.table.getNext()};
            }
            int cursor = this.cursor++;
            return new BValue[]{new BInteger(cursor), this.table.getNext()};
        }

        @Override
        public boolean hasNext() {
            return this.table.hasNext(false);
        }
    }
}

