/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.runtime.message;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.ballerinalang.runtime.message.BallerinaMessageDataSource;
import org.ballerinalang.util.exceptions.BallerinaException;

public class StringDataSource
extends BallerinaMessageDataSource {
    private String value;

    public StringDataSource(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void serializeData(OutputStream outputStream) {
        try {
            outputStream.write(this.value.getBytes(Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new BallerinaException("Error occurred during writing the string message to the output stream", e);
        }
    }

    @Override
    public String getMessageAsString() {
        return this.value;
    }

    @Override
    public BallerinaMessageDataSource clone() {
        String clonedContent = this.getMessageAsString();
        return new StringDataSource(clonedContent);
    }
}

