/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.util.TableIterator;
import org.ballerinalang.util.TableResourceManager;
import org.ballerinalang.util.TableUtils;
import org.ballerinalang.util.exceptions.BallerinaException;

public class TableProvider {
    private static TableProvider tableProvider = null;
    private int tableID = 0;
    private int indexID = 0;

    private TableProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableProvider getInstance() {
        if (tableProvider != null) {
            return tableProvider;
        }
        Class<TableProvider> clazz = TableProvider.class;
        synchronized (TableProvider.class) {
            if (tableProvider == null) {
                tableProvider = new TableProvider();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return tableProvider;
        }
    }

    private synchronized int getTableID() {
        return this.tableID++;
    }

    private synchronized int getIndexID() {
        return this.indexID++;
    }

    public String createTable(BType constrainedType, BStringArray primaryKeys, BStringArray indexeColumns) {
        String tableName = "TABLE_" + constrainedType.getName().toUpperCase() + "_" + this.getTableID();
        String sqlStmt = this.generateCreateTableStatment(tableName, constrainedType, primaryKeys);
        this.executeStatement(sqlStmt);
        if (indexeColumns != null) {
            this.generateIndexesForTable(tableName, indexeColumns);
        }
        return tableName;
    }

    public String createTable(String fromTableName, String joinTableName, String query, BStructType tableType, BRefValueArray params) {
        String newTableName = "TABLE_" + tableType.getName().toUpperCase() + "_" + this.getTableID();
        String sqlStmt = query.replaceFirst("\\[\\[tableName\\]\\]", fromTableName);
        if (joinTableName != null && !joinTableName.isEmpty()) {
            sqlStmt = sqlStmt.replaceFirst("\\[\\[tableName\\]\\]", joinTableName);
        }
        sqlStmt = this.generateCreateTableStatment(sqlStmt, newTableName);
        this.prepareAndExecuteStatement(sqlStmt, params);
        return newTableName;
    }

    public String createTable(String fromTableName, String query, BStructType tableType, BRefValueArray params) {
        return this.createTable(fromTableName, null, query, tableType, params);
    }

    public String insertData(String tableName, BStruct constrainedType) {
        String sqlStmt = TableUtils.generateInsertDataStatment(tableName, constrainedType);
        this.prepareAndExecuteStatement(sqlStmt, constrainedType);
        return tableName;
    }

    public void deleteData(String tableName, BStruct constrainedType) {
        String sqlStmt = TableUtils.generateDeleteDataStatment(tableName, constrainedType);
        this.prepareAndExecuteStatement(sqlStmt, constrainedType);
    }

    public void dropTable(String tableName) {
        String sqlStmt = "DROP TABLE " + tableName;
        this.executeStatement(sqlStmt);
    }

    public TableIterator createIterator(String tableName, BStructType type) {
        TableIterator itr;
        Statement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
            TableResourceManager rm = new TableResourceManager(conn, stmt);
            rm.addResultSet(rs);
            itr = new TableIterator(rm, rs, type);
        }
        catch (SQLException e) {
            this.releaseResources(conn, stmt);
            throw new BallerinaException("error in creating iterator for table : " + e.getMessage());
        }
        return itr;
    }

    private Connection getConnection() {
        Connection conn;
        try {
            conn = DriverManager.getConnection("jdbc:h2:mem:TABLEDB;DB_CLOSE_DELAY=-1", "sa", "");
        }
        catch (SQLException e) {
            throw new BallerinaException("error in gettign connection for table db : " + e.getMessage());
        }
        return conn;
    }

    private String generateCreateTableStatment(String tableName, BType constrainedType, BStringArray primaryKeys) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(tableName).append(" (");
        BStructType.StructField[] structFields = ((BStructType)constrainedType).getStructFields();
        String seperator = "";
        for (BStructType.StructField sf : structFields) {
            int type = sf.getFieldType().getTag();
            String name = sf.getFieldName();
            sb.append(seperator).append(name).append(" ");
            switch (type) {
                case 1: {
                    sb.append("BIGINT");
                    break;
                }
                case 3: {
                    sb.append("CLOB");
                    break;
                }
                case 2: {
                    sb.append("DOUBLE");
                    break;
                }
                case 4: {
                    sb.append("BOOLEAN");
                    break;
                }
                case 8: 
                case 9: {
                    sb.append("CLOB");
                    break;
                }
                case 5: {
                    sb.append("BLOB");
                    break;
                }
                case 16: {
                    sb.append("ARRAY");
                    break;
                }
                default: {
                    throw new BallerinaException("Unsupported column type for table : " + sf.getFieldType());
                }
            }
            seperator = ",";
        }
        if (primaryKeys != null) {
            seperator = "";
            int primaryKeyCount = (int)primaryKeys.size();
            if (primaryKeyCount > 0) {
                sb.append(",PRIMARY KEY (");
                for (int i = 0; i < primaryKeyCount; ++i) {
                    sb.append(seperator).append(primaryKeys.get(i));
                    seperator = ",";
                }
                sb.append(")");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private String generateCreateTableStatment(String query, String newTableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(newTableName).append(" ").append("AS ");
        sb.append(query);
        return sb.toString();
    }

    private void generateIndexesForTable(String tableName, BStringArray indexColumns) {
        int indexCount = (int)indexColumns.size();
        if (indexCount > 0) {
            for (int i = 0; i < indexCount; ++i) {
                StringBuilder sb = new StringBuilder();
                String columnName = indexColumns.get(i);
                sb.append("CREATE INDEX ").append("IDX_").append(columnName).append(this.getIndexID()).append(" ON ").append(tableName).append("(").append(columnName).append(")");
                this.executeStatement(sb.toString());
            }
        }
    }

    private void executeStatement(String queryStatement) {
        Statement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(queryStatement);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in executing statement : " + queryStatement + " error:" + e.getMessage());
        }
        finally {
            this.releaseResources(conn, stmt);
        }
    }

    private void prepareAndExecuteStatement(String queryStatement, BRefValueArray params) {
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.prepareStatement(queryStatement);
            int index = 1;
            while ((long)index <= params.size()) {
                BRefType param = params.get(index - 1);
                switch (param.getType().getTag()) {
                    case 1: {
                        stmt.setLong(index, (Long)param.value());
                        break;
                    }
                    case 3: {
                        stmt.setString(index, (String)param.value());
                        break;
                    }
                    case 2: {
                        stmt.setDouble(index, (Double)param.value());
                        break;
                    }
                    case 4: {
                        stmt.setBoolean(index, (Boolean)param.value());
                        break;
                    }
                    case 8: 
                    case 9: {
                        stmt.setString(index, (String)param.value());
                        break;
                    }
                    case 5: {
                        byte[] blobData = (byte[])param.value();
                        stmt.setBlob(index, new ByteArrayInputStream(blobData), blobData.length);
                        break;
                    }
                    case 16: {
                        Object[] arrayData = TableUtils.getArrayData(param);
                        stmt.setObject(index, arrayData);
                    }
                }
                ++index;
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new BallerinaException("error in executing statement : " + queryStatement + " error:" + e.getMessage());
        }
        finally {
            this.releaseResources(conn, stmt);
        }
    }

    private void prepareAndExecuteStatement(String queryStatement, BStruct constrainedType) {
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.prepareStatement(queryStatement);
            TableUtils.prepareAndExecuteStatement(stmt, constrainedType);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in executing statement : " + queryStatement + " error:" + e.getMessage());
        }
        finally {
            this.releaseResources(conn, stmt);
        }
    }

    private void releaseResources(Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in releasing table statement resource : " + e.getMessage());
        }
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in releasing table connection resource : " + e.getMessage());
        }
    }
}

