/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.util.codegen.AnnAttachmentInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.WorkerDataChannelInfo;
import org.ballerinalang.util.codegen.WorkerInfo;
import org.ballerinalang.util.codegen.attributes.AnnotationAttributeInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfoPool;
import org.ballerinalang.util.codegen.cpentries.WorkerInfoPool;
import org.ballerinalang.util.program.WorkerDataIndex;

public class CallableUnitInfo
implements AttributeInfoPool,
WorkerInfoPool {
    protected String pkgPath;
    protected String name;
    protected boolean isNative;
    protected int pkgCPIndex;
    protected int nameCPIndex;
    protected BType[] paramTypes;
    protected BType[] retParamTypes;
    protected int signatureCPIndex;
    protected String signature;
    public int attachedToTypeCPIndex;
    public BType attachedToType;
    protected Map<AttributeInfo.Kind, AttributeInfo> attributeInfoMap = new HashMap<AttributeInfo.Kind, AttributeInfo>();
    private Map<String, WorkerDataChannelInfo> dataChannelInfoMap = new HashMap<String, WorkerDataChannelInfo>();
    private PackageInfo packageInfo;
    protected WorkerInfo defaultWorkerInfo;
    protected Map<String, WorkerInfo> workerInfoMap = new HashMap<String, WorkerInfo>();
    public WorkerDataIndex paramWorkerIndex;
    public WorkerDataIndex retWorkerIndex;
    private NativeCallableUnit nativeCallableUnit;
    private WorkerSet workerSet = new WorkerSet();

    private WorkerDataIndex calculateWorkerDataIndex(BType[] retTypes) {
        WorkerDataIndex index = new WorkerDataIndex();
        index.retRegs = new int[retTypes.length];
        block7: for (int i = 0; i < retTypes.length; ++i) {
            BType retType = retTypes[i];
            switch (retType.getTag()) {
                case 1: {
                    ++index.longRegCount;
                    continue block7;
                }
                case 2: {
                    ++index.doubleRegCount;
                    continue block7;
                }
                case 3: {
                    ++index.stringRegCount;
                    continue block7;
                }
                case 4: {
                    ++index.intRegCount;
                    continue block7;
                }
                case 5: {
                    ++index.byteRegCount;
                    continue block7;
                }
                default: {
                    ++index.refRegCount;
                }
            }
        }
        return index;
    }

    public String getName() {
        return this.name;
    }

    public String getPkgPath() {
        return this.pkgPath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPackageCPIndex() {
        return this.pkgCPIndex;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public int getNameCPIndex() {
        return this.nameCPIndex;
    }

    public void setNameCPIndex(int nameCPIndex) {
        this.nameCPIndex = nameCPIndex;
    }

    public void setPackageInfo(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public void setNative(boolean aNative) {
        this.isNative = aNative;
    }

    public BType[] getParamTypes() {
        return this.paramTypes;
    }

    public void setParamTypes(BType[] paramTypes) {
        this.paramTypes = paramTypes;
        this.paramWorkerIndex = this.calculateWorkerDataIndex(this.paramTypes);
    }

    public BType[] getRetParamTypes() {
        return this.retParamTypes;
    }

    public void setRetParamTypes(BType[] retParamType) {
        this.retParamTypes = retParamType;
        this.retWorkerIndex = this.calculateWorkerDataIndex(this.retParamTypes);
    }

    public String getSignature() {
        if (this.signature != null) {
            return this.signature;
        }
        StringBuilder strBuilder = new StringBuilder("(");
        for (BType paramType : this.paramTypes) {
            strBuilder.append(paramType.getSig());
        }
        strBuilder.append(")(");
        for (BType retType : this.retParamTypes) {
            strBuilder.append(retType.getSig());
        }
        strBuilder.append(")");
        this.signature = strBuilder.toString();
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public int getSignatureCPIndex() {
        return this.signatureCPIndex;
    }

    public void setSignatureCPIndex(int signatureCPIndex) {
        this.signatureCPIndex = signatureCPIndex;
    }

    public WorkerInfo getDefaultWorkerInfo() {
        return this.defaultWorkerInfo;
    }

    public void setDefaultWorkerInfo(WorkerInfo defaultWorkerInfo) {
        this.defaultWorkerInfo = defaultWorkerInfo;
        this.pupulateWorkerSet();
    }

    public WorkerInfo getWorkerInfo(String workerName) {
        return this.workerInfoMap.get(workerName);
    }

    public void addWorkerInfo(String workerName, WorkerInfo workerInfo) {
        this.workerInfoMap.put(workerName, workerInfo);
        this.pupulateWorkerSet();
    }

    public Map<String, WorkerInfo> getWorkerInfoMap() {
        return this.workerInfoMap;
    }

    private void pupulateWorkerSet() {
        this.workerSet.generalWorkers = this.workerInfoMap.values().toArray(new WorkerInfo[0]);
        if (this.workerSet.generalWorkers.length == 0) {
            this.workerSet.generalWorkers = new WorkerInfo[]{this.getDefaultWorkerInfo()};
        } else {
            this.workerSet.initWorker = this.getDefaultWorkerInfo();
        }
    }

    public WorkerSet getWorkerSet() {
        return this.workerSet;
    }

    @Override
    public AttributeInfo getAttributeInfo(AttributeInfo.Kind attributeKind) {
        return this.attributeInfoMap.get((Object)attributeKind);
    }

    @Override
    public void addAttributeInfo(AttributeInfo.Kind attributeKind, AttributeInfo attributeInfo) {
        this.attributeInfoMap.put(attributeKind, attributeInfo);
    }

    @Override
    public AttributeInfo[] getAttributeInfoEntries() {
        return this.attributeInfoMap.values().toArray(new AttributeInfo[0]);
    }

    @Deprecated
    public AnnAttachmentInfo getAnnotationAttachmentInfo(String packageName, String annotationName) {
        AnnotationAttributeInfo attributeInfo = (AnnotationAttributeInfo)this.getAttributeInfo(AttributeInfo.Kind.ANNOTATIONS_ATTRIBUTE);
        if (attributeInfo == null || packageName == null || annotationName == null) {
            return null;
        }
        for (AnnAttachmentInfo annotationInfo : attributeInfo.getAttachmentInfoEntries()) {
            if (!packageName.equals(annotationInfo.getPkgPath()) || !annotationName.equals(annotationInfo.getName())) continue;
            return annotationInfo;
        }
        return null;
    }

    @Override
    public void addWorkerDataChannelInfo(WorkerDataChannelInfo workerDataChannelInfo) {
        this.dataChannelInfoMap.put(workerDataChannelInfo.getChannelName(), workerDataChannelInfo);
    }

    @Override
    public WorkerDataChannelInfo getWorkerDataChannelInfo(String name) {
        return this.dataChannelInfoMap.get(name);
    }

    @Override
    public WorkerDataChannelInfo[] getWorkerDataChannelInfo() {
        return this.dataChannelInfoMap.values().toArray(new WorkerDataChannelInfo[0]);
    }

    public NativeCallableUnit getNativeCallableUnit() {
        return this.nativeCallableUnit;
    }

    public void setNativeCallableUnit(NativeCallableUnit nativeCallableUnit) {
        this.nativeCallableUnit = nativeCallableUnit;
    }

    public static class WorkerSet {
        public WorkerInfo initWorker;
        public WorkerInfo[] generalWorkers;
    }
}

