/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.util.Arrays;
import java.util.StringJoiner;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.Mnemonics;
import org.ballerinalang.util.codegen.TransformerInfo;
import org.ballerinalang.util.codegen.WorkerDataChannelInfo;
import org.ballerinalang.util.codegen.cpentries.ForkJoinCPEntry;

public class Instruction {
    int opcode;
    int[] operands;

    Instruction(int opcode, int ... operands) {
        this.opcode = opcode;
        this.operands = operands;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public int[] getOperands() {
        return this.operands;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(" ");
        Arrays.stream(this.operands).forEach(i -> sj.add(String.valueOf(i)));
        return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
    }

    public static class InstructionLock
    extends Instruction {
        public BType[] types;
        public int[] pkgRefs;
        public int[] varRegs;

        InstructionLock(int opcode, BType[] types, int[] pkgRefs, int[] varRegs) {
            super(opcode, new int[0]);
            this.types = types;
            this.pkgRefs = pkgRefs;
            this.varRegs = varRegs;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            for (int i = 0; i < this.varRegs.length; ++i) {
                sj.add(this.types[i].toString());
                sj.add(String.valueOf(this.pkgRefs[i]));
                sj.add(String.valueOf(this.varRegs[i]));
            }
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionIteratorNext
    extends Instruction {
        public int iteratorIndex;
        public int arity;
        public int[] typeTags;
        public int[] retRegs;

        InstructionIteratorNext(int opcode, int iteratorIndex, int arity, int[] typeTags, int[] retRegs) {
            super(opcode, new int[0]);
            this.iteratorIndex = iteratorIndex;
            this.arity = arity;
            this.typeTags = typeTags;
            this.retRegs = retRegs;
        }
    }

    public static class InstructionFORKJOIN
    extends Instruction {
        public int forkJoinCPIndex;
        public ForkJoinCPEntry forkJoinCPEntry;
        public int timeoutRegIndex;
        public int joinVarRegIndex;
        public int joinBlockAddr;
        public int timeoutVarRegIndex;
        public int timeoutBlockAddr;

        public InstructionFORKJOIN(int opcode, int forkJoinCPIndex, ForkJoinCPEntry forkJoinCPEntry, int timeoutRegIndex, int joinVarRegIndex, int joinBlockAddr, int timeoutVarRegIndex, int timeoutBlockAddr) {
            super(opcode, new int[0]);
            this.forkJoinCPIndex = forkJoinCPIndex;
            this.forkJoinCPEntry = forkJoinCPEntry;
            this.timeoutRegIndex = timeoutRegIndex;
            this.joinVarRegIndex = joinVarRegIndex;
            this.joinBlockAddr = joinBlockAddr;
            this.timeoutVarRegIndex = timeoutVarRegIndex;
            this.timeoutBlockAddr = timeoutBlockAddr;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.forkJoinCPIndex));
            sj.add(String.valueOf(this.timeoutRegIndex));
            sj.add(String.valueOf(this.joinVarRegIndex));
            sj.add(String.valueOf(this.joinBlockAddr));
            sj.add(String.valueOf(this.timeoutVarRegIndex));
            sj.add(String.valueOf(this.timeoutBlockAddr));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionWRKSendReceive
    extends Instruction {
        public int channelRefCPIndex;
        public WorkerDataChannelInfo dataChannelInfo;
        public int sigCPIndex;
        public BType type;
        public int reg;

        InstructionWRKSendReceive(int opcode, int channelRefCPIndex, WorkerDataChannelInfo dataChannelInfo, int sigCPIndex, BType type, int reg) {
            super(opcode, new int[0]);
            this.channelRefCPIndex = channelRefCPIndex;
            this.dataChannelInfo = dataChannelInfo;
            this.sigCPIndex = sigCPIndex;
            this.type = type;
            this.reg = reg;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.channelRefCPIndex));
            sj.add(String.valueOf(this.sigCPIndex));
            sj.add(String.valueOf(this.reg));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionTCALL
    extends Instruction {
        public int transformerRefCPIndex;
        public TransformerInfo transformerInfo;
        public int flags;
        public int[] argRegs;
        public int[] retRegs;

        InstructionTCALL(int opcode, int transformerRefCPIndex, TransformerInfo transformerInfo, int flags, int[] argRegs, int[] retRegs) {
            super(opcode, new int[0]);
            this.transformerRefCPIndex = transformerRefCPIndex;
            this.transformerInfo = transformerInfo;
            this.flags = flags;
            this.argRegs = argRegs;
            this.retRegs = retRegs;
        }
    }

    public static class InstructionACALL
    extends Instruction {
        public int actionRefCPIndex;
        public String actionName;
        public int flags;
        public int[] argRegs;
        public int[] retRegs;

        InstructionACALL(int opcode, int actionRefCPIndex, String actionName, int flags, int[] argRegs, int[] retRegs) {
            super(opcode, new int[0]);
            this.actionRefCPIndex = actionRefCPIndex;
            this.actionName = actionName;
            this.flags = flags;
            this.argRegs = argRegs;
            this.retRegs = retRegs;
        }
    }

    public static class InstructionVCALL
    extends InstructionCALL {
        public int receiverRegIndex;

        InstructionVCALL(int opcode, int receiverRegIndex, int funcRefCPIndex, FunctionInfo functionInfo, int flags, int[] argRegs, int[] retRegs) {
            super(opcode, funcRefCPIndex, functionInfo, flags, argRegs, retRegs);
            this.receiverRegIndex = receiverRegIndex;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.receiverRegIndex));
            sj.add(String.valueOf(this.funcRefCPIndex));
            sj.add(String.valueOf(this.argRegs.length));
            Arrays.stream(this.argRegs).forEach(i -> sj.add(String.valueOf(i)));
            sj.add(String.valueOf(this.retRegs.length));
            Arrays.stream(this.retRegs).forEach(i -> sj.add(String.valueOf(i)));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionCALL
    extends Instruction {
        public int funcRefCPIndex;
        public FunctionInfo functionInfo;
        public int flags;
        public int[] argRegs;
        public int[] retRegs;

        InstructionCALL(int opcode, int funcRefCPIndex, FunctionInfo functionInfo, int flags, int[] argRegs, int[] retRegs) {
            super(opcode, new int[0]);
            this.funcRefCPIndex = funcRefCPIndex;
            this.functionInfo = functionInfo;
            this.flags = flags;
            this.argRegs = argRegs;
            this.retRegs = retRegs;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.funcRefCPIndex));
            sj.add(String.valueOf(this.flags));
            sj.add(String.valueOf(this.argRegs.length));
            Arrays.stream(this.argRegs).forEach(i -> sj.add(String.valueOf(i)));
            sj.add(String.valueOf(this.retRegs.length));
            Arrays.stream(this.retRegs).forEach(i -> sj.add(String.valueOf(i)));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }
}

